/*
 * Decompiled with CFR 0.152.
 */
package net.unusual.blockfactorysbosses;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.unusual.blockfactorysbosses.AnimationTickHolder;
import net.unusual.blockfactorysbosses.DragonBonesFirstPersonRenderer;
import net.unusual.blockfactorysbosses.KnightFirstPersonRenderer;

@EventBusSubscriber(value={Dist.CLIENT})
public class ClientEvents {
    @SubscribeEvent
    public static void onTickPre(ClientTickEvent.Pre event) {
        ClientEvents.onTick(true);
    }

    @SubscribeEvent
    public static void onTickPost(ClientTickEvent.Post event) {
        ClientEvents.onTick(false);
    }

    public static void onTick(boolean isPreEvent) {
        if (!ClientEvents.isGameActive()) {
            return;
        }
        DragonBonesFirstPersonRenderer.clientTick();
        KnightFirstPersonRenderer.clientTick();
        AnimationTickHolder.tick();
    }

    @SubscribeEvent
    public static void onLoadWorld(LevelEvent.Load event) {
        LevelAccessor world = event.getLevel();
        if (world.isClientSide() && world instanceof ClientLevel) {
            AnimationTickHolder.reset();
        }
    }

    @SubscribeEvent
    public static void onUnloadWorld(LevelEvent.Unload event) {
        if (!event.getLevel().isClientSide()) {
            return;
        }
        AnimationTickHolder.reset();
    }

    protected static boolean isGameActive() {
        return Minecraft.getInstance().level != null && Minecraft.getInstance().player != null;
    }
}

