/*
 * Decompiled with CFR 0.152.
 */
package net.unusual.blockfactorysbosses.entity;

import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.unusual.blockfactorysbosses.configuration.ConfigFileConfiguration;
import net.unusual.blockfactorysbosses.entity.NullPrEntity;
import net.unusual.blockfactorysbosses.entity.SlowRotMoveControl;
import net.unusual.blockfactorysbosses.procedures.SandwormEntityDiesProcedure;
import net.unusual.blockfactorysbosses.procedures.SandwormOnEntityTickUpdateProcedure;

public class SandwormEntity
extends Monster
implements RangedAttackMob {
    public final AnimationState dieAnimationState = new AnimationState();
    public final AnimationState attackAnimationState = new AnimationState();
    public final AnimationState spawnAnimationState = new AnimationState();
    public final AnimationState diveAnimationState = new AnimationState();
    public final AnimationState diveOutAnimationState = new AnimationState();
    public final AnimationState idleAnimationState = new AnimationState();
    public static final EntityDataAccessor<Integer> DATA_boss_phase = SynchedEntityData.defineId(SandwormEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_attack_phase = SynchedEntityData.defineId(SandwormEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_attack_animtime = SynchedEntityData.defineId(SandwormEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_attack_cooldown = SynchedEntityData.defineId(SandwormEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_spawn_animtime = SynchedEntityData.defineId(SandwormEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_dive_animtime = SynchedEntityData.defineId(SandwormEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_battle_time = SynchedEntityData.defineId(SandwormEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_die_animtime = SynchedEntityData.defineId(SandwormEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<String> DATA_source_uuid = SynchedEntityData.defineId(SandwormEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);

    public SandwormEntity(EntityType<SandwormEntity> type, Level world) {
        super(type, world);
        this.xpReward = 0;
        this.setNoAi(false);
        this.setPersistenceRequired();
        this.setInvisible(true);
        this.moveControl = new SlowRotMoveControl((Mob)this);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_boss_phase, (Object)0);
        builder.define(DATA_attack_phase, (Object)0);
        builder.define(DATA_attack_animtime, (Object)0);
        builder.define(DATA_attack_cooldown, (Object)0);
        builder.define(DATA_spawn_animtime, (Object)0);
        builder.define(DATA_dive_animtime, (Object)0);
        builder.define(DATA_battle_time, (Object)0);
        builder.define(DATA_die_animtime, (Object)0);
        builder.define(DATA_source_uuid, (Object)"");
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal(this, (PathfinderMob)this, 0.0, false){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < (double)(this.mob.getBbWidth() * this.mob.getBbWidth() + entity.getBbWidth()) && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }
        });
        this.targetSelector.addGoal(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, false));
        this.goalSelector.addGoal(1, (Goal)new RangedAttackGoal(this, this, 1.25, 20, 10.0f){

            public boolean canContinueToUse() {
                return this.canUse();
            }
        });
    }

    public void tick() {
        if (this.level().isClientSide) {
            this.dieAnimationState.animateWhen((Integer)this.getEntityData().get(DATA_die_animtime) > 0 && (Integer)this.getEntityData().get(DATA_spawn_animtime) == 0, this.tickCount);
            this.attackAnimationState.animateWhen((Integer)this.getEntityData().get(DATA_attack_animtime) > 0 && (Integer)this.getEntityData().get(DATA_spawn_animtime) == 0, this.tickCount);
            this.diveOutAnimationState.animateWhen((Integer)this.getEntityData().get(DATA_dive_animtime) > 0 && (Integer)this.getEntityData().get(DATA_dive_animtime) < 83 && (Integer)this.getEntityData().get(DATA_spawn_animtime) == 0, this.tickCount);
            this.diveAnimationState.animateWhen((Integer)this.getEntityData().get(DATA_dive_animtime) > 82 && (Integer)this.getEntityData().get(DATA_spawn_animtime) == 0, this.tickCount);
            this.idleAnimationState.animateWhen((Integer)this.getEntityData().get(DATA_die_animtime) == 0 && (Integer)this.getEntityData().get(DATA_attack_animtime) == 0 && (Integer)this.getEntityData().get(DATA_dive_animtime) == 0 && ((Integer)this.getEntityData().get(DATA_spawn_animtime) <= 10 || (Integer)this.getEntityData().get(DATA_spawn_animtime) > 226), this.tickCount);
            this.spawnAnimationState.animateWhen((Integer)this.getEntityData().get(DATA_spawn_animtime) > 10 && (Integer)this.getEntityData().get(DATA_spawn_animtime) < 170, this.tickCount);
        }
        super.tick();
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public SoundEvent getAmbientSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"block_factorys_bosses:sandworm_ambient"));
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"block_factorys_bosses:sandworm_hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"block_factorys_bosses:silence"));
    }

    public boolean hurt(DamageSource damagesource, float amount) {
        if (damagesource.is(DamageTypes.FALL)) {
            return false;
        }
        if (damagesource.is(DamageTypes.CACTUS)) {
            return false;
        }
        if (damagesource.typeHolder().is(NeoForgeMod.POISON_DAMAGE)) {
            return false;
        }
        return super.hurt(damagesource, amount);
    }

    public void die(DamageSource source) {
        super.die(source);
        SandwormEntityDiesProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this, source.getEntity());
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("Databoss_phase", ((Integer)this.entityData.get(DATA_boss_phase)).intValue());
        compound.putInt("Dataattack_phase", ((Integer)this.entityData.get(DATA_attack_phase)).intValue());
        compound.putInt("Dataattack_animtime", ((Integer)this.entityData.get(DATA_attack_animtime)).intValue());
        compound.putInt("Dataattack_cooldown", ((Integer)this.entityData.get(DATA_attack_cooldown)).intValue());
        compound.putInt("Dataspawn_animtime", ((Integer)this.entityData.get(DATA_spawn_animtime)).intValue());
        compound.putInt("Datadive_animtime", ((Integer)this.entityData.get(DATA_dive_animtime)).intValue());
        compound.putInt("Databattle_time", ((Integer)this.entityData.get(DATA_battle_time)).intValue());
        compound.putInt("Datadie_animtime", ((Integer)this.entityData.get(DATA_die_animtime)).intValue());
        compound.putString("Datasource_uuid", (String)this.entityData.get(DATA_source_uuid));
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("Databoss_phase")) {
            this.entityData.set(DATA_boss_phase, (Object)compound.getInt("Databoss_phase"));
        }
        if (compound.contains("Dataattack_phase")) {
            this.entityData.set(DATA_attack_phase, (Object)compound.getInt("Dataattack_phase"));
        }
        if (compound.contains("Dataattack_animtime")) {
            this.entityData.set(DATA_attack_animtime, (Object)compound.getInt("Dataattack_animtime"));
        }
        if (compound.contains("Dataattack_cooldown")) {
            this.entityData.set(DATA_attack_cooldown, (Object)compound.getInt("Dataattack_cooldown"));
        }
        if (compound.contains("Dataspawn_animtime")) {
            this.entityData.set(DATA_spawn_animtime, (Object)compound.getInt("Dataspawn_animtime"));
        }
        if (compound.contains("Datadive_animtime")) {
            this.entityData.set(DATA_dive_animtime, (Object)compound.getInt("Datadive_animtime"));
        }
        if (compound.contains("Databattle_time")) {
            this.entityData.set(DATA_battle_time, (Object)compound.getInt("Databattle_time"));
        }
        if (compound.contains("Datadie_animtime")) {
            this.entityData.set(DATA_die_animtime, (Object)compound.getInt("Datadie_animtime"));
        }
        if (compound.contains("Datasource_uuid")) {
            this.entityData.set(DATA_source_uuid, (Object)compound.getString("Datasource_uuid"));
        }
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData livingdata) {
        SpawnGroupData retval = super.finalizeSpawn(world, difficulty, reason, livingdata);
        this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(((Double)ConfigFileConfiguration.SANDWORM_HEALTH.get()).doubleValue());
        this.getAttribute(Attributes.ARMOR).setBaseValue(((Double)ConfigFileConfiguration.SANDWORM_ARMOR.get()).doubleValue());
        this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(((Double)ConfigFileConfiguration.SANDWORM_ATK.get()).doubleValue());
        SandwormEntity sandwormEntity = this;
        if (sandwormEntity instanceof LivingEntity) {
            SandwormEntity _entity = sandwormEntity;
            _entity.setHealth((float)((Double)ConfigFileConfiguration.SANDWORM_HEALTH.get()).doubleValue());
        }
        return retval;
    }

    public void baseTick() {
        super.baseTick();
        SandwormOnEntityTickUpdateProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
    }

    public void performRangedAttack(LivingEntity target, float flval) {
        NullPrEntity.shoot((LivingEntity)this, target);
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.3);
        builder = builder.add(Attributes.MAX_HEALTH, 150.0);
        builder = builder.add(Attributes.ARMOR, 20.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 10.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 64.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.6);
        return builder;
    }
}

