/*
 * Decompiled with CFR 0.152.
 */
package net.unusual.blockfactorysbosses.entity;

import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.phys.Vec3;

public class SmoothGroundPathNavigation
extends GroundPathNavigation {
    public SmoothGroundPathNavigation(Mob mob, Level level) {
        super(mob, level);
    }

    protected void followThePath() {
        Vec3 currentPos = this.getTempMobPos();
        int currentIndex = this.path.getNextNodeIndex();
        if (currentIndex < this.path.getNodeCount()) {
            Node nextNode = this.path.getNode(currentIndex);
            Vec3 nextNodePos = new Vec3((double)nextNode.x + 0.5, (double)nextNode.y, (double)nextNode.z + 0.5);
            double dx = nextNodePos.x - currentPos.x;
            double dz = nextNodePos.z - currentPos.z;
            double distance = dx * dx + dz * dz;
            if (distance < 0.25) {
                this.path.advance();
            }
            double targetAngle = Math.atan2(dz, dx) * 57.29577951308232 - 90.0;
            double currentAngle = this.mob.getYRot();
            double angleDiff = Mth.wrapDegrees((double)(targetAngle - currentAngle));
            double maxTurn = 5.0;
            double clampedTurn = Mth.clamp((double)angleDiff, (double)(-maxTurn), (double)maxTurn);
            this.mob.setYRot((float)(currentAngle + clampedTurn));
            this.mob.yBodyRot = this.mob.getYRot();
            this.mob.yHeadRot = this.mob.getYRot();
            super.followThePath();
        }
    }
}

