/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.client.gui.bns.window.view.element;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Objects;
import java.util.function.Consumer;
import me.ichun.mods.ichunutil.client.gui.bns.Fragment;
import me.ichun.mods.ichunutil.client.gui.bns.Theme;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementToggle;
import net.minecraft.client.gui.GuiGraphics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ElementToggleRotatable<T extends ElementToggleRotatable>
extends ElementToggle<T> {
    public int rotationCount;

    public ElementToggleRotatable(@NotNull Fragment parent, @NotNull String s, int rotCount, Consumer<T> callback) {
        super(parent, s, callback);
        this.rotationCount = rotCount;
    }

    @Override
    public ElementToggleRotatable<?> setSize(int width, int height) {
        if (this.rotationCount % 2 != 0) {
            return (ElementToggleRotatable)super.setSize(height, width);
        }
        return (ElementToggleRotatable)super.setSize(width, height);
    }

    @Override
    public void renderText(GuiGraphics graphics) {
        if (!this.text.isEmpty()) {
            String s = this.reString(this.text, (this.rotationCount % 2 != 0 ? this.height : this.width) - 4);
            PoseStack stack = graphics.pose();
            stack.pushPose();
            stack.translate((float)this.getLeft() + (float)this.width / 2.0f, (float)this.getTop() + (float)this.height / 2.0f, 0.0f);
            stack.mulPose(Axis.ZP.rotationDegrees(90.0f * (float)this.rotationCount));
            float f = (float)(-this.getFontRenderer().width(s)) / 2.0f;
            Objects.requireNonNull(this.getFontRenderer());
            stack.translate(f, (float)(-9) / 2.0f + 1.0f, 0.0f);
            if (this.renderMinecraftStyle() > 0) {
                graphics.drawString(this.getFontRenderer(), s, 0, 0, this.getMinecraftFontColour(), true);
            } else {
                graphics.drawString(this.getFontRenderer(), s, 0, 0, Theme.getAsHex(this.toggleState ? this.getTheme().font : this.getTheme().fontDim), false);
            }
            stack.popPose();
        }
    }

    @Override
    @Nullable
    public String tooltip(double mouseX, double mouseY) {
        String s;
        if (!this.text.isEmpty() && !(s = this.reString(this.text, (this.rotationCount % 2 != 0 ? this.height : this.width) - 4)).equals(this.text)) {
            if (this.tooltip != null) {
                return this.text + " - " + this.tooltip;
            }
            return this.text;
        }
        return this.tooltip;
    }
}

