/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.common.core;

import com.mojang.brigadier.CommandDispatcher;
import java.util.Locale;
import java.util.function.Consumer;
import me.ichun.mods.ichunutil.common.entity.EntityPersistentDataHandler;
import me.ichun.mods.ichunutil.loader.event.EventListener;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public abstract class EventHandlerServer {
    private EventListener<Player> playerTickEndListener;
    private EventListener<ServerPlayer> playerLoggedInListener;
    private EventListener<ServerPlayer> playerLoggedOutListener;
    private EventListener<MinecraftServer> serverAboutToStartListener;
    private EventListener<MinecraftServer> serverStoppingListener;
    private EventListener<CommandDispatcher<CommandSourceStack>> commandRegistrationListener;

    public abstract EntityPersistentDataHandler getEntityPersistedDataHandler();

    protected abstract void registerAsPlayerTickEndListener(EventListener<Player> var1);

    public final void registerPlayerTickEndListener(Consumer<Player> consumer) {
        if (this.playerTickEndListener == null) {
            this.playerTickEndListener = new EventListener(this::registerAsPlayerTickEndListener);
        }
        this.playerTickEndListener.register(consumer);
    }

    protected abstract void registerAsPlayerLoggedInListener(EventListener<ServerPlayer> var1);

    public final void registerPlayerLoggedInListener(Consumer<ServerPlayer> consumer) {
        if (this.playerLoggedInListener == null) {
            this.playerLoggedInListener = new EventListener(this::registerAsPlayerLoggedInListener);
        }
        this.playerLoggedInListener.register(consumer);
    }

    protected abstract void registerAsPlayerLoggedOutListener(EventListener<ServerPlayer> var1);

    public final void registerPlayerLoggedOutListener(Consumer<ServerPlayer> consumer) {
        if (this.playerLoggedOutListener == null) {
            this.playerLoggedOutListener = new EventListener(this::registerAsPlayerLoggedOutListener);
        }
        this.playerLoggedOutListener.register(consumer);
    }

    protected abstract void registerAsServerAboutToStartListener(EventListener<MinecraftServer> var1);

    public final void registerServerAboutToStartListener(Consumer<MinecraftServer> consumer) {
        if (this.serverAboutToStartListener == null) {
            this.serverAboutToStartListener = new EventListener(this::registerAsServerAboutToStartListener);
        }
        this.serverAboutToStartListener.register(consumer);
    }

    protected abstract void registerAsServerStoppingListener(EventListener<MinecraftServer> var1);

    public final void registerServerStoppingListener(Consumer<MinecraftServer> consumer) {
        if (this.serverStoppingListener == null) {
            this.serverStoppingListener = new EventListener(this::registerAsServerStoppingListener);
        }
        this.serverStoppingListener.register(consumer);
    }

    protected abstract void registerAsCommandRegistrationListener(EventListener<CommandDispatcher<CommandSourceStack>> var1);

    public final void registerCommandRegistrationListener(Consumer<CommandDispatcher<CommandSourceStack>> consumer) {
        if (this.commandRegistrationListener == null) {
            this.commandRegistrationListener = new EventListener(this::registerAsCommandRegistrationListener);
        }
        this.commandRegistrationListener.register(consumer);
    }

    public void firePlayerTickEndEvent(Player player) {
    }

    public boolean isFakePlayer(ServerPlayer player) {
        return player.connection == null || player.getClass().getSimpleName().toLowerCase(Locale.ROOT).contains("fakeplayer");
    }
}

