/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.loader.neoforge;

import me.ichun.mods.ichunutil.common.network.AbstractPacket;
import me.ichun.mods.ichunutil.common.network.PacketChannel;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.registration.HandlerThread;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

public class PacketChannelNeoForge
extends PacketChannel {
    public PacketChannelNeoForge(RegisterPayloadHandlersEvent event, ResourceLocation name, int protocolVersion, Class<? extends AbstractPacket> ... packetTypes) {
        this(event, name, protocolVersion, false, packetTypes);
    }

    public PacketChannelNeoForge(RegisterPayloadHandlersEvent event, ResourceLocation name, int protocolVersion, boolean isOptional, Class<? extends AbstractPacket> ... packetTypes) {
        super(name, packetTypes);
        PayloadRegistrar registrar = event.registrar(this.channelId.toString()).executesOn(HandlerThread.NETWORK).versioned(Integer.toString(protocolVersion));
        if (isOptional) {
            registrar = registrar.optional();
        }
        registrar.playBidirectional(new CustomPacketPayload.Type(this.channelId), this.createCodec(), this::handle);
    }

    protected void handle(PacketChannel.PacketPayload payload, IPayloadContext context) {
        Player player = context.flow() == PacketFlow.CLIENTBOUND ? this.getPlayer() : context.player();
        payload.process(player).ifPresent(arg_0 -> ((IPayloadContext)context).enqueueWork(arg_0));
    }

    @Override
    public void sendToServer(AbstractPacket packet) {
        PacketDistributor.sendToServer((CustomPacketPayload)this.payload(packet), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void sendTo(AbstractPacket packet, ServerPlayer player) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)this.payload(packet), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void sendToAll(AbstractPacket packet) {
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)this.payload(packet), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void sendToTracking(AbstractPacket packet, Entity entity) {
        PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)entity, (CustomPacketPayload)this.payload(packet), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void sendToAround(AbstractPacket packet, ServerLevel world, double x, double y, double z, double radius) {
        PacketDistributor.sendToPlayersNear((ServerLevel)world, null, (double)x, (double)y, (double)z, (double)radius, (CustomPacketPayload)this.payload(packet), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

