/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.neorhutilities.block;

import com.mojang.serialization.MapCodec;
import io.netty.buffer.Unpooled;
import net.mcreator.neorhutilities.world.inventory.NEOGUIMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.FastColor;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.util.TriState;

public class Trofeo2Block
extends FallingBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final MapCodec<Trofeo2Block> CODEC = Trofeo2Block.simpleCodec(properties -> new Trofeo2Block());

    public MapCodec<Trofeo2Block> codec() {
        return CODEC;
    }

    public Trofeo2Block() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.EMERALD).sound(SoundType.ANVIL).strength(10.0f, 30.0f).lightLevel(s -> 15).requiresCorrectToolForDrops().noOcclusion().hasPostProcess((bs, br, bp) -> true).emissiveRendering((bs, br, bp) -> true).isRedstoneConductor((bs, br, bp) -> false));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    public Integer getBeaconColorMultiplier(BlockState state, LevelReader world, BlockPos pos, BlockPos beaconPos) {
        return FastColor.ARGB32.opaque((int)-737766);
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            default -> Shapes.or((VoxelShape)Trofeo2Block.box((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0), (VoxelShape[])new VoxelShape[]{Trofeo2Block.box((double)3.0, (double)13.0, (double)3.0, (double)13.0, (double)24.0, (double)13.0), Trofeo2Block.box((double)6.0, (double)8.0, (double)6.0, (double)10.0, (double)13.0, (double)10.0), Trofeo2Block.box((double)5.0, (double)11.0, (double)5.0, (double)11.0, (double)13.0, (double)11.0), Trofeo2Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)4.0, (double)15.0), Trofeo2Block.box((double)4.0, (double)0.5, (double)14.5, (double)12.0, (double)3.5, (double)15.5)});
            case Direction.NORTH -> Shapes.or((VoxelShape)Trofeo2Block.box((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0), (VoxelShape[])new VoxelShape[]{Trofeo2Block.box((double)3.0, (double)13.0, (double)3.0, (double)13.0, (double)24.0, (double)13.0), Trofeo2Block.box((double)6.0, (double)8.0, (double)6.0, (double)10.0, (double)13.0, (double)10.0), Trofeo2Block.box((double)5.0, (double)11.0, (double)5.0, (double)11.0, (double)13.0, (double)11.0), Trofeo2Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)4.0, (double)15.0), Trofeo2Block.box((double)4.0, (double)0.5, (double)0.5, (double)12.0, (double)3.5, (double)1.5)});
            case Direction.EAST -> Shapes.or((VoxelShape)Trofeo2Block.box((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0), (VoxelShape[])new VoxelShape[]{Trofeo2Block.box((double)3.0, (double)13.0, (double)3.0, (double)13.0, (double)24.0, (double)13.0), Trofeo2Block.box((double)6.0, (double)8.0, (double)6.0, (double)10.0, (double)13.0, (double)10.0), Trofeo2Block.box((double)5.0, (double)11.0, (double)5.0, (double)11.0, (double)13.0, (double)11.0), Trofeo2Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)4.0, (double)15.0), Trofeo2Block.box((double)14.5, (double)0.5, (double)4.0, (double)15.5, (double)3.5, (double)12.0)});
            case Direction.WEST -> Shapes.or((VoxelShape)Trofeo2Block.box((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0), (VoxelShape[])new VoxelShape[]{Trofeo2Block.box((double)3.0, (double)13.0, (double)3.0, (double)13.0, (double)24.0, (double)13.0), Trofeo2Block.box((double)6.0, (double)8.0, (double)6.0, (double)10.0, (double)13.0, (double)10.0), Trofeo2Block.box((double)5.0, (double)11.0, (double)5.0, (double)11.0, (double)13.0, (double)11.0), Trofeo2Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)4.0, (double)15.0), Trofeo2Block.box((double)0.5, (double)0.5, (double)4.0, (double)1.5, (double)3.5, (double)12.0)});
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public boolean isSignalSource(BlockState state) {
        return true;
    }

    public int getSignal(BlockState blockstate, BlockGetter blockAccess, BlockPos pos, Direction direction) {
        return 15;
    }

    public TriState canSustainPlant(BlockState state, BlockGetter world, BlockPos pos, Direction direction, BlockState plant) {
        return TriState.TRUE;
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, Direction side) {
        return true;
    }

    public InteractionResult useWithoutItem(BlockState blockstate, Level world, final BlockPos pos, Player entity, BlockHitResult hit) {
        super.useWithoutItem(blockstate, world, pos, entity, hit);
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            player.openMenu(new MenuProvider(){

                public Component getDisplayName() {
                    return Component.literal((String)"Trofeo 2");
                }

                public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
                    return new NEOGUIMenu(id, inventory, new FriendlyByteBuf(Unpooled.buffer()).writeBlockPos(pos));
                }
            }, pos);
        }
        return InteractionResult.SUCCESS;
    }
}

