/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.candlelight.core.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.satisfy.candlelight.core.block.WallDecorationBlock;
import org.jetbrains.annotations.NotNull;

public class SmallPaintingBlock
extends WallDecorationBlock {
    public static final IntegerProperty PAINTING = IntegerProperty.create((String)"painting", (int)0, (int)6);

    public SmallPaintingBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)PAINTING, (Comparable)Integer.valueOf(0)));
    }

    @NotNull
    protected ItemInteractionResult useItemOn(ItemStack itemStack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        if (player.isDiscrete()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (world.isClientSide && this.switchPaintings((LevelAccessor)world, pos, state, player).consumesAction()) {
            return ItemInteractionResult.SUCCESS;
        }
        return this.switchPaintings((LevelAccessor)world, pos, state, player);
    }

    private ItemInteractionResult switchPaintings(LevelAccessor world, BlockPos pos, BlockState state, Player player) {
        world.playSound(null, pos, SoundEvents.BOOK_PAGE_TURN, SoundSource.PLAYERS, 0.5f, world.getRandom().nextFloat() * 0.1f + 0.9f);
        int i = (Integer)state.getValue((Property)PAINTING);
        world.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
        int nextStage = i + 1;
        if (nextStage <= 6) {
            world.setBlock(pos, (BlockState)state.setValue((Property)PAINTING, (Comparable)Integer.valueOf(nextStage)), 3);
        } else {
            world.setBlock(pos, (BlockState)state.setValue((Property)PAINTING, (Comparable)Integer.valueOf(0)), 3);
        }
        return ItemInteractionResult.SUCCESS;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{PAINTING});
    }
}

