/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.candlelight.core.item;

import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.DyedItemColor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DyeableCandlelightArmorItem
extends ArmorItem {
    private final ResourceLocation texture;
    private final ResourceLocation overlayTexture;
    private final int defaultColor;
    private final ResourceLocation normalizedTexture;
    private final ResourceLocation normalizedOverlayTexture;

    public DyeableCandlelightArmorItem(Holder<ArmorMaterial> armorMaterial, ArmorItem.Type type, int color, Item.Properties properties, ResourceLocation texture) {
        super(armorMaterial, type, properties);
        this.defaultColor = color;
        this.texture = texture;
        this.overlayTexture = null;
        this.normalizedTexture = DyeableCandlelightArmorItem.normalize(texture);
        this.normalizedOverlayTexture = null;
    }

    public DyeableCandlelightArmorItem(Holder<ArmorMaterial> armorMaterial, ArmorItem.Type type, int color, Item.Properties properties, ResourceLocation texture, ResourceLocation overlayTexture) {
        super(armorMaterial, type, properties);
        this.defaultColor = color;
        this.texture = texture;
        this.overlayTexture = overlayTexture;
        this.normalizedTexture = DyeableCandlelightArmorItem.normalize(texture);
        this.normalizedOverlayTexture = DyeableCandlelightArmorItem.normalize(overlayTexture);
    }

    public int getColor(ItemStack stack) {
        DyedItemColor dyed = (DyedItemColor)stack.get(DataComponents.DYED_COLOR);
        if (dyed != null) {
            return dyed.rgb();
        }
        CompoundTag tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getCompound("display");
        if (tag.contains("color", 99)) {
            return tag.getInt("color");
        }
        return this.defaultColor;
    }

    public ResourceLocation getTexture() {
        return this.normalizedTexture;
    }

    @Nullable
    public ResourceLocation getOverlayTexture() {
        return this.normalizedOverlayTexture;
    }

    @NotNull
    public EquipmentSlot getEquipmentSlot() {
        return this.type.getSlot();
    }

    private static ResourceLocation normalize(ResourceLocation loc) {
        Object path = loc.getPath();
        if (!((String)path).startsWith("textures/")) {
            path = "textures/" + (String)path;
        }
        if (!((String)path).endsWith(".png")) {
            path = (String)path + ".png";
        }
        return ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)path);
    }
}

