/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.candlelight.core.registry;

import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.satisfy.candlelight.core.block.entity.CStoveBlockEntity;
import net.satisfy.candlelight.core.block.entity.CabinetBlockEntity;
import net.satisfy.candlelight.core.block.entity.CompletionistBannerEntity;
import net.satisfy.candlelight.core.block.entity.CookingPanBlockEntity;
import net.satisfy.candlelight.core.block.entity.DinnerBellBlockEntity;
import net.satisfy.candlelight.core.block.entity.LargeCookingPotBlockEntity;
import net.satisfy.candlelight.core.block.entity.SideBoardBlockEntity;
import net.satisfy.candlelight.core.block.entity.StorageBlockEntity;
import net.satisfy.candlelight.core.block.entity.TableSetBlockEntity;
import net.satisfy.candlelight.core.block.entity.TypewriterEntity;
import net.satisfy.candlelight.core.registry.ObjectRegistry;
import net.satisfy.candlelight.core.registry.StorageTypeRegistry;
import net.satisfy.candlelight.core.util.CandlelightIdentifier;
import net.satisfy.farm_and_charm.core.block.entity.EffectFoodBlockEntity;

public class EntityTypeRegistry {
    private static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITY_TYPES = DeferredRegister.create((String)"candlelight", (ResourceKey)Registries.BLOCK_ENTITY_TYPE);
    private static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((String)"candlelight", (ResourceKey)Registries.ENTITY_TYPE);
    public static final RegistrySupplier<BlockEntityType<StorageBlockEntity>> STORAGE_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity("storage", () -> BlockEntityType.Builder.of(StorageBlockEntity::new, (Block[])StorageTypeRegistry.registerBlocks(new HashSet<Block>()).toArray(new Block[0])).build(null));
    public static final RegistrySupplier<BlockEntityType<SideBoardBlockEntity>> SIDEBOARD_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity("sideboard", () -> BlockEntityType.Builder.of(SideBoardBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.SIDEBOARD.get()}).build(null));
    public static final RegistrySupplier<BlockEntityType<LargeCookingPotBlockEntity>> LARGE_COOKING_POT_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity("large_cooking_pot", () -> BlockEntityType.Builder.of(LargeCookingPotBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.COOKING_POT.get()}).build(null));
    public static final RegistrySupplier<BlockEntityType<TypewriterEntity>> TYPE_WRITER_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity("type_writer", () -> BlockEntityType.Builder.of(TypewriterEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.TYPEWRITER_IRON.get(), (Block)ObjectRegistry.TYPEWRITER_GOLD.get()}).build(null));
    public static final RegistrySupplier<BlockEntityType<CookingPanBlockEntity>> COOKING_PAN_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity("cooking_pan", () -> BlockEntityType.Builder.of(CookingPanBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.COOKING_PAN.get()}).build(null));
    public static final RegistrySupplier<BlockEntityType<DinnerBellBlockEntity>> DINNER_BELL_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity("dinner_bell", () -> BlockEntityType.Builder.of(DinnerBellBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.DINNER_BELL.get()}).build(null));
    public static final RegistrySupplier<BlockEntityType<CStoveBlockEntity>> STOVE_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity("stove_block", () -> BlockEntityType.Builder.of(CStoveBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.COBBLESTONE_STOVE.get(), (Block)ObjectRegistry.MUD_STOVE.get(), (Block)ObjectRegistry.GRANITE_STOVE.get(), (Block)ObjectRegistry.SANDSTONE_STOVE.get(), (Block)ObjectRegistry.STONE_BRICKS_STOVE.get(), (Block)ObjectRegistry.RED_NETHER_BRICKS_STOVE.get(), (Block)ObjectRegistry.DEEPSLATE_STOVE.get(), (Block)ObjectRegistry.QUARTZ_STOVE.get(), (Block)ObjectRegistry.END_STOVE.get(), (Block)ObjectRegistry.BASALT_STOVE.get(), (Block)ObjectRegistry.BAMBOO_STOVE.get()}).build(null));
    public static final RegistrySupplier<BlockEntityType<CabinetBlockEntity>> CABINET_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity("cabinet", () -> BlockEntityType.Builder.of(CabinetBlockEntity::new, (Block[])EntityTypeRegistry.addCabinet(new HashSet<Block>()).toArray(new Block[0])).build(null));
    public static final RegistrySupplier<BlockEntityType<CompletionistBannerEntity>> CANDLELIGHT_BANNER_ENTITY = EntityTypeRegistry.registerBlockEntity("candlelight_banner_entity", () -> BlockEntityType.Builder.of(CompletionistBannerEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.CANDLELIGHT_BANNER.get(), (Block)ObjectRegistry.CANDLELIGHT_WALL_BANNER.get()}).build(null));
    public static final RegistrySupplier<BlockEntityType<TableSetBlockEntity>> TABLE_SET_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity("table_set", () -> BlockEntityType.Builder.of(TableSetBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.TABLE_SET.get()}).build(null));
    public static final RegistrySupplier<BlockEntityType<EffectFoodBlockEntity>> EFFECT_FOOD_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity("effect_food_block", () -> BlockEntityType.Builder.of(EffectFoodBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.LASAGNE_BLOCK.get(), (Block)ObjectRegistry.TOMATO_MOZZARELLA_BLOCK.get(), (Block)ObjectRegistry.PORK_RIBS_BLOCK.get(), (Block)ObjectRegistry.FRESH_GARDEN_SALAD_BLOCK.get(), (Block)ObjectRegistry.BEEF_WELLINGTON_BLOCK.get()}).build(null));

    private static <T extends BlockEntityType<?>> RegistrySupplier<T> registerBlockEntity(String path, Supplier<T> type) {
        return BLOCK_ENTITY_TYPES.register(CandlelightIdentifier.identifier(path), type);
    }

    public static void init() {
        ENTITY_TYPES.register();
        BLOCK_ENTITY_TYPES.register();
    }

    private static Set<Block> addCabinet(Set<Block> blocks) {
        blocks.add((Block)ObjectRegistry.DRAWER.get());
        blocks.add((Block)ObjectRegistry.OAK_DRAWER.get());
        blocks.add((Block)ObjectRegistry.BIRCH_DRAWER.get());
        blocks.add((Block)ObjectRegistry.SPRUCE_DRAWER.get());
        blocks.add((Block)ObjectRegistry.DARK_OAK_DRAWER.get());
        blocks.add((Block)ObjectRegistry.ACACIA_DRAWER.get());
        blocks.add((Block)ObjectRegistry.JUNGLE_DRAWER.get());
        blocks.add((Block)ObjectRegistry.MANGROVE_DRAWER.get());
        blocks.add((Block)ObjectRegistry.WARPED_DRAWER.get());
        blocks.add((Block)ObjectRegistry.CRIMSON_DRAWER.get());
        blocks.add((Block)ObjectRegistry.CHERRY_DRAWER.get());
        blocks.add((Block)ObjectRegistry.BAMBOO_DRAWER.get());
        blocks.add((Block)ObjectRegistry.CABINET.get());
        blocks.add((Block)ObjectRegistry.OAK_CABINET.get());
        blocks.add((Block)ObjectRegistry.BIRCH_CABINET.get());
        blocks.add((Block)ObjectRegistry.SPRUCE_CABINET.get());
        blocks.add((Block)ObjectRegistry.DARK_OAK_CABINET.get());
        blocks.add((Block)ObjectRegistry.ACACIA_CABINET.get());
        blocks.add((Block)ObjectRegistry.JUNGLE_CABINET.get());
        blocks.add((Block)ObjectRegistry.MANGROVE_CABINET.get());
        blocks.add((Block)ObjectRegistry.WARPED_CABINET.get());
        blocks.add((Block)ObjectRegistry.CRIMSON_CABINET.get());
        blocks.add((Block)ObjectRegistry.CHERRY_CABINET.get());
        blocks.add((Block)ObjectRegistry.BAMBOO_CABINET.get());
        return blocks;
    }
}

