/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.bakery.core.block;

import java.util.LinkedList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.bakery.core.block.StorageBlock;
import net.satisfy.bakery.core.block.entity.StorageBlockEntity;
import net.satisfy.bakery.core.registry.StorageTypeRegistry;
import org.jetbrains.annotations.NotNull;

public class CakeStandBlock
extends StorageBlock {
    public static VoxelShape SHAPE = CakeStandBlock.makeShape();

    public static VoxelShape makeShape() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.125, (double)0.5000625, (double)0.125, (double)0.125, (double)1.0000625, (double)0.875), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.125, (double)0.5000625, (double)0.125, (double)0.875, (double)1.0000625, (double)0.125), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.125, (double)0.5000625, (double)0.875, (double)0.875, (double)1.0000625, (double)0.875), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.125, (double)1.0000625, (double)0.125, (double)0.875, (double)1.0000625, (double)0.875), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.875, (double)0.5000625, (double)0.125, (double)0.875, (double)1.0000625, (double)0.875), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.4375, (double)1.0, (double)0.4375, (double)0.5625, (double)1.0625, (double)0.5625), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.4375, (double)0.125, (double)0.4375, (double)0.5625, (double)0.4375, (double)0.5625), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.25, (double)0.375, (double)0.25, (double)0.75, (double)0.4375, (double)0.75), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.125, (double)0.4375, (double)0.125, (double)0.875, (double)0.5, (double)0.875), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.375, (double)0.0625, (double)0.375, (double)0.625, (double)0.1875, (double)0.625), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.3125, (double)0.0, (double)0.3125, (double)0.6875, (double)0.0625, (double)0.6875), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public CakeStandBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    public int findFirstEmpty(NonNullList<ItemStack> inv) {
        for (int i = 0; i < this.size(); ++i) {
            ItemStack stack = (ItemStack)inv.get(i);
            if (!stack.isEmpty()) continue;
            return i;
        }
        return Integer.MIN_VALUE;
    }

    public int findFirstFull(NonNullList<ItemStack> inv) {
        for (int i = 0; i < this.size(); ++i) {
            ItemStack stack = (ItemStack)inv.get(i);
            if (stack.isEmpty()) continue;
            return i;
        }
        return Integer.MIN_VALUE;
    }

    @Override
    protected ItemInteractionResult useItemOn(ItemStack itemStack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof StorageBlockEntity) {
            StorageBlockEntity shelfBlockEntity = (StorageBlockEntity)blockEntity;
            LinkedList items = new LinkedList();
            shelfBlockEntity.getInventory().forEach(stack -> {
                if (!stack.isEmpty()) {
                    items.add(stack.getItem());
                }
            });
            if (player.isShiftKeyDown()) {
                boolean cCake = false;
                for (Item item : items) {
                    if (!(item instanceof BlockItem)) continue;
                    cCake = true;
                    break;
                }
                if (cCake) {
                    this.remove(world, pos, player, shelfBlockEntity, 0);
                    return ItemInteractionResult.sidedSuccess((boolean)world.isClientSide());
                }
                int i = this.findFirstFull(shelfBlockEntity.getInventory());
                if (i != Integer.MIN_VALUE) {
                    this.remove(world, pos, player, shelfBlockEntity, i);
                    return ItemInteractionResult.sidedSuccess((boolean)world.isClientSide());
                }
            } else {
                ItemStack stack2 = player.getItemInHand(hand);
                if (!stack2.isEmpty() && this.canInsertStack(stack2)) {
                    int i;
                    if (stack2.getItem() instanceof BlockItem) {
                        if (items.isEmpty()) {
                            this.add(world, pos, player, shelfBlockEntity, stack2, 0);
                            return ItemInteractionResult.sidedSuccess((boolean)world.isClientSide());
                        }
                    } else if (!(((ItemStack)shelfBlockEntity.getInventory().get(0)).getItem() instanceof BlockItem) && (i = this.findFirstEmpty(shelfBlockEntity.getInventory())) != Integer.MIN_VALUE) {
                        this.add(world, pos, player, shelfBlockEntity, stack2, i);
                        return ItemInteractionResult.sidedSuccess((boolean)world.isClientSide());
                    }
                }
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @Override
    public int size() {
        return 3;
    }

    @Override
    public ResourceLocation type() {
        return StorageTypeRegistry.CAKE_STAND;
    }

    @Override
    public Direction[] unAllowedDirections() {
        return new Direction[0];
    }

    @Override
    public boolean canInsertStack(ItemStack stack) {
        return true;
    }

    @Override
    public int getSection(Float x, Float y) {
        return 0;
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag tooltipFlag) {
        tooltip.add((Component)Component.translatable((String)"tooltip.bakery.canbeplaced").withStyle(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
    }
}

