/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.bakery.core.block.cake;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.bakery.core.registry.ObjectRegistry;
import net.satisfy.bakery.core.registry.SoundEventRegistry;
import net.satisfy.bakery.core.registry.TagsRegistry;
import org.jetbrains.annotations.NotNull;

public class BlankCakeBlock
extends Block {
    public static final BooleanProperty CAKE = BooleanProperty.create((String)"cake");
    public static final BooleanProperty CUPCAKE = BooleanProperty.create((String)"cupcake");
    public static final BooleanProperty COOKIE = BooleanProperty.create((String)"cookie");
    private static final VoxelShape CAKE_SHAPE = Shapes.box((double)0.0625, (double)0.0, (double)0.0625, (double)0.9375, (double)0.5, (double)0.9375);
    private static final VoxelShape BASE_SHAPE = Shapes.empty();
    private static final VoxelShape CUPCAKE_SHAPE = Shapes.or((VoxelShape)BASE_SHAPE, (VoxelShape[])new VoxelShape[]{Shapes.box((double)0.125, (double)0.0, (double)0.125, (double)0.4375, (double)0.375, (double)0.4375), Shapes.box((double)0.125, (double)0.0, (double)0.5625, (double)0.4375, (double)0.375, (double)0.875), Shapes.box((double)0.5625, (double)0.0, (double)0.125, (double)0.875, (double)0.375, (double)0.4375), Shapes.box((double)0.5625, (double)0.0, (double)0.5625, (double)0.875, (double)0.375, (double)0.875)});
    private static final VoxelShape COOKIE_SHAPE = Shapes.or((VoxelShape)BASE_SHAPE, (VoxelShape[])new VoxelShape[]{Shapes.box((double)0.125, (double)0.0, (double)0.125, (double)0.4375, (double)0.0625, (double)0.4375), Shapes.box((double)0.125, (double)0.0, (double)0.5625, (double)0.4375, (double)0.0625, (double)0.875), Shapes.box((double)0.5625, (double)0.0, (double)0.125, (double)0.875, (double)0.0625, (double)0.4375), Shapes.box((double)0.5625, (double)0.0, (double)0.5625, (double)0.875, (double)0.0625, (double)0.875)});

    public BlankCakeBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)CAKE, (Comparable)Boolean.valueOf(true))).setValue((Property)CUPCAKE, (Comparable)Boolean.valueOf(false))).setValue((Property)COOKIE, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if (((Boolean)state.getValue((Property)CAKE)).booleanValue()) {
            return CAKE_SHAPE;
        }
        if (((Boolean)state.getValue((Property)CUPCAKE)).booleanValue()) {
            return CUPCAKE_SHAPE;
        }
        if (((Boolean)state.getValue((Property)COOKIE)).booleanValue()) {
            return COOKIE_SHAPE;
        }
        return Shapes.empty();
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        super.neighborChanged(state, world, pos, block, fromPos, isMoving);
        if (!world.isClientSide && !this.canSurvive(state, (LevelReader)world, pos)) {
            world.destroyBlock(pos, true);
        }
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        return !world.isEmptyBlock(pos.below());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{CAKE, CUPCAKE, COOKIE});
    }

    protected ItemInteractionResult useItemOn(ItemStack itemStack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!world.isClientSide) {
            Item item = itemStack.getItem();
            boolean isCake = (Boolean)state.getValue((Property)CAKE);
            boolean isCupcake = (Boolean)state.getValue((Property)CUPCAKE);
            boolean isCookie = (Boolean)state.getValue((Property)COOKIE);
            if (item instanceof BlockItem) {
                Block block = ((BlockItem)item).getBlock();
                boolean matched = false;
                if (isCake) {
                    if (block == ObjectRegistry.STRAWBERRY_JAM.get()) {
                        world.setBlock(pos, ((Block)ObjectRegistry.STRAWBERRY_CAKE.get()).defaultBlockState(), 3);
                        world.levelEvent(2001, pos, Block.getId((BlockState)((Block)ObjectRegistry.STRAWBERRY_CAKE.get()).defaultBlockState()));
                        matched = true;
                        if (!player.getInventory().add(((Block)ObjectRegistry.JAR.get()).asItem().getDefaultInstance())) {
                            world.addFreshEntity((Entity)new ItemEntity(world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), ((Block)ObjectRegistry.JAR.get()).asItem().getDefaultInstance()));
                        }
                    } else if (block == ObjectRegistry.CHOCOLATE_JAM.get()) {
                        world.setBlock(pos, ((Block)ObjectRegistry.CHOCOLATE_CAKE.get()).defaultBlockState(), 3);
                        world.levelEvent(2001, pos, Block.getId((BlockState)((Block)ObjectRegistry.CHOCOLATE_CAKE.get()).defaultBlockState()));
                        matched = true;
                        if (!player.getInventory().add(((Block)ObjectRegistry.JAR.get()).asItem().getDefaultInstance())) {
                            world.addFreshEntity((Entity)new ItemEntity(world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), ((Block)ObjectRegistry.JAR.get()).asItem().getDefaultInstance()));
                        }
                    } else if (block == ObjectRegistry.SWEETBERRY_JAM.get()) {
                        world.setBlock(pos, ((Block)ObjectRegistry.SWEETBERRY_CAKE.get()).defaultBlockState(), 3);
                        world.levelEvent(2001, pos, Block.getId((BlockState)((Block)ObjectRegistry.SWEETBERRY_CAKE.get()).defaultBlockState()));
                        matched = true;
                        if (!player.getInventory().add(((Block)ObjectRegistry.JAR.get()).asItem().getDefaultInstance())) {
                            world.addFreshEntity((Entity)new ItemEntity(world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), ((Block)ObjectRegistry.JAR.get()).asItem().getDefaultInstance()));
                        }
                    }
                } else if (isCupcake) {
                    if (block == ObjectRegistry.STRAWBERRY_JAM.get()) {
                        world.setBlock(pos, ((Block)ObjectRegistry.STRAWBERRY_CUPCAKE_BLOCK.get()).defaultBlockState(), 3);
                        world.levelEvent(2001, pos, Block.getId((BlockState)((Block)ObjectRegistry.STRAWBERRY_CUPCAKE_BLOCK.get()).defaultBlockState()));
                        matched = true;
                        if (!player.getInventory().add(((Block)ObjectRegistry.JAR.get()).asItem().getDefaultInstance())) {
                            world.addFreshEntity((Entity)new ItemEntity(world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), ((Block)ObjectRegistry.JAR.get()).asItem().getDefaultInstance()));
                        }
                    } else if (block == ObjectRegistry.APPLE_JAM.get()) {
                        world.setBlock(pos, ((Block)ObjectRegistry.APPLE_CUPCAKE_BLOCK.get()).defaultBlockState(), 3);
                        world.levelEvent(2001, pos, Block.getId((BlockState)((Block)ObjectRegistry.APPLE_CUPCAKE_BLOCK.get()).defaultBlockState()));
                        matched = true;
                        if (!player.getInventory().add(((Block)ObjectRegistry.JAR.get()).asItem().getDefaultInstance())) {
                            world.addFreshEntity((Entity)new ItemEntity(world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), ((Block)ObjectRegistry.JAR.get()).asItem().getDefaultInstance()));
                        }
                    } else if (block == ObjectRegistry.SWEETBERRY_JAM.get()) {
                        world.setBlock(pos, ((Block)ObjectRegistry.SWEETBERRY_CUPCAKE_BLOCK.get()).defaultBlockState(), 3);
                        world.levelEvent(2001, pos, Block.getId((BlockState)((Block)ObjectRegistry.SWEETBERRY_CUPCAKE_BLOCK.get()).defaultBlockState()));
                        matched = true;
                        if (!player.getInventory().add(((Block)ObjectRegistry.JAR.get()).asItem().getDefaultInstance())) {
                            world.addFreshEntity((Entity)new ItemEntity(world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), ((Block)ObjectRegistry.JAR.get()).asItem().getDefaultInstance()));
                        }
                    }
                } else if (isCookie) {
                    if (block == ObjectRegistry.STRAWBERRY_JAM.get()) {
                        world.setBlock(pos, ((Block)ObjectRegistry.STRAWBERRY_COOKIE_BLOCK.get()).defaultBlockState(), 3);
                        world.levelEvent(2001, pos, Block.getId((BlockState)((Block)ObjectRegistry.STRAWBERRY_COOKIE_BLOCK.get()).defaultBlockState()));
                        matched = true;
                        if (!player.getInventory().add(((Block)ObjectRegistry.JAR.get()).asItem().getDefaultInstance())) {
                            world.addFreshEntity((Entity)new ItemEntity(world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), ((Block)ObjectRegistry.JAR.get()).asItem().getDefaultInstance()));
                        }
                    } else if (block == ObjectRegistry.CHOCOLATE_JAM.get()) {
                        world.setBlock(pos, ((Block)ObjectRegistry.CHOCOLATE_COOKIE_BLOCK.get()).defaultBlockState(), 3);
                        world.levelEvent(2001, pos, Block.getId((BlockState)((Block)ObjectRegistry.CHOCOLATE_COOKIE_BLOCK.get()).defaultBlockState()));
                        matched = true;
                        if (!player.getInventory().add(((Block)ObjectRegistry.JAR.get()).asItem().getDefaultInstance())) {
                            world.addFreshEntity((Entity)new ItemEntity(world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), ((Block)ObjectRegistry.JAR.get()).asItem().getDefaultInstance()));
                        }
                    } else if (block == ObjectRegistry.SWEETBERRY_JAM.get()) {
                        world.setBlock(pos, ((Block)ObjectRegistry.SWEETBERRY_COOKIE_BLOCK.get()).defaultBlockState(), 3);
                        world.levelEvent(2001, pos, Block.getId((BlockState)((Block)ObjectRegistry.SWEETBERRY_COOKIE_BLOCK.get()).defaultBlockState()));
                        matched = true;
                        if (!player.getInventory().add(((Block)ObjectRegistry.JAR.get()).asItem().getDefaultInstance())) {
                            world.addFreshEntity((Entity)new ItemEntity(world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), ((Block)ObjectRegistry.JAR.get()).asItem().getDefaultInstance()));
                        }
                    }
                }
                if (matched) {
                    world.playSound(null, pos, SoundEvents.SLIME_BLOCK_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
                    if (!player.isCreative()) {
                        itemStack.shrink(1);
                    }
                    return ItemInteractionResult.sidedSuccess((boolean)false);
                }
            } else {
                if (isCake && item == ObjectRegistry.CHOCOLATE_TRUFFLE.get()) {
                    player.getCooldowns().addCooldown(item, 20);
                    world.setBlock(pos, ((Block)ObjectRegistry.CHOCOLATE_GATEAU.get()).defaultBlockState(), 3);
                    world.levelEvent(2001, pos, Block.getId((BlockState)((Block)ObjectRegistry.CHOCOLATE_GATEAU.get()).defaultBlockState()));
                    world.playSound(null, pos, SoundEvents.SLIME_BLOCK_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
                    if (!player.isCreative()) {
                        itemStack.shrink(1);
                    }
                    return ItemInteractionResult.sidedSuccess((boolean)false);
                }
                if (isCake && itemStack.is(TagsRegistry.KNIVES)) {
                    world.setBlock(pos, (BlockState)((BlockState)state.setValue((Property)CAKE, (Comparable)Boolean.valueOf(false))).setValue((Property)CUPCAKE, (Comparable)Boolean.valueOf(true)), 3);
                    world.levelEvent(2001, pos, Block.getId((BlockState)state));
                    world.playSound(null, pos, (SoundEvent)SoundEventRegistry.CAKE_CUT.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                    return ItemInteractionResult.sidedSuccess((boolean)false);
                }
                if (isCupcake && item == ObjectRegistry.ROLLING_PIN.get()) {
                    world.setBlock(pos, (BlockState)((BlockState)state.setValue((Property)CUPCAKE, (Comparable)Boolean.valueOf(false))).setValue((Property)COOKIE, (Comparable)Boolean.valueOf(true)), 3);
                    world.levelEvent(2001, pos, Block.getId((BlockState)state));
                    world.playSound(null, pos, SoundEvents.GENERIC_BIG_FALL, SoundSource.BLOCKS, 1.0f, 1.0f);
                    return ItemInteractionResult.sidedSuccess((boolean)false);
                }
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }
}

