/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.bakery.core.block.cake;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.bakery.core.registry.SoundEventRegistry;
import net.satisfy.bakery.core.registry.TagsRegistry;
import net.satisfy.farm_and_charm.core.block.FacingBlock;
import net.satisfy.farm_and_charm.core.util.GeneralUtil;
import org.jetbrains.annotations.NotNull;

public class PieBlock
extends FacingBlock {
    public static final IntegerProperty CUTS = IntegerProperty.create((String)"cuts", (int)0, (int)3);
    private static final Supplier<VoxelShape> voxelShapeSupplier = () -> {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.joinUnoptimized((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)0.25, (double)1.0, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.OR);
        return shape;
    };
    public static final Map<Direction, VoxelShape> SHAPE = (Map)Util.make(new HashMap(), map -> {
        for (Direction direction : Direction.Plane.HORIZONTAL.stream().toList()) {
            map.put(direction, GeneralUtil.rotateShape((Direction)Direction.NORTH, (Direction)direction, (VoxelShape)voxelShapeSupplier.get()));
        }
    });
    public final Supplier<Item> Slice;

    public PieBlock(BlockBehaviour.Properties settings, Supplier<Item> slice) {
        super(settings);
        this.Slice = slice != null ? slice : () -> Items.AIR;
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)CUTS, (Comparable)Integer.valueOf(0)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{CUTS});
    }

    public int getAnalogOutputSignal(BlockState blockState, Level level, BlockPos pos) {
        return this.getMaxCuts() - (Integer)blockState.getValue((Property)CUTS);
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public ItemStack getPieSliceItem() {
        return new ItemStack((ItemLike)(this.Slice != null ? (ItemLike)this.Slice.get() : Items.AIR));
    }

    protected ItemInteractionResult useItemOn(ItemStack itemStack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult blockHitResult) {
        ItemStack heldStack = player.getItemInHand(hand);
        if (!level.isClientSide && !player.isShiftKeyDown() && (Integer)state.getValue((Property)CUTS) == 0 && heldStack.isEmpty()) {
            Direction direction = player.getDirection().getOpposite();
            double xMotion = (double)direction.getStepX() * 0.13;
            double yMotion = 0.35;
            double zMotion = (double)direction.getStepZ() * 0.13;
            GeneralUtil.spawnSlice((Level)level, (ItemStack)new ItemStack((ItemLike)this), (double)((double)pos.getX() + 0.5), (double)((double)pos.getY() + 0.5), (double)((double)pos.getZ() + 0.5), (double)xMotion, (double)yMotion, (double)zMotion);
            level.removeBlock(pos, false);
            return ItemInteractionResult.SUCCESS;
        }
        if (player.isShiftKeyDown() && (heldStack.isEmpty() || heldStack.is(TagsRegistry.KNIVES))) {
            return this.consumeBite(level, pos, state, player);
        }
        if (!player.isShiftKeyDown() && heldStack.is(TagsRegistry.KNIVES)) {
            return this.cutSlice(level, pos, state, player);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    protected ItemInteractionResult consumeBite(Level level, BlockPos pos, BlockState state, Player playerIn) {
        int cuts;
        if (!playerIn.canEat(false)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        ItemStack sliceStack = this.getPieSliceItem();
        FoodProperties sliceFood = (FoodProperties)sliceStack.get(DataComponents.FOOD);
        if (sliceFood != null) {
            playerIn.getFoodData().eat(sliceFood);
            if (this.getPieSliceItem().has(DataComponents.FOOD) && sliceFood != null) {
                sliceFood.effects().forEach(possibleEffect -> playerIn.addEffect(new MobEffectInstance(possibleEffect.effect())));
            }
        }
        if ((cuts = ((Integer)state.getValue((Property)CUTS)).intValue()) < this.getMaxCuts() - 1) {
            level.setBlock(pos, (BlockState)state.setValue((Property)CUTS, (Comparable)Integer.valueOf(cuts + 1)), 3);
        } else {
            level.destroyBlock(pos, false);
        }
        level.playSound(null, pos, SoundEvents.GENERIC_EAT, SoundSource.PLAYERS, 0.8f, 0.8f);
        return ItemInteractionResult.SUCCESS;
    }

    protected ItemInteractionResult cutSlice(Level level, BlockPos pos, BlockState state, Player player) {
        int cuts = (Integer)state.getValue((Property)CUTS);
        if (cuts < this.getMaxCuts() - 1) {
            level.setBlock(pos, (BlockState)state.setValue((Property)CUTS, (Comparable)Integer.valueOf(cuts + 1)), 3);
        } else {
            level.removeBlock(pos, false);
        }
        Direction direction = player.getDirection().getOpposite();
        double xMotion = (double)direction.getStepX() * 0.13;
        double yMotion = 0.35;
        double zMotion = (double)direction.getStepZ() * 0.13;
        GeneralUtil.spawnSlice((Level)level, (ItemStack)this.getPieSliceItem(), (double)((double)pos.getX() + 0.5), (double)((double)pos.getY() + 0.3), (double)((double)pos.getZ() + 0.5), (double)xMotion, (double)yMotion, (double)zMotion);
        level.playSound(null, pos, (SoundEvent)SoundEventRegistry.CAKE_CUT.get(), SoundSource.PLAYERS, 0.75f, 0.75f);
        return ItemInteractionResult.SUCCESS;
    }

    public boolean canSurvive(BlockState blockState, LevelReader levelReader, BlockPos blockPos) {
        return GeneralUtil.isFullAndSolid((LevelReader)levelReader, (BlockPos)blockPos);
    }

    public int getMaxCuts() {
        return 4;
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE.get(state.getValue((Property)FACING));
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag tooltipFlag) {
        tooltip.add((Component)Component.translatable((String)"tooltip.bakery.canbeplaced").withStyle(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
        tooltip.add((Component)Component.empty());
        tooltip.add((Component)Component.translatable((String)"tooltip.bakery.cake_1").withStyle(ChatFormatting.WHITE));
        tooltip.add((Component)Component.translatable((String)"tooltip.bakery.cake_2").withStyle(ChatFormatting.WHITE));
        tooltip.add((Component)Component.translatable((String)"tooltip.bakery.cake_3").withStyle(ChatFormatting.WHITE));
    }
}

