/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.bakery.core.registry;

import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.food.Foods;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.satisfy.bakery.core.block.BakerStationBlock;
import net.satisfy.bakery.core.block.BreadBasketBlock;
import net.satisfy.bakery.core.block.BreadBox;
import net.satisfy.bakery.core.block.CabinetBlock;
import net.satisfy.bakery.core.block.CabinetWallBlock;
import net.satisfy.bakery.core.block.CakeDisplayBlock;
import net.satisfy.bakery.core.block.CakeStandBlock;
import net.satisfy.bakery.core.block.CompletionistBannerBlock;
import net.satisfy.bakery.core.block.CompletionistWallBannerBlock;
import net.satisfy.bakery.core.block.CookieBlock;
import net.satisfy.bakery.core.block.CupcakeBlock;
import net.satisfy.bakery.core.block.CupcakeDisplayBlock;
import net.satisfy.bakery.core.block.SmallCookingPotBlock;
import net.satisfy.bakery.core.block.StreetSignBlock;
import net.satisfy.bakery.core.block.TableBlock;
import net.satisfy.bakery.core.block.TrayBlock;
import net.satisfy.bakery.core.block.WallDisplayBlock;
import net.satisfy.bakery.core.block.cake.ApplePieBlock;
import net.satisfy.bakery.core.block.cake.BlankCakeBlock;
import net.satisfy.bakery.core.block.cake.BundtCakeBlock;
import net.satisfy.bakery.core.block.cake.CakeBlock;
import net.satisfy.bakery.core.block.cake.ChocolateTart;
import net.satisfy.bakery.core.block.cake.GlowberryTartBlock;
import net.satisfy.bakery.core.block.cake.LinzerTartBlock;
import net.satisfy.bakery.core.block.cake.PuddingBlock;
import net.satisfy.bakery.core.item.SmallCookingPotItem;
import net.satisfy.bakery.core.registry.SoundEventRegistry;
import net.satisfy.bakery.core.util.BakeryIdentifier;
import net.satisfy.bakery.platform.PlatformHelper;
import net.satisfy.farm_and_charm.core.block.BenchBlock;
import net.satisfy.farm_and_charm.core.block.ChairBlock;
import net.satisfy.farm_and_charm.core.block.EatableBoxBlock;
import net.satisfy.farm_and_charm.core.block.LineConnectingBlock;
import net.satisfy.farm_and_charm.core.block.SinkBlock;
import net.satisfy.farm_and_charm.core.block.StackableBlock;
import net.satisfy.farm_and_charm.core.block.StackableEatableBlock;
import net.satisfy.farm_and_charm.core.item.food.EffectBlockItem;
import net.satisfy.farm_and_charm.core.item.food.EffectItem;
import net.satisfy.farm_and_charm.core.registry.MobEffectRegistry;
import net.satisfy.farm_and_charm.core.util.GeneralUtil;

public class ObjectRegistry {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((String)"bakery", (ResourceKey)Registries.ITEM);
    public static final Registrar<Item> ITEM_REGISTRAR = ITEMS.getRegistrar();
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((String)"bakery", (ResourceKey)Registries.BLOCK);
    public static final Registrar<Block> BLOCK_REGISTRAR = BLOCKS.getRegistrar();
    public static final RegistrySupplier<Block> BAKERY_BANNER = ObjectRegistry.registerWithItem("bakery_banner", () -> new CompletionistBannerBlock(BlockBehaviour.Properties.of().strength(1.0f).instrument(NoteBlockInstrument.BASS).noCollission().sound(SoundType.WOOD)));
    public static final RegistrySupplier<Block> BAKERY_WALL_BANNER = ObjectRegistry.registerWithoutItem("bakery_wall_banner", () -> new CompletionistWallBannerBlock(BlockBehaviour.Properties.of().strength(1.0f).instrument(NoteBlockInstrument.BASS).noCollission().sound(SoundType.WOOD)));
    public static final RegistrySupplier<Block> KITCHEN_SINK = ObjectRegistry.registerWithItem("kitchen_sink", () -> new SinkBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BRICKS).noOcclusion()));
    public static final RegistrySupplier<Block> BAKER_STATION = ObjectRegistry.registerWithItem("baker_station", () -> new BakerStationBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BRICKS)));
    public static final RegistrySupplier<Block> BRICK_COUNTER = ObjectRegistry.registerWithItem("brick_counter", () -> new LineConnectingBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BRICKS)));
    public static final RegistrySupplier<Block> CABINET = ObjectRegistry.registerWithItem("cabinet", () -> new CabinetBlock(BlockBehaviour.Properties.of().strength(2.0f, 3.0f).sound(SoundType.WOOD), (SoundEvent)SoundEventRegistry.CABINET_OPEN.get(), (SoundEvent)SoundEventRegistry.CABINET_CLOSE.get()));
    public static final RegistrySupplier<Block> DRAWER = ObjectRegistry.registerWithItem("drawer", () -> new CabinetBlock(BlockBehaviour.Properties.of().strength(2.0f, 3.0f).sound(SoundType.WOOD), (SoundEvent)SoundEventRegistry.DRAWER_OPEN.get(), (SoundEvent)SoundEventRegistry.DRAWER_CLOSE.get()));
    public static final RegistrySupplier<Block> WALL_CABINET = ObjectRegistry.registerWithItem("wall_cabinet", () -> new CabinetWallBlock(BlockBehaviour.Properties.of().strength(2.0f, 3.0f).sound(SoundType.WOOD), (SoundEvent)SoundEventRegistry.CABINET_OPEN.get(), (SoundEvent)SoundEventRegistry.CABINET_CLOSE.get()));
    public static final RegistrySupplier<Block> IRON_BENCH = ObjectRegistry.registerWithItem("iron_bench", () -> new BenchBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK)));
    public static final RegistrySupplier<Block> IRON_CHAIR = ObjectRegistry.registerWithItem("iron_chair", () -> new ChairBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK)));
    public static final RegistrySupplier<Block> IRON_TABLE = ObjectRegistry.registerWithItem("iron_table", () -> new TableBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK)));
    public static final RegistrySupplier<Block> STREET_SIGN = ObjectRegistry.registerWithItem("street_sign", () -> new StreetSignBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS)));
    public static final RegistrySupplier<Block> CAKE_STAND = ObjectRegistry.registerWithItem("cake_stand", () -> new CakeStandBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.FLOWER_POT).sound(SoundType.GLASS)));
    public static final RegistrySupplier<Block> CAKE_DISPLAY = ObjectRegistry.registerWithItem("cake_display", () -> new CakeDisplayBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.FLOWER_POT).sound(SoundType.GLASS)));
    public static final RegistrySupplier<Block> CUPCAKE_DISPLAY = ObjectRegistry.registerWithItem("cupcake_display", () -> new CupcakeDisplayBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.FLOWER_POT).sound(SoundType.WOOD)));
    public static final RegistrySupplier<Block> BREADBOX = ObjectRegistry.registerWithItem("breadbox", () -> new BreadBox(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS)));
    public static final RegistrySupplier<Block> TRAY = ObjectRegistry.registerWithItem("tray", () -> new TrayBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS)));
    public static final RegistrySupplier<Block> BREAD_CRATE = ObjectRegistry.registerWithItem("bread_crate", () -> new BreadBasketBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS)));
    public static final RegistrySupplier<Block> WALL_DISPLAY = ObjectRegistry.registerWithItem("wall_display", () -> new WallDisplayBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS)));
    public static final RegistrySupplier<Block> CHOCOLATE_BOX = ObjectRegistry.registerWithItem("chocolate_box", () -> new EatableBoxBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CAKE)));
    public static final RegistrySupplier<Item> ROLLING_PIN = ObjectRegistry.registerItem("rolling_pin", () -> new SwordItem((Tier)Tiers.WOOD, ObjectRegistry.getSettings().rarity(Rarity.COMMON).attributes(SwordItem.createAttributes((Tier)Tiers.WOOD, (int)1, (float)-2.0f))));
    public static final RegistrySupplier<Item> BREAD_KNIFE = ObjectRegistry.registerItem("bread_knife", () -> new SwordItem((Tier)Tiers.IRON, ObjectRegistry.getSettings().rarity(Rarity.COMMON).attributes(SwordItem.createAttributes((Tier)Tiers.WOOD, (int)1, (float)-2.0f))));
    public static final RegistrySupplier<Block> SMALL_COOKING_POT = ObjectRegistry.registerWithoutItem("small_cooking_pot", () -> new SmallCookingPotBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK)));
    public static final RegistrySupplier<Item> SMALL_COOKING_POT_ITEM = ObjectRegistry.registerItem("small_cooking_pot", () -> new SmallCookingPotItem((Block)SMALL_COOKING_POT.get(), ObjectRegistry.getSettings().attributes(SmallCookingPotItem.createAttributes())));
    public static final RegistrySupplier<Block> JAR = ObjectRegistry.registerWithItem("jar", () -> new StackableBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLASS).instabreak().noOcclusion().sound(SoundType.GLASS), 3));
    public static final RegistrySupplier<Block> STRAWBERRY_JAM = ObjectRegistry.registerWithItem("strawberry_jam", () -> new StackableBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLASS).instabreak().noOcclusion().sound(SoundType.GLASS), 3));
    public static final RegistrySupplier<Block> GLOWBERRY_JAM = ObjectRegistry.registerWithItem("glowberry_jam", () -> new StackableBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLASS).instabreak().noOcclusion().sound(SoundType.GLASS), 3));
    public static final RegistrySupplier<Block> SWEETBERRY_JAM = ObjectRegistry.registerWithItem("sweetberry_jam", () -> new StackableBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLASS).instabreak().noOcclusion().sound(SoundType.GLASS), 3));
    public static final RegistrySupplier<Block> CHOCOLATE_JAM = ObjectRegistry.registerWithItem("chocolate_jam", () -> new StackableBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLASS).instabreak().noOcclusion().sound(SoundType.GLASS), 3));
    public static final RegistrySupplier<Block> APPLE_JAM = ObjectRegistry.registerWithItem("apple_jam", () -> new StackableBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLASS).instabreak().sound(SoundType.GLASS).noOcclusion(), 3));
    public static final RegistrySupplier<Block> CRUSTY_BREAD_BLOCK = ObjectRegistry.registerWithoutItem("crusty_bread_block", () -> new StackableEatableBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CAKE), 3));
    public static final RegistrySupplier<Block> BREAD_BLOCK = ObjectRegistry.registerWithoutItem("bread_block", () -> new StackableEatableBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CAKE), 3));
    public static final RegistrySupplier<Block> BAGUETTE_BLOCK = ObjectRegistry.registerWithoutItem("baguette_block", () -> new StackableEatableBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CAKE), 4));
    public static final RegistrySupplier<Block> TOAST_BLOCK = ObjectRegistry.registerWithoutItem("toast_block", () -> new StackableEatableBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CAKE), 3));
    public static final RegistrySupplier<Block> BRAIDED_BREAD_BLOCK = ObjectRegistry.registerWithoutItem("braided_bread_block", () -> new StackableEatableBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CAKE), 3));
    public static final RegistrySupplier<Block> BUN_BLOCK = ObjectRegistry.registerWithoutItem("bun_block", () -> new StackableBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CAKE), 4));
    public static final RegistrySupplier<Block> WAFFLE_BLOCK = ObjectRegistry.registerWithoutItem("waffle_block", () -> new StackableEatableBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CAKE), 4));
    public static final RegistrySupplier<Item> CAKE_DOUGH = ObjectRegistry.registerItem("cake_dough", () -> new Item(ObjectRegistry.getSettings().food(Foods.SWEET_BERRIES)));
    public static final RegistrySupplier<Item> SWEET_DOUGH = ObjectRegistry.registerItem("sweet_dough", () -> new Item(ObjectRegistry.getSettings().food(Foods.SWEET_BERRIES)));
    public static final RegistrySupplier<Item> CROISSANT = ObjectRegistry.registerItem("croissant", () -> new EffectItem(ObjectRegistry.getFoodItemSettings(PlatformHelper.getCroissantNutrition(), PlatformHelper.getCroissantSaturation(), (RegistrySupplier<MobEffect>)MobEffectRegistry.SUSTENANCE, 900), 400, false));
    public static final RegistrySupplier<Item> CRUSTY_BREAD = ObjectRegistry.registerItem("crusty_bread", () -> new EffectBlockItem((Block)CRUSTY_BREAD_BLOCK.get(), ObjectRegistry.getFoodItemSettings(PlatformHelper.getCrustyBreadNutrition(), PlatformHelper.getCrustyBreadSaturation(), (RegistrySupplier<MobEffect>)MobEffectRegistry.SUSTENANCE, 4800)));
    public static final RegistrySupplier<Item> BREAD = ObjectRegistry.registerItem("bread", () -> new EffectBlockItem((Block)BREAD_BLOCK.get(), ObjectRegistry.getFoodItemSettings(PlatformHelper.getBreadNutrition(), PlatformHelper.getBreadSaturation(), (RegistrySupplier<MobEffect>)MobEffectRegistry.SUSTENANCE, 4200)));
    public static final RegistrySupplier<Item> BAGUETTE = ObjectRegistry.registerItem("baguette", () -> new EffectBlockItem((Block)BAGUETTE_BLOCK.get(), ObjectRegistry.getFoodItemSettings(PlatformHelper.getBaguetteNutrition(), PlatformHelper.getBaguetteSaturation(), (RegistrySupplier<MobEffect>)MobEffectRegistry.SUSTENANCE, 4200)));
    public static final RegistrySupplier<Item> TOAST = ObjectRegistry.registerItem("toast", () -> new EffectBlockItem((Block)TOAST_BLOCK.get(), ObjectRegistry.getFoodItemSettings(PlatformHelper.getToastNutrition(), PlatformHelper.getToastSaturation(), (RegistrySupplier<MobEffect>)MobEffectRegistry.SUSTENANCE, 5400)));
    public static final RegistrySupplier<Item> BRAIDED_BREAD = ObjectRegistry.registerItem("braided_bread", () -> new EffectBlockItem((Block)BRAIDED_BREAD_BLOCK.get(), ObjectRegistry.getFoodItemSettings(PlatformHelper.getBraidedBreadNutrition(), PlatformHelper.getBraidedBreadSaturation(), (RegistrySupplier<MobEffect>)MobEffectRegistry.SUSTENANCE, 4200)));
    public static final RegistrySupplier<Item> SANDWICH = ObjectRegistry.registerItem("sandwich", () -> new EffectItem(ObjectRegistry.getFoodItemSettings(PlatformHelper.getSandwichNutrition(), PlatformHelper.getSandwichSaturation(), (RegistrySupplier<MobEffect>)MobEffectRegistry.SATIATION, 1500), 4800, false));
    public static final RegistrySupplier<Item> VEGETABLE_SANDWICH = ObjectRegistry.registerItem("vegetable_sandwich", () -> new EffectItem(ObjectRegistry.getFoodItemSettings(PlatformHelper.getVegetableSandwichNutrition(), PlatformHelper.getVegetableSandwichSaturation(), (RegistrySupplier<MobEffect>)MobEffectRegistry.SATIATION, 1800), 4800, false));
    public static final RegistrySupplier<Item> GRILLED_SALMON_SANDWICH = ObjectRegistry.registerItem("grilled_salmon_sandwich", () -> new EffectItem(ObjectRegistry.getFoodItemSettings(PlatformHelper.getGrilledSalmonSandwichNutrition(), PlatformHelper.getGrilledSalmonSandwichSaturation(), (RegistrySupplier<MobEffect>)MobEffectRegistry.SATIATION, 1200), 4800, false));
    public static final RegistrySupplier<Item> GRILLED_BACON_SANDWICH = ObjectRegistry.registerItem("grilled_bacon_sandwich", () -> new EffectItem(ObjectRegistry.getFoodItemSettings(PlatformHelper.getGrilledBaconSandwichNutrition(), PlatformHelper.getGrilledBaconSandwichSaturation(), (RegistrySupplier<MobEffect>)MobEffectRegistry.SATIATION, 1200), 6000, false));
    public static final RegistrySupplier<Item> BREAD_WITH_JAM = ObjectRegistry.registerItem("bread_with_jam", () -> new EffectItem(ObjectRegistry.getFoodItemSettings(PlatformHelper.getBreadWithJamNutrition(), PlatformHelper.getBreadWithJamSaturation(), (RegistrySupplier<MobEffect>)MobEffectRegistry.RESTED, 400), 2500, false));
    public static final RegistrySupplier<Item> STRAWBERRY_CAKE_SLICE = ObjectRegistry.registerItem("strawberry_cake_slice", () -> new EffectItem(ObjectRegistry.getFoodItemSettings(PlatformHelper.getStrawberryCakeSliceNutrition(), PlatformHelper.getStrawberryCakeSliceSaturation(), (RegistrySupplier<MobEffect>)MobEffectRegistry.SWEETS, 900), 700, false));
    public static final RegistrySupplier<Item> SWEETBERRY_CAKE_SLICE = ObjectRegistry.registerItem("sweetberry_cake_slice", () -> new EffectItem(ObjectRegistry.getFoodItemSettings(PlatformHelper.getSweetberryCakeSliceNutrition(), PlatformHelper.getSweetberryCakeSliceSaturation(), (RegistrySupplier<MobEffect>)MobEffectRegistry.SWEETS, 900), 700, false));
    public static final RegistrySupplier<Item> CHOCOLATE_CAKE_SLICE = ObjectRegistry.registerItem("chocolate_cake_slice", () -> new EffectItem(ObjectRegistry.getFoodItemSettings(PlatformHelper.getChocolateCakeSliceNutrition(), PlatformHelper.getChocolateCakeSliceSaturation(), (RegistrySupplier<MobEffect>)MobEffectRegistry.SWEETS, 900), 700, false));
    public static final RegistrySupplier<Item> CHOCOLATE_GATEAU_SLICE = ObjectRegistry.registerItem("chocolate_gateau_slice", () -> new EffectItem(ObjectRegistry.getFoodItemSettings(PlatformHelper.getChocolateGateauSliceNutrition(), PlatformHelper.getChocolateGateauSliceSaturation(), (RegistrySupplier<MobEffect>)MobEffectRegistry.SWEETS, 900), 800, false));
    public static final RegistrySupplier<Item> BUNDT_CAKE_SLICE = ObjectRegistry.registerItem("bundt_cake_slice", () -> new EffectItem(ObjectRegistry.getFoodItemSettings(PlatformHelper.getBundtCakeSliceNutrition(), PlatformHelper.getBundtCakeSliceSaturation(), (RegistrySupplier<MobEffect>)MobEffectRegistry.SWEETS, 900), 800, false));
    public static final RegistrySupplier<Item> LINZER_TART_SLICE = ObjectRegistry.registerItem("linzer_tart_slice", () -> new EffectItem(ObjectRegistry.getFoodItemSettings(PlatformHelper.getLinzerTartSliceNutrition(), PlatformHelper.getLinzerTartSliceSaturation(), (RegistrySupplier<MobEffect>)MobEffectRegistry.SWEETS, 900), 800, false));
    public static final RegistrySupplier<Item> APPLE_PIE_SLICE = ObjectRegistry.registerItem("apple_pie_slice", () -> new EffectItem(ObjectRegistry.getFoodItemSettings(PlatformHelper.getApplePieSliceNutrition(), PlatformHelper.getApplePieSliceSaturation(), (RegistrySupplier<MobEffect>)MobEffectRegistry.SWEETS, 900), 800, false));
    public static final RegistrySupplier<Item> GLOWBERRY_PIE_SLICE = ObjectRegistry.registerItem("glowberry_pie_slice", () -> new EffectItem(ObjectRegistry.getFoodItemSettings(PlatformHelper.getGlowberryPieSliceNutrition(), PlatformHelper.getGlowberryPieSliceSaturation(), (RegistrySupplier<MobEffect>)MobEffectRegistry.SWEETS, 900), 800, false));
    public static final RegistrySupplier<Item> CHOCOLATE_TART_SLICE = ObjectRegistry.registerItem("chocolate_tart_slice", () -> new EffectItem(ObjectRegistry.getFoodItemSettings(PlatformHelper.getChocolateTartSliceNutrition(), PlatformHelper.getChocolateTartSliceSaturation(), (RegistrySupplier<MobEffect>)MobEffectRegistry.SWEETS, 900), 800, false));
    public static final RegistrySupplier<Item> PUDDING_SLICE = ObjectRegistry.registerItem("pudding_slice", () -> new EffectItem(ObjectRegistry.getFoodItemSettings(PlatformHelper.getPuddingSliceNutrition(), PlatformHelper.getPuddingSliceSaturation(), (RegistrySupplier<MobEffect>)MobEffectRegistry.SWEETS, 900), 800, false));
    public static final RegistrySupplier<Item> STRAWBERRY_GLAZED_COOKIE = ObjectRegistry.registerItem("strawberry_glazed_cookie", () -> new EffectItem(ObjectRegistry.getFoodItemSettings(PlatformHelper.getStrawberryGlazedCookieNutrition(), PlatformHelper.getStrawberryGlazedCookieSaturation(), (RegistrySupplier<MobEffect>)MobEffectRegistry.SWEETS, 900), 800, false));
    public static final RegistrySupplier<Item> SWEETBERRY_GLAZED_COOKIE = ObjectRegistry.registerItem("sweetberry_glazed_cookie", () -> new EffectItem(ObjectRegistry.getFoodItemSettings(PlatformHelper.getSweetberryGlazedCookieNutrition(), PlatformHelper.getSweetberryGlazedCookieSaturation(), (RegistrySupplier<MobEffect>)MobEffectRegistry.SWEETS, 900), 800, false));
    public static final RegistrySupplier<Item> CHOCOLATE_GLAZED_COOKIE = ObjectRegistry.registerItem("chocolate_glazed_cookie", () -> new EffectItem(ObjectRegistry.getFoodItemSettings(PlatformHelper.getChocolateGlazedCookieNutrition(), PlatformHelper.getChocolateGlazedCookieSaturation(), (RegistrySupplier<MobEffect>)MobEffectRegistry.SWEETS, 900), 800, false));
    public static final RegistrySupplier<Item> STRAWBERRY_CUPCAKE = ObjectRegistry.registerItem("strawberry_cupcake", () -> new EffectItem(ObjectRegistry.getFoodItemSettings(PlatformHelper.getStrawberryCupcakeNutrition(), PlatformHelper.getStrawberryCupcakeSaturation(), (RegistrySupplier<MobEffect>)MobEffectRegistry.SWEETS, 900), 800, false));
    public static final RegistrySupplier<Item> SWEETBERRY_CUPCAKE = ObjectRegistry.registerItem("sweetberry_cupcake", () -> new EffectItem(ObjectRegistry.getFoodItemSettings(PlatformHelper.getSweetberryCupcakeNutrition(), PlatformHelper.getSweetberryCupcakeSaturation(), (RegistrySupplier<MobEffect>)MobEffectRegistry.SWEETS, 900), 800, false));
    public static final RegistrySupplier<Item> APPLE_CUPCAKE = ObjectRegistry.registerItem("apple_cupcake", () -> new EffectItem(ObjectRegistry.getFoodItemSettings(PlatformHelper.getAppleCupcakeNutrition(), PlatformHelper.getAppleCupcakeSaturation(), (RegistrySupplier<MobEffect>)MobEffectRegistry.SWEETS, 900), 800, false));
    public static final RegistrySupplier<Item> CORNET = ObjectRegistry.registerItem("cornet", () -> new EffectItem(ObjectRegistry.getFoodItemSettings(PlatformHelper.getCornetNutrition(), PlatformHelper.getCornetSaturation(), (RegistrySupplier<MobEffect>)MobEffectRegistry.SWEETS, 900), 800, false));
    public static final RegistrySupplier<Item> JAM_ROLL = ObjectRegistry.registerItem("jam_roll", () -> new EffectItem(ObjectRegistry.getFoodItemSettings(PlatformHelper.getJamRollNutrition(), PlatformHelper.getJamRollSaturation(), (RegistrySupplier<MobEffect>)MobEffectRegistry.SWEETS, 900), 800, false));
    public static final RegistrySupplier<Item> WAFFLE = ObjectRegistry.registerItem("waffle", () -> new EffectBlockItem((Block)WAFFLE_BLOCK.get(), ObjectRegistry.getFoodItemSettings(PlatformHelper.getWaffleNutrition(), PlatformHelper.getWaffleSaturation(), (RegistrySupplier<MobEffect>)MobEffectRegistry.SUSTENANCE, 800)));
    public static final RegistrySupplier<Item> CHOCOLATE_TRUFFLE = ObjectRegistry.registerItem("chocolate_truffle", () -> new EffectItem(ObjectRegistry.getFoodItemSettings(PlatformHelper.getChocolateTruffleNutrition(), PlatformHelper.getChocolateTruffleSaturation(), (RegistrySupplier<MobEffect>)MobEffectRegistry.SWEETS, 900), 200, false));
    public static final RegistrySupplier<Item> MISSLILITU_BISCUIT = ObjectRegistry.registerItem("misslilitu_biscuit", () -> new EffectItem(ObjectRegistry.getFoodItemSettings(PlatformHelper.getMisslilituBiscuitNutrition(), PlatformHelper.getMisslilituBiscuitSaturation(), (RegistrySupplier<MobEffect>)MobEffectRegistry.SUSTENANCE, 900), 4200, false));
    public static final RegistrySupplier<Item> BUN = ObjectRegistry.registerItem("bun", () -> new EffectBlockItem((Block)BUN_BLOCK.get(), ObjectRegistry.getFoodItemSettings(PlatformHelper.getBunNutrition(), PlatformHelper.getBunSaturation(), (RegistrySupplier<MobEffect>)MobEffectRegistry.SUSTENANCE, 2800)));
    public static final RegistrySupplier<Block> CHOCOLATE_GATEAU = ObjectRegistry.registerWithItem("chocolate_gateau", () -> new CakeBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CAKE), (Supplier<Item>)CHOCOLATE_GATEAU_SLICE));
    public static final RegistrySupplier<Block> CHOCOLATE_TART = ObjectRegistry.registerWithItem("chocolate_tart", () -> new ChocolateTart(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CAKE), (Supplier<Item>)CHOCOLATE_TART_SLICE));
    public static final RegistrySupplier<Block> BLANK_CAKE = ObjectRegistry.registerWithoutItem("blank_cake", () -> new BlankCakeBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CAKE).forceSolidOn()));
    public static final RegistrySupplier<Block> APPLE_CUPCAKE_BLOCK = ObjectRegistry.registerWithoutItem("apple_cupcake_block", () -> new CupcakeBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CAKE).instabreak().forceSolidOn()));
    public static final RegistrySupplier<Block> SWEETBERRY_CUPCAKE_BLOCK = ObjectRegistry.registerWithoutItem("sweetberry_cupcake_block", () -> new CupcakeBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CAKE).instabreak().forceSolidOn()));
    public static final RegistrySupplier<Block> STRAWBERRY_CUPCAKE_BLOCK = ObjectRegistry.registerWithoutItem("strawberry_cupcake_block", () -> new CupcakeBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CAKE).instabreak().forceSolidOn()));
    public static final RegistrySupplier<Block> CHOCOLATE_COOKIE_BLOCK = ObjectRegistry.registerWithoutItem("chocolate_cookie_block", () -> new CookieBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CAKE).instabreak().forceSolidOn()));
    public static final RegistrySupplier<Block> SWEETBERRY_COOKIE_BLOCK = ObjectRegistry.registerWithoutItem("sweetberry_cookie_block", () -> new CookieBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CAKE).instabreak().forceSolidOn()));
    public static final RegistrySupplier<Block> STRAWBERRY_COOKIE_BLOCK = ObjectRegistry.registerWithoutItem("strawberry_cookie_block", () -> new CookieBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CAKE).instabreak().forceSolidOn()));
    public static final RegistrySupplier<Block> STRAWBERRY_CAKE = ObjectRegistry.registerWithItem("strawberry_cake", () -> new CakeBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CAKE), (Supplier<Item>)STRAWBERRY_CAKE_SLICE));
    public static final RegistrySupplier<Block> SWEETBERRY_CAKE = ObjectRegistry.registerWithItem("sweetberry_cake", () -> new CakeBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CAKE), (Supplier<Item>)SWEETBERRY_CAKE_SLICE));
    public static final RegistrySupplier<Block> CHOCOLATE_CAKE = ObjectRegistry.registerWithItem("chocolate_cake", () -> new CakeBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CAKE), (Supplier<Item>)CHOCOLATE_CAKE_SLICE));
    public static final RegistrySupplier<Block> BUNDT_CAKE = ObjectRegistry.registerWithItem("bundt_cake", () -> new BundtCakeBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CAKE), (Supplier<Item>)BUNDT_CAKE_SLICE));
    public static final RegistrySupplier<Block> LINZER_TART = ObjectRegistry.registerWithItem("linzer_tart", () -> new LinzerTartBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CAKE), (Supplier<Item>)LINZER_TART_SLICE));
    public static final RegistrySupplier<Block> APPLE_PIE = ObjectRegistry.registerWithItem("apple_pie", () -> new ApplePieBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CAKE), (Supplier<Item>)APPLE_PIE_SLICE));
    public static final RegistrySupplier<Block> GLOWBERRY_TART = ObjectRegistry.registerWithItem("glowberry_tart", () -> new GlowberryTartBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CAKE), (Supplier<Item>)GLOWBERRY_PIE_SLICE));
    public static final RegistrySupplier<Block> PUDDING = ObjectRegistry.registerWithItem("pudding", () -> new PuddingBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CAKE), (Supplier<Item>)PUDDING_SLICE));

    public static void init() {
        ITEMS.register();
        BLOCKS.register();
    }

    private static Item.Properties getSettings(Consumer<Item.Properties> consumer) {
        Item.Properties settings = new Item.Properties();
        consumer.accept(settings);
        return settings;
    }

    static Item.Properties getSettings() {
        return ObjectRegistry.getSettings(settings -> {});
    }

    public static <T extends Block> RegistrySupplier<T> registerWithItem(String name, Supplier<T> block) {
        return GeneralUtil.registerWithItem(BLOCKS, BLOCK_REGISTRAR, ITEMS, ITEM_REGISTRAR, (ResourceLocation)BakeryIdentifier.identifier(name), block);
    }

    public static <T extends Block> RegistrySupplier<T> registerWithoutItem(String path, Supplier<T> block) {
        return GeneralUtil.registerWithoutItem(BLOCKS, BLOCK_REGISTRAR, (ResourceLocation)BakeryIdentifier.identifier(path), block);
    }

    public static <T extends Item> RegistrySupplier<T> registerItem(String path, Supplier<T> itemSupplier) {
        return GeneralUtil.registerItem(ITEMS, ITEM_REGISTRAR, (ResourceLocation)BakeryIdentifier.identifier(path), itemSupplier);
    }

    public static BlockBehaviour.Properties properties(float strength) {
        return ObjectRegistry.properties(strength, strength);
    }

    public static BlockBehaviour.Properties properties(float breakSpeed, float explosionResist) {
        return BlockBehaviour.Properties.of().strength(breakSpeed, explosionResist);
    }

    private static Item.Properties getFoodItemSettings(int nutrition, float saturationMod, RegistrySupplier<MobEffect> effect, int duration) {
        return ObjectRegistry.getFoodItemSettings(nutrition, saturationMod, effect, duration, false, false);
    }

    private static Item.Properties getFoodItemSettings(int nutrition, float saturationMod, RegistrySupplier<MobEffect> effect, int duration, boolean alwaysEat, boolean fast) {
        return ObjectRegistry.getSettings().food(ObjectRegistry.createFood(nutrition, saturationMod, (Holder<MobEffect>)BuiltInRegistries.MOB_EFFECT.wrapAsHolder((Object)((MobEffect)effect.get())), duration, alwaysEat, fast));
    }

    private static FoodProperties createFood(int nutrition, float saturationMod, Holder<MobEffect> effect, int duration, boolean alwaysEat, boolean fast) {
        FoodProperties.Builder food = new FoodProperties.Builder().nutrition(nutrition).saturationModifier(saturationMod);
        if (alwaysEat) {
            food.alwaysEdible();
        }
        if (fast) {
            food.fast();
        }
        if (effect != null) {
            food.effect(new MobEffectInstance(effect, duration), 1.0f);
        }
        return food.build();
    }
}

