/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_attributes.compat;

import com.google.common.collect.Multimap;
import dev.shadowsoffire.apothic_attributes.api.ALObjects;
import dev.shadowsoffire.apothic_attributes.client.ModifierSource;
import dev.shadowsoffire.apothic_attributes.client.ModifierSourceType;
import dev.shadowsoffire.apothic_attributes.compat.CurioEquipmentSlot;
import dev.shadowsoffire.apothic_attributes.modifiers.EntityEquipmentSlot;
import dev.shadowsoffire.apothic_attributes.modifiers.EntitySlotGroup;
import dev.shadowsoffire.apothic_attributes.modifiers.StackAttributeModifiers;
import dev.shadowsoffire.apothic_attributes.modifiers.StackAttributeModifiersEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.event.CurioAttributeModifierEvent;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public class CuriosCompat {
    private static final Map<String, Holder<EntityEquipmentSlot>> CURIO_TYPE_TO_EQUIPMENT_SLOT = new HashMap<String, Holder<EntityEquipmentSlot>>();

    public static void init() {
        ModifierSourceType.register(new ModifierSourceType<Object>(){

            @Override
            public void extract(LivingEntity entity, BiConsumer<AttributeModifier, ModifierSource<?>> map) {
                CuriosApi.getCuriosInventory((LivingEntity)entity).ifPresent(handler -> {
                    Map curios = handler.getCurios();
                    for (Map.Entry entry : curios.entrySet()) {
                        ICurioStacksHandler stacksHandler = (ICurioStacksHandler)entry.getValue();
                        String identifier = (String)entry.getKey();
                        IDynamicStackHandler stackHandler = stacksHandler.getStacks();
                        for (int i = 0; i < stacksHandler.getSlots(); ++i) {
                            SlotContext slotContext = new SlotContext(identifier, entity, i, false, true);
                            ItemStack stack = stackHandler.getStackInSlot(i);
                            if (stack.isEmpty()) continue;
                            ResourceLocation id = CuriosApi.getSlotId((SlotContext)slotContext);
                            Multimap modifiers = CuriosApi.getAttributeModifiers((SlotContext)slotContext, (ResourceLocation)id, (ItemStack)stack);
                            ModifierSource.ItemModifierSource src = new ModifierSource.ItemModifierSource(stack);
                            modifiers.values().forEach(m -> map.accept((AttributeModifier)m, src));
                        }
                    }
                });
            }

            @Override
            public int getPriority() {
                return 20;
            }
        });
        NeoForge.EVENT_BUS.addListener(EventPriority.HIGH, CuriosCompat::stackAttrModifierCompat);
    }

    @Nullable
    public static synchronized Holder<EntityEquipmentSlot> getSlotForCurio(String curioType) {
        return CURIO_TYPE_TO_EQUIPMENT_SLOT.computeIfAbsent(curioType, key -> {
            for (EntityEquipmentSlot slot : ALObjects.BuiltInRegs.ENTITY_EQUIPMENT_SLOT) {
                CurioEquipmentSlot curioSlot;
                if (!(slot instanceof CurioEquipmentSlot) || !(curioSlot = (CurioEquipmentSlot)slot).curioType().equals(key)) continue;
                return ALObjects.BuiltInRegs.ENTITY_EQUIPMENT_SLOT.wrapAsHolder((Object)slot);
            }
            return null;
        });
    }

    public static void stackAttrModifierCompat(CurioAttributeModifierEvent e) {
        Holder<EntityEquipmentSlot> curioSlot = CuriosCompat.getSlotForCurio(e.getSlotContext().identifier());
        if (curioSlot != null) {
            StackAttributeModifiers.Builder builder = StackAttributeModifiers.builder();
            EntitySlotGroup group = (EntitySlotGroup)ALObjects.BuiltInRegs.ENTITY_SLOT_GROUP.get(curioSlot.getKey().location());
            if (group != null) {
                e.getModifiers().forEach((attr, modif) -> builder.add((Holder<Attribute>)attr, (AttributeModifier)modif, group));
            }
            StackAttributeModifiersEvent event = new StackAttributeModifiersEvent(e.getItemStack(), builder.build());
            NeoForge.EVENT_BUS.post((Event)event);
            if (event.hasChanges()) {
                if (group != null) {
                    e.clearModifiers();
                }
                StackAttributeModifiers newModifs = event.build();
                for (StackAttributeModifiers.Entry entry : newModifs.modifiers()) {
                    if (!entry.slots().test(curioSlot)) continue;
                    e.addModifier(entry.attribute(), entry.modifier());
                }
            }
        }
    }

    static {
        if (!ModList.get().isLoaded("curios")) {
            throw new UnsupportedOperationException("This optional compat class requires Curios to be loaded.");
        }
    }
}

