/*
 * Decompiled with CFR 0.152.
 */
package com.dragonblak.mysticalengineering.datagen;

import blusunrize.immersiveengineering.api.crafting.ClocheRecipe;
import blusunrize.immersiveengineering.api.crafting.ClocheRenderFunction;
import blusunrize.immersiveengineering.api.crafting.TagOutput;
import blusunrize.immersiveengineering.client.utils.ClocheRenderFunctions;
import com.blakebr0.mysticalagriculture.api.MysticalAgricultureAPI;
import com.blakebr0.mysticalagriculture.api.crop.Crop;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class ModRecipeProvider
extends RecipeProvider {
    public ModRecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
    }

    protected void buildRecipes(RecipeOutput recipeOutput) {
        this.GetSeeds(recipeOutput);
    }

    public void GetSeeds(RecipeOutput output) {
        List crops = MysticalAgricultureAPI.getCropRegistry().getCrops();
        for (Crop crop : crops) {
            this.CreateClocheRecipe(crop, output);
        }
    }

    public void CreateClocheRecipe(Crop crop, RecipeOutput output) {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"mysticalengineering", (String)("cloche_" + crop.getName() + "_seed"));
        Ingredient soil = Ingredient.of((ItemLike[])new ItemLike[]{crop.getTier().getFarmland()});
        Ingredient seed = Ingredient.of((ItemLike[])new ItemLike[]{crop.getSeedsItem()});
        TagOutput result = new TagOutput((ItemLike)crop.getEssenceItem(), 2);
        ClocheRecipe recipe = new ClocheRecipe(result, seed, soil, 1200, (ClocheRenderFunction)new ClocheRenderFunctions.RenderFunctionCrop((Block)crop.getCropBlock()));
        output.accept(id, (Recipe)recipe, null);
    }
}

