/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.event.events.common.TickEvent;
import io.wispforest.endec.impl.ReflectiveEndecBuilder;
import io.wispforest.owo.serialization.endec.MinecraftEndecs;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.util.tuples.Pair;
import rearth.oritech.api.networking.NetworkManager;
import rearth.oritech.block.blocks.pipes.energy.EnergyPipeBlock;
import rearth.oritech.block.blocks.pipes.energy.SuperConductorBlock;
import rearth.oritech.block.blocks.pipes.fluid.FluidPipeBlock;
import rearth.oritech.block.blocks.pipes.item.ItemPipeBlock;
import rearth.oritech.block.entity.accelerator.AcceleratorParticleLogic;
import rearth.oritech.block.entity.addons.AddonBlockEntity;
import rearth.oritech.block.entity.augmenter.PlayerAugments;
import rearth.oritech.block.entity.augmenter.api.Augment;
import rearth.oritech.block.entity.interaction.PowerPoleEntity;
import rearth.oritech.block.entity.pipes.GenericPipeInterfaceEntity;
import rearth.oritech.client.init.ModScreens;
import rearth.oritech.client.init.ParticleContent;
import rearth.oritech.init.BlockContent;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.init.ComponentContent;
import rearth.oritech.init.EntitiesContent;
import rearth.oritech.init.FluidContent;
import rearth.oritech.init.ItemContent;
import rearth.oritech.init.ItemGroups;
import rearth.oritech.init.LootContent;
import rearth.oritech.init.OritechConfig;
import rearth.oritech.init.SoundContent;
import rearth.oritech.init.ToolsContent;
import rearth.oritech.init.recipes.RecipeContent;
import rearth.oritech.init.world.FeatureContent;
import rearth.oritech.item.tools.ElectricMaceItem;
import rearth.oritech.util.registry.ArchitecturyBlockRegistryContainer;
import rearth.oritech.util.registry.ArchitecturyRecipeRegistryContainer;
import rearth.oritech.util.registry.ArchitecturyRegistryContainer;

public final class Oritech {
    public static final String MOD_ID = "oritech";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"oritech");
    public static final OritechConfig CONFIG = OritechConfig.createAndLoad();
    public static final Multimap<ResourceLocation, Runnable> EVENT_MAP = Oritech.initEventMap();
    public static Set<Pair<ItemLike, Float>> COMPOSTABLES_DATA = new HashSet<Pair<ItemLike, Float>>();

    public static ResourceLocation id(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }

    public static void initialize() {
        LOGGER.info("Begin Oritech initialization");
        NetworkManager.init();
        NetworkManager.registerDefaultCodecs();
        ParticleContent.registerParticles();
        FeatureContent.initialize();
        LifecycleEvent.SERVER_STARTED.register(Oritech::onServerStarted);
        LifecycleEvent.SERVER_STARTED.register(server -> PlayerAugments.loadAllAugments(server.getRecipeManager()));
        TickEvent.SERVER_POST.register(elem -> AcceleratorParticleLogic.onTickEnd());
        TickEvent.SERVER_POST.register(elem -> AddonBlockEntity.completeInits());
        TickEvent.SERVER_POST.register(elem -> ElectricMaceItem.processLightningEvents((Level)elem.overworld()));
        ComponentContent.COMPONENTS.register();
        TickEvent.SERVER_PRE.register(event -> event.getAllLevels().forEach(world -> world.players().forEach(PlayerAugments::serverTickAugments)));
        LOGGER.info("Oritech initialization complete");
    }

    public static void runAllRegistries() {
        LOGGER.info("Running Oritech registrations...");
        LOGGER.debug("Registering fluids");
        EVENT_MAP.get((Object)Registries.FLUID.location()).forEach(Runnable::run);
        for (ResourceLocation type : EVENT_MAP.keySet()) {
            if (type.equals((Object)Registries.FLUID.location()) || type.equals((Object)Registries.CREATIVE_MODE_TAB.location())) continue;
            EVENT_MAP.get((Object)type).forEach(Runnable::run);
        }
        LOGGER.debug("Registering item groups");
        EVENT_MAP.get((Object)Registries.CREATIVE_MODE_TAB.location()).forEach(Runnable::run);
        LOGGER.info("Oritech registrations complete");
    }

    public static Multimap<ResourceLocation, Runnable> initEventMap() {
        ArrayListMultimap res = ArrayListMultimap.create();
        res.put((Object)Registries.FLUID.location(), FluidContent::registerFluids);
        res.put((Object)Registries.BLOCK.location(), FluidContent::registerBlocks);
        res.put((Object)Registries.ITEM.location(), FluidContent::registerItems);
        res.put((Object)Registries.ITEM.location(), () -> ArchitecturyRegistryContainer.register(ItemContent.class, MOD_ID, false));
        res.put((Object)Registries.BLOCK.location(), () -> ArchitecturyRegistryContainer.register(BlockContent.class, MOD_ID, false));
        res.put((Object)Registries.ITEM.location(), ArchitecturyBlockRegistryContainer::finishItemRegister);
        res.put((Object)Registries.BLOCK_ENTITY_TYPE.location(), () -> ArchitecturyRegistryContainer.register(BlockEntitiesContent.class, MOD_ID, false));
        res.put((Object)Registries.SOUND_EVENT.location(), () -> ArchitecturyRegistryContainer.register(SoundContent.class, MOD_ID, false));
        res.put((Object)Registries.ITEM.location(), () -> ArchitecturyRegistryContainer.register(ToolsContent.class, MOD_ID, false));
        res.put((Object)Registries.FEATURE.location(), () -> ArchitecturyRegistryContainer.register(FeatureContent.class, MOD_ID, false));
        res.put((Object)Registries.LOOT_FUNCTION_TYPE.location(), () -> ArchitecturyRegistryContainer.register(LootContent.class, MOD_ID, false));
        res.put((Object)Registries.ENTITY_TYPE.location(), () -> ArchitecturyRegistryContainer.register(EntitiesContent.class, MOD_ID, false));
        res.put((Object)Registries.ITEM.location(), ToolsContent::registerEventHandlers);
        res.put((Object)Registries.MENU.location(), () -> ArchitecturyRegistryContainer.register(ModScreens.class, MOD_ID, false));
        res.put((Object)Registries.RECIPE_TYPE.location(), () -> ArchitecturyRegistryContainer.register(RecipeContent.class, MOD_ID, false));
        res.put((Object)Registries.CREATIVE_MODE_TAB.location(), () -> ArchitecturyRegistryContainer.register(ItemGroups.class, MOD_ID, false));
        res.put((Object)Registries.RECIPE_SERIALIZER.location(), ArchitecturyRecipeRegistryContainer::finishSerializerRegister);
        res.put((Object)Registries.LOOT_FUNCTION_TYPE.location(), FluidContent::registerItemsToGroups);
        res.put((Object)ResourceLocation.fromNamespaceAndPath((String)"neoforge", (String)"attachment_types"), Augment::registerAttachmentTypes);
        return res;
    }

    private static void onServerStarted(MinecraftServer minecraftServer) {
        minecraftServer.getAllLevels().forEach(world -> {
            if (world.isClientSide) {
                return;
            }
            ResourceLocation regKey = world.dimension().location();
            String dataId = "energy_" + regKey.getNamespace() + "_" + regKey.getPath();
            GenericPipeInterfaceEntity.PipeNetworkData result = (GenericPipeInterfaceEntity.PipeNetworkData)world.getDataStorage().computeIfAbsent(GenericPipeInterfaceEntity.PipeNetworkData.TYPE, dataId);
            EnergyPipeBlock.ENERGY_PIPE_DATA.put(regKey, result);
            String fluidDataId = "fluid_" + regKey.getNamespace() + "_" + regKey.getPath();
            GenericPipeInterfaceEntity.PipeNetworkData fluidResult = (GenericPipeInterfaceEntity.PipeNetworkData)world.getDataStorage().computeIfAbsent(GenericPipeInterfaceEntity.PipeNetworkData.TYPE, fluidDataId);
            FluidPipeBlock.FLUID_PIPE_DATA.put(regKey, fluidResult);
            String itemDataId = "item_" + regKey.getNamespace() + "_" + regKey.getPath();
            GenericPipeInterfaceEntity.PipeNetworkData itemResult = (GenericPipeInterfaceEntity.PipeNetworkData)world.getDataStorage().computeIfAbsent(GenericPipeInterfaceEntity.PipeNetworkData.TYPE, itemDataId);
            ItemPipeBlock.ITEM_PIPE_DATA.put(regKey, itemResult);
            String superConductorDataId = "superconductor_" + regKey.getNamespace() + "_" + regKey.getPath();
            GenericPipeInterfaceEntity.PipeNetworkData superConductorResult = (GenericPipeInterfaceEntity.PipeNetworkData)world.getDataStorage().computeIfAbsent(GenericPipeInterfaceEntity.PipeNetworkData.TYPE, superConductorDataId);
            SuperConductorBlock.SUPERCONDUCTOR_DATA.put(regKey, superConductorResult);
            String powerPoleId = "pole_" + regKey.getNamespace() + "_" + regKey.getPath();
            PowerPoleEntity.PoleNetworkData powerPoleResult = (PowerPoleEntity.PoleNetworkData)world.getDataStorage().computeIfAbsent(PowerPoleEntity.PoleNetworkData.TYPE, powerPoleId);
            PowerPoleEntity.POLE_NETWORK_DATA.put(regKey, powerPoleResult);
        });
    }

    static {
        ReflectiveEndecBuilder.SHARED_INSTANCE.register(MinecraftEndecs.IDENTIFIER, ResourceLocation.class);
    }
}

