/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.blocks.interaction;

import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.block.blocks.pipes.GenericPipeBlock;
import rearth.oritech.init.TagContent;

public class MachineFrameBlock
extends Block {
    private static final Boolean USE_ACCURATE_OUTLINES = Oritech.CONFIG.tightMachineFrameHitboxes();
    public static final BooleanProperty NORTH = PipeBlock.NORTH;
    public static final BooleanProperty EAST = PipeBlock.EAST;
    public static final BooleanProperty SOUTH = PipeBlock.SOUTH;
    public static final BooleanProperty WEST = PipeBlock.WEST;
    public static final BooleanProperty UP = PipeBlock.UP;
    public static final BooleanProperty DOWN = PipeBlock.DOWN;
    protected final VoxelShape[] boundingShapes;

    public MachineFrameBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)UP, (Comparable)Boolean.valueOf(false))).setValue((Property)DOWN, (Comparable)Boolean.valueOf(false)));
        this.boundingShapes = this.createShapes();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{NORTH, EAST, SOUTH, WEST, UP, DOWN});
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag options) {
        super.appendHoverText(stack, context, tooltip, options);
        tooltip.add((Component)Component.translatable((String)"tooltip.oritech.machine_frame").withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
        tooltip.add((Component)Component.translatable((String)"tooltip.oritech.machine_frame.1", (Object[])new Object[]{Oritech.CONFIG.processingMachines.machineFrameMaxLength(), Oritech.CONFIG.processingMachines.machineFrameMaxLength()}).withStyle(ChatFormatting.GRAY));
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    private VoxelShape getShape(BlockState state) {
        return this.boundingShapes[MachineFrameBlock.packStates(state)];
    }

    private static int packStates(BlockState state) {
        int i = 0;
        if (((Boolean)state.getValue((Property)NORTH)).booleanValue()) {
            i |= 1;
        }
        if (((Boolean)state.getValue((Property)EAST)).booleanValue()) {
            i |= 2;
        }
        if (((Boolean)state.getValue((Property)SOUTH)).booleanValue()) {
            i |= 4;
        }
        if (((Boolean)state.getValue((Property)WEST)).booleanValue()) {
            i |= 8;
        }
        if (((Boolean)state.getValue((Property)UP)).booleanValue()) {
            i |= 0x10;
        }
        if (((Boolean)state.getValue((Property)DOWN)).booleanValue()) {
            i |= 0x20;
        }
        return i;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if (!USE_ACCURATE_OUTLINES.booleanValue()) {
            return super.getShape(state, world, pos, context);
        }
        return this.getShape(state);
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return this.getShape(state);
    }

    protected VoxelShape[] createShapes() {
        return GenericPipeBlock.createShapes(Block.box((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0), Block.box((double)5.0, (double)5.0, (double)0.0, (double)11.0, (double)11.0, (double)5.0), Block.box((double)11.0, (double)5.0, (double)5.0, (double)16.0, (double)11.0, (double)11.0), Block.box((double)5.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0, (double)16.0), Block.box((double)0.0, (double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)11.0), Block.box((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0), Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)5.0, (double)11.0));
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        BlockState baseState = super.getStateForPlacement(ctx);
        boolean northConnected = ctx.getLevel().getBlockState(ctx.getClickedPos().north()).getBlock() == this;
        boolean eastConnected = ctx.getLevel().getBlockState(ctx.getClickedPos().east()).getBlock() == this;
        boolean southConnected = ctx.getLevel().getBlockState(ctx.getClickedPos().south()).getBlock() == this;
        boolean westConnected = ctx.getLevel().getBlockState(ctx.getClickedPos().west()).getBlock() == this;
        boolean upConnected = ctx.getLevel().getBlockState(ctx.getClickedPos().above()).is(TagContent.MACHINE_FRAME_SUPPORT);
        boolean downConnected = ctx.getLevel().getBlockState(ctx.getClickedPos().below()).is(TagContent.MACHINE_FRAME_SUPPORT);
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)Objects.requireNonNull(baseState).setValue((Property)NORTH, (Comparable)Boolean.valueOf(northConnected))).setValue((Property)EAST, (Comparable)Boolean.valueOf(eastConnected))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(southConnected))).setValue((Property)WEST, (Comparable)Boolean.valueOf(westConnected))).setValue((Property)UP, (Comparable)Boolean.valueOf(upConnected))).setValue((Property)DOWN, (Comparable)Boolean.valueOf(downConnected));
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        boolean northConnected = world.getBlockState(pos.north()).getBlock() == this;
        boolean eastConnected = world.getBlockState(pos.east()).getBlock() == this;
        boolean southConnected = world.getBlockState(pos.south()).getBlock() == this;
        boolean westConnected = world.getBlockState(pos.west()).getBlock() == this;
        boolean upConnected = world.getBlockState(pos.above()).is(TagContent.MACHINE_FRAME_SUPPORT);
        boolean downConnected = world.getBlockState(pos.below()).is(TagContent.MACHINE_FRAME_SUPPORT);
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)NORTH, (Comparable)Boolean.valueOf(northConnected))).setValue((Property)EAST, (Comparable)Boolean.valueOf(eastConnected))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(southConnected))).setValue((Property)WEST, (Comparable)Boolean.valueOf(westConnected))).setValue((Property)UP, (Comparable)Boolean.valueOf(upConnected))).setValue((Property)DOWN, (Comparable)Boolean.valueOf(downConnected));
    }
}

