/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.blocks.pipes;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.block.blocks.pipes.AbstractPipeBlock;
import rearth.oritech.block.blocks.pipes.GenericPipeBlock;
import rearth.oritech.block.entity.pipes.GenericPipeInterfaceEntity;

public abstract class GenericPipeConnectionBlock
extends GenericPipeBlock
implements EntityBlock {
    public GenericPipeConnectionBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    @Override
    public void onPlace(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean notify) {
        if (oldState.getBlock().equals(state.getBlock())) {
            return;
        }
        GenericPipeInterfaceEntity.addNode(world, pos, true, state, this.getNetworkData(world));
        ResourceLocation regKey = world.dimension().location();
        String dataId = this.getPipeTypeName() + "_" + regKey.getNamespace() + "_" + regKey.getPath();
        Oritech.LOGGER.debug("saving for: " + dataId);
        ((ServerLevel)world).getDataStorage().set(dataId, (SavedData)this.getNetworkData(world));
    }

    @Override
    protected void onBlockRemoved(BlockPos pos, BlockState oldState, Level world) {
        this.updateNeighbors(world, pos, false);
        GenericPipeInterfaceEntity.removeNode(world, pos, true, oldState, this.getNetworkData(world));
    }

    @Override
    @NotNull
    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        Level worldImp = (Level)world;
        if (worldImp.isClientSide) {
            return state;
        }
        if (((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            world.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
        }
        if (!this.hasNeighboringMachine(state, worldImp, pos, false)) {
            GenericPipeInterfaceEntity.removeStaleMachinePipeNeighbors(pos, this.getNetworkData(worldImp));
            BlockState normalState = this.getNormalBlock();
            return ((GenericPipeBlock)normalState.getBlock()).addConnectionStates(normalState, worldImp, pos, false);
        }
        BlockState interfaceState = state;
        if (!(neighborState.getBlock() instanceof AbstractPipeBlock)) {
            boolean hasMachine = ((Set)this.getNetworkData((Level)worldImp).machinePipeNeighbors.getOrDefault(neighborPos, HashSet.newHashSet(0))).contains(direction.getOpposite());
            if (neighborState.is(Blocks.AIR) || !hasMachine) {
                interfaceState = this.addConnectionStates(state, worldImp, pos, direction);
            }
            if (!interfaceState.equals(state)) {
                GenericPipeInterfaceEntity.addNode(worldImp, pos, true, interfaceState, this.getNetworkData(worldImp));
            }
        }
        return interfaceState;
    }

    @Override
    protected boolean toggleSideConnection(BlockState state, Direction side, Level world, BlockPos pos) {
        IntegerProperty property = this.directionToProperty(side);
        boolean createConnection = (Integer)state.getValue((Property)property) == NO_CONNECTION;
        BlockPos targetPos = pos.relative(side);
        if (createConnection && !this.isValidConnectionTarget(world.getBlockState(targetPos).getBlock(), world, side.getOpposite(), targetPos)) {
            return false;
        }
        int nextConnectionState = this.getNextConnectionState(state, side, world, pos, (Integer)state.getValue((Property)property));
        BlockState newState = this.addStraightState((BlockState)state.setValue((Property)property, (Comparable)Integer.valueOf(nextConnectionState)));
        if (!this.hasNeighboringMachine(newState, world, pos, false)) {
            GenericPipeBlock normalBlock = (GenericPipeBlock)this.getNormalBlock().getBlock();
            BlockState interfaceState = normalBlock.addConnectionStates(normalBlock.defaultBlockState(), world, pos, false);
            interfaceState = (BlockState)interfaceState.setValue((Property)normalBlock.directionToProperty(side), (Comparable)((Integer)newState.getValue((Property)property)));
            world.setBlockAndUpdate(pos, normalBlock.addStraightState(interfaceState));
        } else {
            world.setBlockAndUpdate(pos, newState);
            GenericPipeInterfaceEntity.addNode(world, pos, true, newState, this.getNetworkData(world));
            this.updateNeighbors(world, pos, true);
        }
        SoundType soundGroup = this.getSoundType(state);
        world.playSound(null, pos, soundGroup.getPlaceSound(), SoundSource.BLOCKS, soundGroup.getVolume() * 0.5f, soundGroup.getPitch());
        return true;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> type) {
        return (world1, pos, state1, blockEntity) -> {
            if (blockEntity instanceof BlockEntityTicker) {
                BlockEntityTicker ticker = (BlockEntityTicker)blockEntity;
                ticker.tick(world1, pos, state1, blockEntity);
            }
        };
    }

    public ItemStack getCloneItemStack(LevelReader world, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)this.getNormalBlock().getBlock());
    }
}

