/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.accelerator;

import dev.architectury.registry.menu.ExtendedMenuProvider;
import io.wispforest.owo.util.VectorRandomUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Position;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Portal;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.api.energy.EnergyApi;
import rearth.oritech.api.item.ItemApi;
import rearth.oritech.api.item.containers.InOutInventoryStorage;
import rearth.oritech.api.networking.NetworkManager;
import rearth.oritech.block.entity.accelerator.AcceleratorMotorBlockEntity;
import rearth.oritech.block.entity.accelerator.AcceleratorParticleLogic;
import rearth.oritech.block.entity.accelerator.BlackHoleBlockEntity;
import rearth.oritech.block.entity.accelerator.ParticleCollectorBlockEntity;
import rearth.oritech.client.init.ModScreens;
import rearth.oritech.client.init.ParticleContent;
import rearth.oritech.client.ui.AcceleratorScreenHandler;
import rearth.oritech.init.BlockContent;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.init.SoundContent;
import rearth.oritech.init.recipes.OritechRecipe;
import rearth.oritech.init.recipes.RecipeContent;
import rearth.oritech.util.Geometry;
import rearth.oritech.util.InventoryInputMode;
import rearth.oritech.util.InventorySlotAssignment;
import rearth.oritech.util.ScreenProvider;
import rearth.oritech.util.SimpleCraftingInventory;

public class AcceleratorControllerBlockEntity
extends BlockEntity
implements BlockEntityTicker<AcceleratorControllerBlockEntity>,
ItemApi.BlockProvider,
ExtendedMenuProvider,
ScreenProvider {
    private AcceleratorParticleLogic.ActiveParticle particle;
    private AcceleratorParticleLogic.ActiveParticle lastParticle;
    public ItemStack activeItemParticle = ItemStack.EMPTY;
    private AcceleratorParticleLogic particleLogic;
    public final InOutInventoryStorage inventory = new InOutInventoryStorage(2, () -> ((AcceleratorControllerBlockEntity)this).setChanged(), new InventorySlotAssignment(0, 1, 1, 1));
    public List<Vec3> displayTrail;
    public LastEventPacket lastEvent = new LastEventPacket(this.worldPosition, ParticleEvent.IDLE, 0.0f, this.worldPosition, 1.0f, ItemStack.EMPTY);

    public AcceleratorControllerBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntitiesContent.ACCELERATOR_CONTROLLER_BLOCK_ENTITY, pos, state);
    }

    public void tick(Level world, BlockPos pos, BlockState state, AcceleratorControllerBlockEntity blockEntity) {
        if (world.isClientSide) {
            return;
        }
        this.initParticleLogic();
        if (this.particle == null && !this.inventory.getItem(0).isEmpty() && this.inventory.getItem(1).isEmpty()) {
            this.injectParticle();
        }
        if (this.particle != null) {
            this.particleLogic.update(this.particle);
        }
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        ContainerHelper.saveAllItems((CompoundTag)nbt, (NonNullList)this.inventory.heldStacks, (boolean)false, (HolderLookup.Provider)registryLookup);
        if (this.particle != null && this.activeItemParticle != null && this.activeItemParticle != ItemStack.EMPTY) {
            CompoundTag data = new CompoundTag();
            data.putFloat("speed", this.particle.velocity);
            data.putFloat("posX", (float)this.particle.position.x);
            data.putFloat("posY", (float)this.particle.position.y);
            data.putFloat("posZ", (float)this.particle.position.z);
            data.putLong("lastGate", this.particle.lastGate.asLong());
            data.putLong("nextGate", this.particle.nextGate.asLong());
            data.put("item", this.activeItemParticle.save(registryLookup));
            nbt.put("particle", (Tag)data);
        } else {
            nbt.remove("particle");
        }
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        ContainerHelper.loadAllItems((CompoundTag)nbt, (NonNullList)this.inventory.heldStacks, (HolderLookup.Provider)registryLookup);
        if (nbt.contains("particle")) {
            CompoundTag data = nbt.getCompound("particle");
            float speed = data.getFloat("speed");
            float posX = data.getFloat("posX");
            float posY = data.getFloat("posY");
            float posZ = data.getFloat("posZ");
            BlockPos lastGate = BlockPos.of((long)data.getLong("lastGate"));
            BlockPos nextGate = BlockPos.of((long)data.getLong("nextGate"));
            Optional item = ItemStack.parse((HolderLookup.Provider)registryLookup, (Tag)data.get("item"));
            item.ifPresent(stack -> {
                this.activeItemParticle = stack;
            });
            this.particle = new AcceleratorParticleLogic.ActiveParticle(new Vec3((double)posX, (double)posY, (double)posZ), speed, lastGate, nextGate);
        }
    }

    private void initParticleLogic() {
        if (this.particleLogic == null) {
            this.particleLogic = new AcceleratorParticleLogic(this.worldPosition, (ServerLevel)this.level, this);
        }
    }

    public void injectParticle() {
        Direction facing = (Direction)this.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        Vec3i posBehind = Geometry.offsetToWorldPosition(facing, new Vec3i(1, 0, 0), (Vec3i)this.worldPosition);
        Vec3i directionRight = Geometry.getRight(facing);
        BlockState candidateBlock = this.level.getBlockState(new BlockPos(posBehind));
        if (candidateBlock.getBlock().equals(BlockContent.ACCELERATOR_RING)) {
            BlockPos startPosition = (BlockPos)posBehind;
            BlockPos nextGate = this.particleLogic.findNextGate(startPosition, directionRight, 1.0f);
            this.particle = new AcceleratorParticleLogic.ActiveParticle(startPosition.getCenter(), 1.0f, nextGate, startPosition);
            this.activeItemParticle = this.inventory.getItem(0).split(1);
            Vec3 soundPos = this.worldPosition.getCenter();
            this.level.playSound(null, soundPos.x, soundPos.y, soundPos.z, SoundEvents.BAMBOO_WOOD_TRAPDOOR_OPEN, SoundSource.BLOCKS);
        }
    }

    public void removeParticleDueToCollision() {
        this.particle = null;
        this.activeItemParticle = ItemStack.EMPTY;
    }

    public void onParticleExited(Vec3 from, Vec3 to, BlockPos lastGate, Vec3 exitDirection, ParticleEvent reason) {
        BlockPos eventPosition = BlockPos.containing((Position)this.particle.position);
        NetworkManager.sendBlockHandle(this, new LastEventPacket(this.worldPosition, reason, this.particle.velocity, eventPosition, AcceleratorParticleLogic.getParticleBendDist(this.particle.lastBendDistance, this.particle.lastBendDistance2), this.activeItemParticle));
        this.lastParticle = this.particle;
        this.particle = null;
        List<Vec3> renderedTrail = List.of(from, to);
        NetworkManager.sendBlockHandle(this, new ParticleRenderTrail(this.worldPosition, renderedTrail));
        this.setChanged();
    }

    public void onParticleCollided(float relativeSpeed, Vec3 collision, AcceleratorControllerBlockEntity secondControllerEntity) {
        if (relativeSpeed > (float)Oritech.CONFIG.endPortalRequiredSpeed() && this.activeItemParticle.getItem().equals(Items.ENDER_PEARL) && secondControllerEntity.activeItemParticle.getItem().equals(Items.ENDER_PEARL)) {
            this.spawnEndPortal(BlockPos.containing((Position)collision));
        } else if (relativeSpeed > (float)Oritech.CONFIG.netherPortalRequiredSpeed() && this.activeItemParticle.getItem().equals(Items.FIRE_CHARGE) && secondControllerEntity.activeItemParticle.getItem().equals(Items.FIRE_CHARGE)) {
            this.spawnNetherPortal(BlockPos.containing((Position)collision));
        } else {
            boolean bl = this.tryCraftResult(relativeSpeed, this.activeItemParticle, secondControllerEntity.activeItemParticle);
        }
        NetworkManager.sendBlockHandle(this, new LastEventPacket(this.worldPosition, ParticleEvent.COLLIDED, relativeSpeed, BlockPos.containing((Position)collision), AcceleratorParticleLogic.getParticleBendDist(this.particle.lastBendDistance, this.particle.lastBendDistance2), this.activeItemParticle));
        NetworkManager.sendBlockHandle(this, new LastEventPacket(secondControllerEntity.getBlockPos(), ParticleEvent.COLLIDED, relativeSpeed, BlockPos.containing((Position)collision), AcceleratorParticleLogic.getParticleBendDist(this.particle.lastBendDistance, this.particle.lastBendDistance2), this.activeItemParticle));
        this.removeParticleDueToCollision();
        secondControllerEntity.removeParticleDueToCollision();
        double particleCount = Math.pow(relativeSpeed, 0.5) / 2.0 + 1.0;
        this.createCollisionParticles((int)relativeSpeed, collision, (int)particleCount);
        ParticleContent.PARTICLE_COLLIDE.spawn(this.level, collision);
        this.setChanged();
    }

    private void createCollisionParticles(int collisionEnergy, Vec3 collisionPosition, int shotCount) {
        float energyMultiplier = 4.0f * Oritech.CONFIG.tachyonCollisionEnergyFactor();
        int energyPotential = (int)(Math.pow((float)collisionEnergy / 2.0f, 2.0) * (double)energyMultiplier * (double)Oritech.CONFIG.accelerationRFCost());
        int energyPerRay = energyPotential / shotCount;
        int rayRange = shotCount / 3;
        int caughtParticles = 0;
        for (int i = 0; i < shotCount; ++i) {
            Vec3 offset = VectorRandomUtils.getRandomOffset((Level)this.level, (Vec3)collisionPosition, (double)rayRange);
            Vec3 direction = offset.subtract(collisionPosition).normalize();
            BlockPos impactPos = BlackHoleBlockEntity.basicRaycast(collisionPosition.add(direction.scale(1.2)), direction, rayRange, this.level);
            if (impactPos != null) {
                ParticleContent.BLACK_HOLE_EMISSION.spawn(this.level, collisionPosition, (Object)impactPos.getCenter());
                BlockEntity candidate = this.level.getBlockEntity(impactPos);
                if (!(candidate instanceof ParticleCollectorBlockEntity)) continue;
                ParticleCollectorBlockEntity collectorEntity = (ParticleCollectorBlockEntity)candidate;
                collectorEntity.onParticleCollided(energyPerRay);
                ++caughtParticles;
                continue;
            }
            ParticleContent.BLACK_HOLE_EMISSION.spawn(this.level, collisionPosition, (Object)offset);
        }
    }

    private boolean tryCraftResult(float speed, ItemStack inputA, ItemStack inputB) {
        if (inputA == null || inputA.isEmpty() || inputB == null || inputB.isEmpty()) {
            return false;
        }
        SimpleCraftingInventory inputInv = new SimpleCraftingInventory(inputA, inputB);
        Optional candidate = this.level.getRecipeManager().getRecipeFor((RecipeType)RecipeContent.PARTICLE_COLLISION, (RecipeInput)inputInv, this.level);
        if (candidate.isEmpty()) {
            inputInv = new SimpleCraftingInventory(inputB, inputA);
            candidate = this.level.getRecipeManager().getRecipeFor((RecipeType)RecipeContent.PARTICLE_COLLISION, (RecipeInput)inputInv, this.level);
        }
        if (candidate.isEmpty()) {
            return false;
        }
        OritechRecipe recipe = (OritechRecipe)((RecipeHolder)candidate.get()).value();
        int requiredSpeed = recipe.getTime();
        if (speed < (float)requiredSpeed) {
            return false;
        }
        List<ItemStack> result = recipe.getResults();
        if (((ItemStack)this.inventory.heldStacks.get(1)).getItem().equals(result.get(0).getItem())) {
            ((ItemStack)this.inventory.heldStacks.get(1)).grow(1);
        } else {
            this.inventory.setItem(1, result.get(0).copy());
        }
        return true;
    }

    private void spawnEndPortal(BlockPos pos) {
        for (BlockPos candidate : BlockPos.withinManhattan((BlockPos)pos, (int)8, (int)4, (int)8)) {
            BlockState stateAbove;
            BlockState candidateState;
            double dist = candidate.getCenter().distanceTo(pos.getCenter());
            if ((double)this.level.random.nextFloat() < dist / 8.0 || (candidateState = this.level.getBlockState(candidate)).isAir() || candidateState.canBeReplaced() || candidateState.getBlock().defaultDestroyTime() < 0.0f) continue;
            if (!this.level.getBlockState(candidate.below()).getBlock().equals(Blocks.CHORUS_PLANT)) {
                this.level.setBlockAndUpdate(candidate, Blocks.END_STONE.defaultBlockState());
            }
            if (!((double)this.level.random.nextFloat() > 0.8) || !(stateAbove = this.level.getBlockState(candidate.above())).isAir() && !stateAbove.canBeReplaced()) continue;
            for (int i = 1; i < this.level.random.nextIntBetweenInclusive(3, 6); ++i) {
                stateAbove = this.level.getBlockState(candidate.above(i));
                if (!stateAbove.isAir() && !stateAbove.canBeReplaced()) continue;
                this.level.setBlockAndUpdate(candidate.above(i), Blocks.CHORUS_PLANT.defaultBlockState());
            }
        }
        this.level.setBlockAndUpdate(pos, Blocks.END_PORTAL.defaultBlockState());
        this.level.setBlockAndUpdate(pos.north(), Blocks.END_STONE.defaultBlockState());
        this.level.setBlockAndUpdate(pos.east(), Blocks.END_STONE.defaultBlockState());
        this.level.setBlockAndUpdate(pos.south(), Blocks.END_STONE.defaultBlockState());
        this.level.setBlockAndUpdate(pos.west(), Blocks.END_STONE.defaultBlockState());
    }

    private void spawnNetherPortal(BlockPos pos) {
        for (BlockPos candidate : BlockPos.withinManhattan((BlockPos)pos, (int)12, (int)4, (int)12)) {
            BlockState stateAbove;
            BlockState candidateState;
            double dist = candidate.getCenter().distanceTo(pos.getCenter());
            if ((double)this.level.random.nextFloat() < dist / 12.0 || (candidateState = this.level.getBlockState(candidate)).isAir() || candidateState.canBeReplaced() || candidateState.getBlock().defaultDestroyTime() < 0.0f) continue;
            this.level.setBlockAndUpdate(candidate, Blocks.NETHERRACK.defaultBlockState());
            if (!((double)this.level.random.nextFloat() > 0.8) || !(stateAbove = this.level.getBlockState(candidate.above())).isAir() && !stateAbove.canBeReplaced()) continue;
            this.level.setBlockAndUpdate(candidate.above(), Blocks.FIRE.defaultBlockState());
        }
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 4; ++y) {
                this.level.setBlockAndUpdate(pos.offset(x, y, 0), Blocks.OBSIDIAN.defaultBlockState());
            }
        }
        this.level.setBlockAndUpdate(pos.offset(1, 1, 0), Blocks.NETHER_PORTAL.defaultBlockState());
        this.level.setBlockAndUpdate(pos.offset(1, 2, 0), Blocks.NETHER_PORTAL.defaultBlockState());
    }

    public void onParticleMoved(List<Vec3> positions) {
        if (positions.size() <= 1) {
            return;
        }
        ArrayList<Vec3> resultList = new ArrayList<Vec3>();
        HashSet<Vec3> positionSet = new HashSet<Vec3>();
        for (Vec3 position : positions) {
            if (positionSet.contains(position)) break;
            positionSet.add(position);
            resultList.add(position);
        }
        NetworkManager.sendBlockHandle(this, new ParticleRenderTrail(this.worldPosition, resultList));
        NetworkManager.sendBlockHandle(this, new LastEventPacket(this.worldPosition, ParticleEvent.ACCELERATING, this.particle.velocity, BlockPos.containing((Position)this.particle.position), AcceleratorParticleLogic.getParticleBendDist(this.particle.lastBendDistance, this.particle.lastBendDistance2), this.activeItemParticle));
    }

    public AcceleratorParticleLogic.ActiveParticle getParticle() {
        if (this.particle == null && this.lastParticle != null) {
            return this.lastParticle;
        }
        return this.particle;
    }

    public float handleParticleEntityCollision(BlockPos checkPos, AcceleratorParticleLogic.ActiveParticle particle, float remainingMomentum, LivingEntity mob) {
        float maxApplicableDamage = mob.getHealth();
        float inflictedDamage = Math.min(remainingMomentum, maxApplicableDamage);
        mob.hurt(this.level.damageSources().magic(), remainingMomentum);
        Vec3 position = mob.getBoundingBox().getCenter();
        position = new Vec3(position.x, particle.position.y, position.z);
        ParticleContent.BIG_HIT.spawn(this.level, position);
        return inflictedDamage;
    }

    public float handleParticleBlockCollision(BlockPos checkPos, AcceleratorParticleLogic.ActiveParticle particle, float remainingMomentum, BlockState hitState) {
        float blockHardness = hitState.getDestroySpeed((BlockGetter)this.level, checkPos);
        if (remainingMomentum > (float)Oritech.CONFIG.blackHoleRequiredSpeed() && hitState.getBlock() instanceof Portal) {
            this.createBlackHole(checkPos);
            return remainingMomentum;
        }
        if (blockHardness < 0.0f) {
            return remainingMomentum;
        }
        if (remainingMomentum > blockHardness) {
            this.level.addDestroyBlockEffect(checkPos, hitState);
            this.level.playSound(null, checkPos, hitState.getSoundType().getBreakSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
            this.level.destroyBlock(checkPos, true);
        }
        return blockHardness;
    }

    private void createBlackHole(BlockPos checkPos) {
        ParticleContent.MELTDOWN_IMMINENT.spawn(this.level, checkPos.getCenter(), (Object)30);
        Vec3 center = checkPos.getCenter();
        this.level.explode(null, center.x, center.y, center.z, 10.0f, false, Level.ExplosionInteraction.BLOCK);
        this.level.removeBlock(checkPos, false);
        this.level.setBlockAndUpdate(checkPos, BlockContent.BLACK_HOLE_BLOCK.defaultBlockState());
    }

    public void handleParticleMotorInteraction(BlockPos motorBlock) {
        BlockEntity entity = this.level.getBlockEntity(motorBlock);
        if (!(entity instanceof AcceleratorMotorBlockEntity)) {
            return;
        }
        AcceleratorMotorBlockEntity motorEntity = (AcceleratorMotorBlockEntity)entity;
        EnergyApi.EnergyStorage storage = motorEntity.getEnergyStorage(null);
        long availableEnergy = storage.getAmount();
        float speed = this.particle.velocity;
        float cost = speed * (float)Oritech.CONFIG.accelerationRFCost();
        if ((float)availableEnergy < cost) {
            return;
        }
        storage.extract((long)cost, false);
        storage.update();
        this.particle.velocity += 1.0f;
    }

    @Override
    public ItemApi.InventoryStorage getInventoryStorage(Direction direction) {
        return this.inventory;
    }

    public void saveExtraData(FriendlyByteBuf buf) {
        buf.writeBlockPos(this.worldPosition);
    }

    public Component getDisplayName() {
        return Component.literal((String)"");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int syncId, Inventory playerInventory, Player player) {
        return new AcceleratorScreenHandler(syncId, playerInventory, this);
    }

    @Override
    public List<ScreenProvider.GuiSlot> getGuiSlots() {
        return List.of(new ScreenProvider.GuiSlot(0, 7, 10), new ScreenProvider.GuiSlot(1, 7, 60, true));
    }

    @Override
    public boolean showEnergy() {
        return false;
    }

    @Override
    public float getDisplayedEnergyUsage() {
        return 0.0f;
    }

    @Override
    public float getProgress() {
        return 0.0f;
    }

    @Override
    public InventoryInputMode getInventoryInputMode() {
        return InventoryInputMode.FILL_LEFT_TO_RIGHT;
    }

    @Override
    public Container getDisplayedInventory() {
        return this.inventory;
    }

    @Override
    public MenuType<?> getScreenHandlerType() {
        return ModScreens.ACCELERATOR_SCREEN;
    }

    @Override
    public boolean inputOptionsEnabled() {
        return false;
    }

    @Override
    public boolean showProgress() {
        return false;
    }

    public static void receiveTrail(ParticleRenderTrail packet, Level world, RegistryAccess dynamicRegistryManager) {
        BlockEntity blockEntity = world.getBlockEntity(packet.position);
        if (blockEntity instanceof AcceleratorControllerBlockEntity) {
            AcceleratorControllerBlockEntity acceleratorBlock = (AcceleratorControllerBlockEntity)blockEntity;
            List<Vec3> displayTrail = packet.particleTrail;
            acceleratorBlock.displayTrail = displayTrail;
            if (displayTrail.size() < 2) {
                return;
            }
            Vec3 playerPos = Minecraft.getInstance().player.position();
            double minDist = Double.MAX_VALUE;
            Vec3 soundPos = displayTrail.getFirst();
            for (Vec3 candidate : displayTrail) {
                double dist = candidate.distanceTo(playerPos);
                if (!(dist < minDist)) continue;
                minDist = dist;
                soundPos = candidate;
            }
            double pitch = Math.pow(acceleratorBlock.lastEvent.lastEventSpeed, 0.1);
            world.playLocalSound(soundPos.x, soundPos.y, soundPos.z, SoundContent.PARTICLE_MOVING, SoundSource.BLOCKS, 2.0f, (float)pitch, true);
        }
    }

    public static void receiveEvent(LastEventPacket packet, Level world, RegistryAccess dynamicRegistryManager) {
        BlockEntity blockEntity = world.getBlockEntity(packet.position);
        if (blockEntity instanceof AcceleratorControllerBlockEntity) {
            AcceleratorControllerBlockEntity acceleratorBlock = (AcceleratorControllerBlockEntity)blockEntity;
            acceleratorBlock.lastEvent = packet;
            Vec3 soundPos = packet.lastEventPosition.getCenter();
            if (packet.lastEvent.equals((Object)ParticleEvent.COLLIDED)) {
                world.playLocalSound(soundPos.x, soundPos.y, soundPos.z, SoundEvents.WARDEN_SONIC_BOOM, SoundSource.BLOCKS, 5.0f, 1.0f, true);
            } else if (packet.lastEvent.equals((Object)ParticleEvent.EXITED_FAST) || packet.lastEvent.equals((Object)ParticleEvent.EXITED_NO_GATE)) {
                world.playLocalSound(soundPos.x, soundPos.y, soundPos.z, (SoundEvent)SoundEvents.WIND_CHARGE_BURST.value(), SoundSource.BLOCKS, 3.0f, 1.0f, true);
            }
        }
    }

    public record LastEventPacket(BlockPos position, ParticleEvent lastEvent, float lastEventSpeed, BlockPos lastEventPosition, float minBendDist, ItemStack activeParticle) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<LastEventPacket> PACKET_ID = new CustomPacketPayload.Type(Oritech.id("accel_event"));

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return PACKET_ID;
        }
    }

    public static enum ParticleEvent {
        IDLE,
        ERROR,
        ACCELERATING,
        COLLIDED,
        EXITED_FAST,
        EXITED_NO_GATE;

    }

    public record ParticleRenderTrail(BlockPos position, List<Vec3> particleTrail) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<ParticleRenderTrail> PACKET_ID = new CustomPacketPayload.Type(Oritech.id("accel_render"));

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return PACKET_ID;
        }
    }
}

