/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.accelerator;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.api.energy.EnergyApi;
import rearth.oritech.api.energy.containers.DynamicEnergyStorage;
import rearth.oritech.block.base.entity.ExpandableEnergyStorageBlockEntity;
import rearth.oritech.init.BlockEntitiesContent;

public class ParticleCollectorBlockEntity
extends BlockEntity
implements BlockEntityTicker<ParticleCollectorBlockEntity>,
EnergyApi.BlockProvider {
    protected final DynamicEnergyStorage energyStorage = new DynamicEnergyStorage((long)Oritech.CONFIG.collectorEnergyStorage(), 0L, (long)Oritech.CONFIG.collectorEnergyStorage(), () -> ((ParticleCollectorBlockEntity)this).setChanged());

    public ParticleCollectorBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntitiesContent.PARTICLE_COLLECTOR_BLOCK_ENTITY, pos, state);
    }

    @Override
    public EnergyApi.EnergyStorage getEnergyStorage(@Nullable Direction direction) {
        return this.energyStorage;
    }

    public void onParticleCollided() {
        this.onParticleCollided(Oritech.CONFIG.blackHoleTachyonEnergy());
    }

    public void onParticleCollided(int amount) {
        this.energyStorage.amount = Math.min(this.energyStorage.capacity, this.energyStorage.amount + (long)amount);
        this.energyStorage.update();
        this.triggerAnimation();
    }

    public void tick(Level world, BlockPos pos, BlockState state, ParticleCollectorBlockEntity blockEntity) {
        if (world.isClientSide) {
            return;
        }
        if (this.energyStorage.amount <= 0L) {
            return;
        }
        Tuple<Direction, BlockPos> target = ExpandableEnergyStorageBlockEntity.getOutputPosition(pos, ((Direction)this.getBlockState().getValue((Property)DirectionalBlock.FACING)).getOpposite());
        EnergyApi.EnergyStorage candidate = EnergyApi.BLOCK.find(world, (BlockPos)target.getB(), (Direction)target.getA());
        if (candidate != null) {
            EnergyApi.transfer(this.energyStorage, candidate, Long.MAX_VALUE, false);
        }
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        nbt.putLong("energy", this.energyStorage.getAmount());
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        this.energyStorage.setAmount(nbt.getLong("energy"));
    }

    public void triggerAnimation() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Vec3i forward = ((Direction)this.getBlockState().getValue((Property)DirectionalBlock.FACING)).getNormal();
            Vec3 at = this.worldPosition.getCenter().add(Vec3.atCenterOf((Vec3i)forward));
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.SWEEP_ATTACK, at.x, at.y, at.z, 2, (double)this.level.random.nextFloat(), (double)this.level.random.nextFloat(), (double)this.level.random.nextFloat(), (double)0.15f);
        }
    }
}

