/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.interaction;

import dev.architectury.registry.menu.ExtendedMenuProvider;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.api.energy.EnergyApi;
import rearth.oritech.api.energy.containers.DynamicEnergyStorage;
import rearth.oritech.api.item.ItemApi;
import rearth.oritech.api.item.containers.SimpleInventoryStorage;
import rearth.oritech.api.networking.NetworkedBlockEntity;
import rearth.oritech.api.networking.SyncField;
import rearth.oritech.api.networking.SyncType;
import rearth.oritech.block.base.entity.MachineBlockEntity;
import rearth.oritech.client.init.ModScreens;
import rearth.oritech.client.ui.BasicMachineScreenHandler;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.init.TagContent;
import rearth.oritech.util.AutoPlayingSoundKeyframeHandler;
import rearth.oritech.util.ColorableMachine;
import rearth.oritech.util.Geometry;
import rearth.oritech.util.InventoryInputMode;
import rearth.oritech.util.ScreenProvider;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class TreefellerBlockEntity
extends NetworkedBlockEntity
implements BlockEntityTicker<NetworkedBlockEntity>,
GeoBlockEntity,
EnergyApi.BlockProvider,
ColorableMachine,
ItemApi.BlockProvider,
ExtendedMenuProvider,
ScreenProvider {
    private static final int LOG_COST = 100;
    private static final int LEAF_COST = 10;
    private final Deque<BlockPos> pendingBlocks = new ArrayDeque<BlockPos>();
    protected final AnimatableInstanceCache animatableInstanceCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private long lastWorkedAt = 0L;
    @SyncField(value={SyncType.GUI_TICK, SyncType.GUI_OPEN})
    protected final DynamicEnergyStorage energyStorage = new DynamicEnergyStorage(50000L, 4000L, 0L, this::setChanged);
    public final SimpleInventoryStorage inventory = new SimpleInventoryStorage(this, 6, this::setChanged){

        @Override
        public boolean supportsInsertion() {
            return false;
        }
    };
    @SyncField(value={SyncType.SPARSE_TICK, SyncType.INITIAL})
    public ColorableMachine.ColorVariant currentColor = this.getDefaultColor();

    public TreefellerBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntitiesContent.TREEFELLER_BLOCK_ENTITY, pos, state);
    }

    @Override
    public void serverTick(Level world, BlockPos pos, BlockState state, NetworkedBlockEntity blockEntity) {
        if (this.energyStorage.amount >= 100L) {
            if (this.pendingBlocks.isEmpty() && world.getGameTime() % 20L == 0L) {
                this.findTarget();
            }
            for (int i = 0; i < 6 && !this.pendingBlocks.isEmpty(); ++i) {
                InteractionResult actionResult;
                int energyCost;
                BlockPos candidate = this.pendingBlocks.peekLast();
                BlockState candidateState = world.getBlockState(candidate);
                boolean isLog = candidateState.is(TagContent.CUTTER_LOGS_MINEABLE);
                int n = energyCost = isLog ? 100 : 10;
                if ((long)energyCost > this.energyStorage.amount || (actionResult = this.breakTreeBlock(candidateState, candidate)) == InteractionResult.FAIL) break;
                this.pendingBlocks.pollLast();
                if (actionResult == InteractionResult.PASS) continue;
                this.lastWorkedAt = world.getGameTime();
                this.energyStorage.amount -= (long)energyCost;
                this.setChanged();
                if (isLog) break;
            }
        }
        if (world.getGameTime() % 10L == 0L) {
            long idleTicks = world.getGameTime() - this.lastWorkedAt;
            boolean isWorking = idleTicks < 20L;
            String animName = isWorking ? "work" : "idle";
            this.playWorkAnimation(animName);
        }
    }

    private InteractionResult breakTreeBlock(BlockState candidateState, BlockPos candidate) {
        if (!candidateState.is(TagContent.CUTTER_LOGS_MINEABLE) && !candidateState.is(TagContent.CUTTER_LEAVES_MINEABLE)) {
            return InteractionResult.PASS;
        }
        List dropped = Block.getDrops((BlockState)candidateState, (ServerLevel)((ServerLevel)this.level), (BlockPos)candidate, null);
        if (dropped.stream().anyMatch(itemStack -> !itemStack.isEmpty() && !this.canInsert((ItemStack)itemStack))) {
            return InteractionResult.FAIL;
        }
        this.level.addDestroyBlockEffect(candidate, candidateState);
        if (this.level.getGameTime() % 2L == 0L) {
            this.level.playSound(null, candidate, candidateState.getSoundType().getBreakSound(), SoundSource.BLOCKS, 0.5f, 1.0f);
        }
        this.level.setBlockAndUpdate(candidate, Blocks.AIR.defaultBlockState());
        dropped.forEach(stack -> this.inventory.insert((ItemStack)stack, false));
        return InteractionResult.SUCCESS;
    }

    private boolean canInsert(ItemStack stack) {
        return this.inventory.heldStacks.stream().anyMatch(itemStack -> itemStack.isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)itemStack, (ItemStack)stack) && itemStack.getCount() + stack.getCount() <= itemStack.getMaxStackSize());
    }

    public void findTarget() {
        BlockState state = this.getBlockState();
        Direction facing = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        Vec3i offset = Geometry.rotatePosition(new Vec3i(1, 0, 0), facing);
        BlockPos frontBlock = this.worldPosition.offset(offset);
        Deque<BlockPos> res = TreefellerBlockEntity.getTreeBlocks(frontBlock, this.level);
        this.pendingBlocks.addAll(res);
    }

    public static Deque<BlockPos> getTreeBlocks(BlockPos startPos, Level world) {
        BlockState startState = world.getBlockState(startPos);
        if (!startState.is(TagContent.CUTTER_LOGS_MINEABLE)) {
            return new ArrayDeque<BlockPos>();
        }
        HashSet<BlockPos> checkedPositions = new HashSet<BlockPos>();
        ArrayDeque<BlockPos> foundPositions = new ArrayDeque<BlockPos>();
        HashSet<BlockPos> foundLogs = new HashSet<BlockPos>();
        ArrayDeque<BlockPos> pendingPositions = new ArrayDeque<BlockPos>();
        checkedPositions.add(startPos);
        foundPositions.add(startPos);
        pendingPositions.addAll(TreefellerBlockEntity.getNeighbors(startPos));
        foundLogs.add(startPos);
        while (!pendingPositions.isEmpty() && checkedPositions.size() < 8000) {
            boolean isValidLeaf;
            BlockPos candidate = (BlockPos)pendingPositions.pollFirst();
            if (candidate.getY() < startPos.getY() || checkedPositions.contains(candidate)) continue;
            BlockState candidateState = world.getBlockState(candidate);
            checkedPositions.add(candidate);
            boolean isLog = candidateState.is(TagContent.CUTTER_LOGS_MINEABLE);
            boolean bl = isValidLeaf = candidateState.is(TagContent.CUTTER_LEAVES_MINEABLE) && candidateState.getOptionalValue((Property)BlockStateProperties.PERSISTENT).orElse(false) == false;
            if (!isLog && !isValidLeaf) continue;
            boolean isValid = false;
            if (isLog) {
                isValid = TreefellerBlockEntity.isInLogRange(candidate, foundLogs, 3);
            } else {
                Integer range = candidateState.getOptionalValue((Property)BlockStateProperties.DISTANCE).orElse(4);
                isValid = TreefellerBlockEntity.isInLogRange(candidate, foundLogs, range + 2);
            }
            if (!isValid) continue;
            if (isLog) {
                foundLogs.add(candidate);
            }
            foundPositions.add(candidate);
            pendingPositions.addAll(TreefellerBlockEntity.getNeighbors(candidate));
        }
        if (foundLogs.size() == foundPositions.size()) {
            return new ArrayDeque<BlockPos>();
        }
        return foundPositions;
    }

    private static boolean isInLogRange(BlockPos pos, Set<BlockPos> logs, int maxDist) {
        return logs.stream().anyMatch(elem -> elem.distManhattan((Vec3i)pos) <= maxDist);
    }

    private static List<BlockPos> getNeighbors(BlockPos input) {
        ArrayList<BlockPos> neighbors = new ArrayList<BlockPos>();
        for (BlockPos pos : BlockPos.withinManhattan((BlockPos)input, (int)1, (int)1, (int)1)) {
            neighbors.add(pos.immutable());
        }
        return neighbors;
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        ContainerHelper.saveAllItems((CompoundTag)nbt, this.inventory.heldStacks, (boolean)false, (HolderLookup.Provider)registryLookup);
        nbt.putLong("energy_stored", this.energyStorage.amount);
        this.addColorToNbt(nbt);
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        ContainerHelper.loadAllItems((CompoundTag)nbt, this.inventory.heldStacks, (HolderLookup.Provider)registryLookup);
        this.energyStorage.amount = nbt.getLong("energy_stored");
        this.loadColorFromNbt(nbt);
    }

    @Override
    public ColorableMachine.ColorVariant getCurrentColor() {
        return this.currentColor;
    }

    @Override
    public void assignColor(ColorableMachine.ColorVariant color) {
        this.currentColor = color;
        if (this.level != null && !this.level.isClientSide()) {
            this.setChanged(false);
            this.sendUpdate(SyncType.SPARSE_TICK);
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "machine", 5, state -> PlayState.CONTINUE).triggerableAnim("work", MachineBlockEntity.WORKING).triggerableAnim("idle", MachineBlockEntity.IDLE).setSoundKeyframeHandler(new AutoPlayingSoundKeyframeHandler()));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animatableInstanceCache;
    }

    @Override
    public EnergyApi.EnergyStorage getEnergyStorage(Direction direction) {
        return this.energyStorage;
    }

    @Override
    public ItemApi.InventoryStorage getInventoryStorage(Direction direction) {
        return this.inventory;
    }

    @Override
    public List<ScreenProvider.GuiSlot> getGuiSlots() {
        ArrayList<ScreenProvider.GuiSlot> list = new ArrayList<ScreenProvider.GuiSlot>();
        for (int i = 0; i < this.inventory.getContainerSize(); ++i) {
            list.add(new ScreenProvider.GuiSlot(i, 40 + i * 19, 25, true));
        }
        return list;
    }

    @Override
    public float getDisplayedEnergyUsage() {
        return 100.0f;
    }

    @Override
    public float getProgress() {
        return 0.0f;
    }

    @Override
    public InventoryInputMode getInventoryInputMode() {
        return InventoryInputMode.FILL_LEFT_TO_RIGHT;
    }

    @Override
    public boolean inputOptionsEnabled() {
        return false;
    }

    @Override
    public boolean showProgress() {
        return false;
    }

    @Override
    public Container getDisplayedInventory() {
        return this.inventory;
    }

    @Override
    public MenuType<?> getScreenHandlerType() {
        return ModScreens.TREEFELLER_SCREEN;
    }

    public Component getDisplayName() {
        return Component.nullToEmpty((String)"");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int syncId, Inventory playerInventory, Player player) {
        return new BasicMachineScreenHandler(syncId, playerInventory, this);
    }

    public void playWorkAnimation(String animName) {
        this.triggerAnim("machine", animName);
    }

    public void saveExtraData(FriendlyByteBuf buf) {
        this.sendUpdate(SyncType.GUI_OPEN);
        buf.writeBlockPos(this.worldPosition);
    }
}

