/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.client.renderers;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.util.HashMap;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.block.entity.interaction.LaserArmBlockEntity;
import rearth.oritech.client.init.ParticleContent;
import rearth.oritech.client.renderers.LaserArmModel;
import rearth.oritech.util.Geometry;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.renderer.GeoBlockRenderer;

public class LaserArmRenderer<T extends LaserArmBlockEntity>
extends GeoBlockRenderer<T> {
    public static final RenderType.CompositeRenderType CUSTOM_LINES = RenderType.create((String)"lines", (VertexFormat)DefaultVertexFormat.POSITION_COLOR_NORMAL, (VertexFormat.Mode)VertexFormat.Mode.LINES, (int)1536, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(RenderStateShard.RENDERTYPE_LINES_SHADER).setLayeringState(RenderStateShard.VIEW_OFFSET_Z_LAYERING).setTransparencyState(RenderStateShard.TRANSLUCENT_TRANSPARENCY).setOutputState(RenderStateShard.ITEM_ENTITY_TARGET).setWriteMaskState(RenderStateShard.COLOR_DEPTH_WRITE).setCullState(RenderStateShard.NO_CULL).createCompositeState(false));
    private static final HashMap<Long, Vec3> cachedOffsets = new HashMap();

    public LaserArmRenderer(String modelPath) {
        super(new LaserArmModel(modelPath));
    }

    public int getViewDistance() {
        return 128;
    }

    public boolean shouldRenderOffScreen(T blockEntity) {
        return true;
    }

    public void postRender(PoseStack matrices, T laserEntity, BakedGeoModel model, MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int colour) {
        super.postRender(matrices, (GeoAnimatable)((LaserArmBlockEntity)this.animatable), model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, colour);
        if (((LaserArmBlockEntity)laserEntity).getCurrentTarget() == null || !((LaserArmBlockEntity)laserEntity).isFiring()) {
            return;
        }
        Direction facing = (Direction)laserEntity.getBlockState().getValue((Property)BlockStateProperties.FACING);
        Vec3 startPos = ((LaserArmBlockEntity)laserEntity).laserHead;
        Vec3 startOffset = new Vec3(0.0, (double)1.65f, 0.0);
        Vec3 targetPos = ((LaserArmBlockEntity)laserEntity).getVisualTarget();
        Block targetBlock = laserEntity.getLevel().getBlockState(((LaserArmBlockEntity)laserEntity).getCurrentTarget()).getBlock();
        if (((LaserArmBlockEntity)laserEntity).isTargetingAtomicForge(targetBlock)) {
            double moveX = 0.5;
            double moveZ = 0.5;
            if (startPos.x < targetPos.x) {
                moveX = -0.5;
            }
            if (startPos.z < targetPos.z) {
                moveZ = -0.5;
            }
            targetPos = targetPos.add(moveX, 0.5, moveZ);
        } else if (((LaserArmBlockEntity)laserEntity).isTargetingDeepdrill(targetBlock)) {
            Vec3 offset = cachedOffsets.computeIfAbsent(laserEntity.getBlockPos().asLong(), id -> LaserArmRenderer.idToOffset(BlockPos.of((long)id), 0.5f, laserEntity.getLevel(), laserEntity.getCurrentTarget()));
            targetPos = targetPos.add(offset);
        }
        if (((LaserArmBlockEntity)laserEntity).lastRenderPosition == null) {
            ((LaserArmBlockEntity)laserEntity).lastRenderPosition = targetPos;
        }
        ((LaserArmBlockEntity)laserEntity).lastRenderPosition = targetPos = LaserArmRenderer.lerp(((LaserArmBlockEntity)laserEntity).lastRenderPosition, targetPos, 0.06f);
        Vec3 targetPosOffset = LaserArmRenderer.worldToOffsetPosition(facing, targetPos, startPos).add(startOffset);
        Vec3 forward = targetPos.subtract(startPos).normalize();
        if (!((LaserArmBlockEntity)laserEntity).isTargetingEnergyContainer() && !((LaserArmBlockEntity)laserEntity).isTargetingBuddingAmethyst() && (double)laserEntity.getLevel().random.nextFloat() > 0.7) {
            ParticleContent.LASER_BEAM_EFFECT.spawn(laserEntity.getLevel(), targetPos.add(0.5, 0.0, 0.5).subtract(forward.scale(0.6)));
        }
        Vec3 cross = forward.cross(new Vec3(0.0, 1.0, 0.0));
        matrices.pushPose();
        VertexConsumer lineConsumer = bufferSource.getBuffer((RenderType)CUSTOM_LINES);
        Vec3 camPos = Minecraft.getInstance().cameraEntity.position();
        double camDist = camPos.subtract(startPos).length();
        float widthMultiplier = 1.0f;
        if (camDist > 20.0) {
            widthMultiplier = (float)(camDist / 20.0);
        }
        RenderSystem.lineWidth((float)((float)(Math.sin((double)((float)laserEntity.getLevel().getGameTime() + partialTick) * 0.3) * 2.0 + 7.0) / widthMultiplier));
        lineConsumer.addVertex(matrices.last().pose(), (float)startOffset.x, (float)startOffset.y, (float)startOffset.z).setColor(138, 242, 223, 255).setLight(packedLight).setOverlay(packedOverlay).setNormal(0.0f, 1.0f, 0.0f);
        lineConsumer.addVertex(matrices.last().pose(), (float)targetPosOffset.x, (float)targetPosOffset.y, (float)targetPosOffset.z).setColor(19, 91, 80, 255).setLight(packedLight).setOverlay(packedOverlay).setNormal(1.0f, 0.0f, 0.0f);
        lineConsumer.addVertex(matrices.last().pose(), (float)startOffset.x, (float)startOffset.y, (float)startOffset.z).setColor(138, 242, 223, 255).setLight(packedLight).setOverlay(packedOverlay).setNormal((float)cross.x, (float)cross.y, (float)cross.z);
        lineConsumer.addVertex(matrices.last().pose(), (float)targetPosOffset.x, (float)targetPosOffset.y, (float)targetPosOffset.z).setColor(19, 91, 80, 255).setLight(packedLight).setOverlay(packedOverlay).setNormal((float)cross.x, (float)cross.y, (float)cross.z);
        matrices.popPose();
    }

    public static Vec3 idToOffset(BlockPos source, float range, Level world, BlockPos targetPos) {
        Direction drillFacing = (Direction)world.getBlockState(targetPos).getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        Vec3 drillCenter = Geometry.rotatePosition(new Vec3(1.0, 1.4, 0.0), drillFacing);
        RandomSource random = RandomSource.create((long)source.asLong());
        return new Vec3((double)((random.nextFloat() * 2.0f - 1.0f) * range), (double)((random.nextFloat() * 2.0f - 1.0f) * range), (double)((random.nextFloat() * 2.0f - 1.0f) * range)).add(drillCenter);
    }

    protected void rotateBlock(Direction facing, PoseStack poseStack) {
        if (Objects.requireNonNull(facing) == Direction.DOWN) {
            poseStack.translate(0.0f, 1.0f, 0.0f);
            poseStack.mulPose(Axis.XP.rotationDegrees(180.0f));
        } else if (facing == Direction.WEST) {
            poseStack.translate(0.5, 0.5, 0.0);
            poseStack.mulPose(Axis.ZP.rotationDegrees(90.0f));
        } else if (facing == Direction.EAST) {
            poseStack.translate(-0.5, 0.5, 0.0);
            poseStack.mulPose(Axis.ZP.rotationDegrees(270.0f));
        } else if (facing == Direction.SOUTH) {
            poseStack.translate(0.0, 0.5, -0.5);
            poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
        } else if (facing == Direction.NORTH) {
            poseStack.translate(0.0, 0.5, 0.5);
            poseStack.mulPose(Axis.XN.rotationDegrees(90.0f));
        }
    }

    public static Vec3 lerp(Vec3 a, Vec3 b, float f) {
        return new Vec3(LaserArmRenderer.lerp(a.x, b.x, (double)f), LaserArmRenderer.lerp(a.y, b.y, (double)f), LaserArmRenderer.lerp(a.z, b.z, (double)f));
    }

    public static double lerp(double a, double b, double f) {
        return a + f * (b - a);
    }

    private static Vec3 worldToOffsetPosition(Direction facing, Vec3 worldTarget, Vec3 ownPos) {
        Vec3 relativeWorld = worldTarget.subtract(ownPos);
        double relX = relativeWorld.x();
        double relY = relativeWorld.y();
        double relZ = relativeWorld.z();
        if (Objects.requireNonNull(facing) == Direction.NORTH) {
            return new Vec3(relX, -relZ, relY);
        }
        if (facing == Direction.SOUTH) {
            return new Vec3(relX, relZ, -relY);
        }
        if (facing == Direction.WEST) {
            return new Vec3(relY, -relX, relZ);
        }
        if (facing == Direction.EAST) {
            return new Vec3(-relY, relX, relZ);
        }
        if (facing == Direction.UP) {
            return new Vec3(relX, relY, relZ);
        }
        if (facing == Direction.DOWN) {
            return new Vec3(relX, -relY, -relZ);
        }
        throw new IllegalArgumentException();
    }
}

