/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.client.renderers;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import rearth.oritech.Oritech;
import rearth.oritech.util.ColorableMachine;
import software.bernie.geckolib.model.DefaultedBlockGeoModel;

public class MachineModel<T extends BlockEntity>
extends DefaultedBlockGeoModel<T> {
    public MachineModel(String subpath) {
        super(Oritech.id(subpath));
    }

    public ResourceLocation getTextureResource(T animatable) {
        ColorableMachine colorableMachine;
        if (animatable instanceof ColorableMachine && (colorableMachine = (ColorableMachine)animatable).supportRecoloring()) {
            ColorableMachine.ColorVariant color = colorableMachine.getCurrentColor();
            ResourceLocation base = super.getTextureResource(animatable);
            if (color.equals((Object)ColorableMachine.ColorVariant.ORANGE)) {
                return base;
            }
            String colorFileSuffix = color.toString().toLowerCase();
            return ResourceLocation.fromNamespaceAndPath((String)base.getNamespace(), (String)base.getPath().replace("models", "models/colored").replace(".png", "_" + colorFileSuffix + ".png"));
        }
        return super.getTextureResource(animatable);
    }

    public ResourceLocation getBaseTexturePath(T animatable) {
        return super.getTextureResource(animatable);
    }
}

