/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.client.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import rearth.oritech.block.entity.interaction.PowerPoleEntity;
import rearth.oritech.util.Geometry;

public class PowerPoleLineRenderer
implements BlockEntityRenderer<PowerPoleEntity> {
    private static final ResourceLocation CABLE_TEXTURE = ResourceLocation.withDefaultNamespace((String)"textures/block/white_concrete.png");

    public void render(@NotNull PowerPoleEntity blockEntity, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        Set<PowerPoleEntity.ConnectionTarget> connections = blockEntity.getConnections();
        if (connections.isEmpty() || blockEntity.isRemoved()) {
            return;
        }
        BlockPos camPos = Minecraft.getInstance().cameraEntity.blockPosition();
        double poleDist = blockEntity.getBlockPos().distSqr((Vec3i)camPos);
        VertexConsumer consumer = bufferSource.getBuffer(RenderType.entitySolid((ResourceLocation)CABLE_TEXTURE));
        BlockPos ownPos = blockEntity.getBlockPos();
        Direction ownFacing = blockEntity.getFacingForMultiblock();
        Vec3 ownSideVec = Vec3.atLowerCornerOf((Vec3i)Geometry.getForward(ownFacing));
        Vec3 centerPos = new Vec3(0.5, 0.5, 0.5);
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.35f, 0.0f);
        for (PowerPoleEntity.ConnectionTarget target : connections) {
            Vec3 targetForStartB;
            Vec3 targetForStartA;
            double distCross;
            double targetDist;
            if (target == null || (targetDist = target.pos().distSqr((Vec3i)camPos)) < poleDist) continue;
            Vec3 startWorldA = Vec3.atCenterOf((Vec3i)ownPos).add(ownSideVec);
            Vec3 startWorldB = Vec3.atCenterOf((Vec3i)ownPos).subtract(ownSideVec);
            Vec3 targetArmVec = Vec3.atLowerCornerOf((Vec3i)Geometry.getForward(target.facing()));
            Vec3 targetWorldA = Vec3.atCenterOf((Vec3i)target.pos()).add(targetArmVec);
            Vec3 targetWorldB = Vec3.atCenterOf((Vec3i)target.pos()).subtract(targetArmVec);
            double distDirect = startWorldA.distanceToSqr(targetWorldA) + startWorldB.distanceToSqr(targetWorldB);
            if (distDirect < (distCross = startWorldA.distanceToSqr(targetWorldB) + startWorldB.distanceToSqr(targetWorldA))) {
                targetForStartA = targetWorldA;
                targetForStartB = targetWorldB;
            } else {
                targetForStartA = targetWorldB;
                targetForStartB = targetWorldA;
            }
            Vec3 localStartA = centerPos.add(ownSideVec);
            Vec3 localStartB = centerPos.subtract(ownSideVec);
            Vec3 localTargetA = targetForStartA.subtract((double)ownPos.getX(), (double)ownPos.getY(), (double)ownPos.getZ());
            Vec3 localTargetB = targetForStartB.subtract((double)ownPos.getX(), (double)ownPos.getY(), (double)ownPos.getZ());
            float thickness = 0.05f;
            this.renderHangingCable(poseStack, consumer, localStartA, localTargetA, thickness, packedLight);
            this.renderHangingCable(poseStack, consumer, localStartB, localTargetB, thickness, packedLight);
        }
        poseStack.popPose();
    }

    private void renderHangingCable(PoseStack poseStack, VertexConsumer consumer, Vec3 startPos, Vec3 endPos, float thickness, int packedLight) {
        poseStack.pushPose();
        Vec3 totalOffset = endPos.subtract(startPos);
        int segments = 8;
        float totalLength = (float)totalOffset.length();
        float sag = totalLength * 0.05f;
        sag = Math.min(sag, 4.0f);
        Vec3 currentPos = startPos;
        for (int i = 0; i < segments; ++i) {
            float t = (float)(i + 1) / (float)segments;
            Vec3 nextPos = startPos.add(totalOffset.scale((double)t));
            float sagY = -sag * 4.0f * t * (1.0f - t);
            nextPos = nextPos.add(0.0, (double)sagY, 0.0);
            Vec3 segmentDelta = nextPos.subtract(currentPos);
            Vec3 drawDelta = segmentDelta.scale(1.02);
            this.drawSegment(poseStack, consumer, currentPos, drawDelta, thickness, packedLight);
            currentPos = nextPos;
        }
        poseStack.popPose();
    }

    private void drawSegment(PoseStack poseStack, VertexConsumer consumer, Vec3 startPos, Vec3 delta, float thickness, int packedLight) {
        poseStack.pushPose();
        poseStack.translate(startPos.x, startPos.y, startPos.z);
        double xzLen = Math.sqrt(delta.x * delta.x + delta.z * delta.z);
        float yRot = (float)(-Math.atan2(-delta.x, delta.z));
        float xRot = (float)(-Math.atan2(delta.y, xzLen));
        poseStack.mulPose(Axis.YP.rotation(yRot));
        poseStack.mulPose(Axis.XP.rotation(xRot + 1.5707964f));
        float length = (float)delta.length();
        float r = thickness;
        int red = 50;
        int green = 50;
        int blue = 50;
        int alpha = 255;
        PoseStack.Pose pose = poseStack.last();
        this.addVertex(consumer, pose, -r, 0.0f, r, red, green, blue, alpha, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, packedLight);
        this.addVertex(consumer, pose, r, 0.0f, r, red, green, blue, alpha, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f, packedLight);
        this.addVertex(consumer, pose, r, length, r, red, green, blue, alpha, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, packedLight);
        this.addVertex(consumer, pose, -r, length, r, red, green, blue, alpha, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, packedLight);
        this.addVertex(consumer, pose, r, 0.0f, -r, red, green, blue, alpha, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f, packedLight);
        this.addVertex(consumer, pose, -r, 0.0f, -r, red, green, blue, alpha, 1.0f, 0.0f, 0.0f, 0.0f, -1.0f, packedLight);
        this.addVertex(consumer, pose, -r, length, -r, red, green, blue, alpha, 1.0f, 1.0f, 0.0f, 0.0f, -1.0f, packedLight);
        this.addVertex(consumer, pose, r, length, -r, red, green, blue, alpha, 0.0f, 1.0f, 0.0f, 0.0f, -1.0f, packedLight);
        this.addVertex(consumer, pose, -r, 0.0f, -r, red, green, blue, alpha, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, packedLight);
        this.addVertex(consumer, pose, -r, 0.0f, r, red, green, blue, alpha, 1.0f, 0.0f, -1.0f, 0.0f, 0.0f, packedLight);
        this.addVertex(consumer, pose, -r, length, r, red, green, blue, alpha, 1.0f, 1.0f, -1.0f, 0.0f, 0.0f, packedLight);
        this.addVertex(consumer, pose, -r, length, -r, red, green, blue, alpha, 0.0f, 1.0f, -1.0f, 0.0f, 0.0f, packedLight);
        this.addVertex(consumer, pose, r, 0.0f, r, red, green, blue, alpha, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, packedLight);
        this.addVertex(consumer, pose, r, 0.0f, -r, red, green, blue, alpha, 1.0f, 0.0f, 1.0f, 0.0f, 0.0f, packedLight);
        this.addVertex(consumer, pose, r, length, -r, red, green, blue, alpha, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, packedLight);
        this.addVertex(consumer, pose, r, length, r, red, green, blue, alpha, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, packedLight);
        poseStack.popPose();
    }

    private void addVertex(VertexConsumer consumer, PoseStack.Pose pose, float x, float y, float z, int r, int g, int b, int a, float u, float v, float nx, float ny, float nz, int packedLight) {
        consumer.addVertex(pose.pose(), x, y, z).setColor(r, g, b, a).setUv(u, v).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(pose, nx, ny, nz);
    }

    public int getViewDistance() {
        return 256;
    }

    public boolean shouldRenderOffScreen(PowerPoleEntity blockEntity) {
        return true;
    }
}

