/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.client.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.architectury.hooks.fluid.FluidStackHooks;
import io.wispforest.owo.ui.core.Color;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import rearth.oritech.api.fluid.containers.SimpleFluidStorage;
import rearth.oritech.block.entity.storage.SmallTankEntity;

public class SmallTankRenderer
implements BlockEntityRenderer<SmallTankEntity> {
    public void render(SmallTankEntity entity, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        SimpleFluidStorage storage = entity.fluidStorage;
        if (storage.getAmount() <= 0L || storage.getFluid().equals(Fluids.EMPTY)) {
            return;
        }
        Fluid fluid = storage.getFluid();
        float fill = (float)storage.getAmount() / (float)storage.getCapacity();
        TextureAtlasSprite sprite = FluidStackHooks.getStillTexture((Fluid)fluid);
        int spriteColor = FluidStackHooks.getColor((Fluid)fluid);
        VertexConsumer consumer = vertexConsumers.getBuffer(RenderType.translucent());
        Color parsedColor = Color.ofArgb((int)spriteColor);
        Color opaqueColor = new Color(parsedColor.red(), parsedColor.green(), parsedColor.blue(), 1.0f);
        spriteColor = opaqueColor.argb();
        matrices.pushPose();
        matrices.translate(0.126, 0.126, 0.126);
        matrices.scale(0.745f, 0.745f * fill, 0.745f);
        PoseStack.Pose entry = matrices.last();
        Matrix4f modelMatrix = entry.pose();
        for (Direction direction : Direction.values()) {
            if (direction.equals((Object)Direction.DOWN)) continue;
            SmallTankRenderer.drawQuad(direction, consumer, modelMatrix, entry, sprite, spriteColor, light, overlay);
        }
        matrices.popPose();
    }

    public static void drawQuad(Direction direction, VertexConsumer consumer, Matrix4f modelMatrix, PoseStack.Pose normalMatrix, TextureAtlasSprite sprite, int color, int light, int overlay) {
        Vector3f normal = direction.step();
        float[][] positions = SmallTankRenderer.getQuadVerticesByDirection(direction);
        for (int i = positions.length - 1; i >= 0; --i) {
            float[] pos = positions[i];
            float u = sprite.getU(SmallTankRenderer.getFrameU()[i]);
            float v = sprite.getV(SmallTankRenderer.getFrameV()[i]);
            consumer.addVertex(modelMatrix, pos[0], pos[1], pos[2]).setColor(color).setUv(u, v).setLight(light).setOverlay(overlay).setNormal(normalMatrix, normal.x, normal.y, normal.z);
        }
    }

    private static float[] getFrameU() {
        return new float[]{0.0f, 1.0f, 1.0f, 0.0f};
    }

    private static float[] getFrameV() {
        return new float[]{0.0f, 0.0f, 1.0f, 1.0f};
    }

    private static float[][] getQuadVerticesByDirection(Direction direction) {
        float[][] fArrayArray;
        switch (direction) {
            default: {
                throw new MatchException(null, null);
            }
            case UP: {
                float[][] fArrayArray2 = new float[4][];
                fArrayArray2[0] = new float[]{0.0f, 1.0f, 0.0f};
                fArrayArray2[1] = new float[]{1.0f, 1.0f, 0.0f};
                fArrayArray2[2] = new float[]{1.0f, 1.0f, 1.0f};
                fArrayArray = fArrayArray2;
                fArrayArray2[3] = new float[]{0.0f, 1.0f, 1.0f};
                break;
            }
            case DOWN: {
                float[][] fArrayArray3 = new float[4][];
                fArrayArray3[0] = new float[]{0.0f, 0.0f, 1.0f};
                fArrayArray3[1] = new float[]{1.0f, 0.0f, 1.0f};
                fArrayArray3[2] = new float[]{1.0f, 0.0f, 0.0f};
                fArrayArray = fArrayArray3;
                fArrayArray3[3] = new float[]{0.0f, 0.0f, 0.0f};
                break;
            }
            case NORTH: {
                float[][] fArrayArray4 = new float[4][];
                fArrayArray4[0] = new float[]{1.0f, 1.0f, 0.0f};
                fArrayArray4[1] = new float[]{0.0f, 1.0f, 0.0f};
                fArrayArray4[2] = new float[]{0.0f, 0.0f, 0.0f};
                fArrayArray = fArrayArray4;
                fArrayArray4[3] = new float[]{1.0f, 0.0f, 0.0f};
                break;
            }
            case SOUTH: {
                float[][] fArrayArray5 = new float[4][];
                fArrayArray5[0] = new float[]{0.0f, 1.0f, 1.0f};
                fArrayArray5[1] = new float[]{1.0f, 1.0f, 1.0f};
                fArrayArray5[2] = new float[]{1.0f, 0.0f, 1.0f};
                fArrayArray = fArrayArray5;
                fArrayArray5[3] = new float[]{0.0f, 0.0f, 1.0f};
                break;
            }
            case WEST: {
                float[][] fArrayArray6 = new float[4][];
                fArrayArray6[0] = new float[]{0.0f, 1.0f, 0.0f};
                fArrayArray6[1] = new float[]{0.0f, 1.0f, 1.0f};
                fArrayArray6[2] = new float[]{0.0f, 0.0f, 1.0f};
                fArrayArray = fArrayArray6;
                fArrayArray6[3] = new float[]{0.0f, 0.0f, 0.0f};
                break;
            }
            case EAST: {
                float[][] fArrayArray7 = new float[4][];
                fArrayArray7[0] = new float[]{1.0f, 1.0f, 1.0f};
                fArrayArray7[1] = new float[]{1.0f, 1.0f, 0.0f};
                fArrayArray7[2] = new float[]{1.0f, 0.0f, 0.0f};
                fArrayArray = fArrayArray7;
                fArrayArray7[3] = new float[]{1.0f, 0.0f, 1.0f};
            }
        }
        return fArrayArray;
    }
}

