/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.item.other;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import rearth.oritech.Oritech;
import rearth.oritech.block.entity.MachineCoreEntity;
import rearth.oritech.util.ColorableMachine;

public class ColorCartridgeItem
extends Item {
    public final ColorableMachine.ColorVariant variant;

    public ColorCartridgeItem(Item.Properties properties, ColorableMachine.ColorVariant variant) {
        super(properties);
        this.variant = variant;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.oritech.paint.1").withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.oritech.paint.2").withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        MachineCoreEntity machineCore;
        if (context.getLevel().isClientSide()) {
            return super.useOn(context);
        }
        BlockPos targetBlock = context.getClickedPos();
        BlockEntity targetEntity = context.getLevel().getBlockEntity(targetBlock);
        if (targetEntity instanceof MachineCoreEntity && (machineCore = (MachineCoreEntity)targetEntity).getCachedController() != null) {
            targetEntity = (BlockEntity)machineCore.getCachedController();
            targetBlock = targetEntity.getBlockPos();
        }
        if (targetEntity instanceof ColorableMachine) {
            ColorableMachine colorableMachine = (ColorableMachine)targetEntity;
            if (colorableMachine.getCurrentColor().equals((Object)this.variant)) {
                return super.useOn(context);
            }
            Oritech.LOGGER.info("assigning color {} to {}", (Object)this.variant, (Object)targetBlock);
            colorableMachine.assignColor(this.variant);
            ItemStack stack = context.getItemInHand();
            stack.shrink(1);
            context.getPlayer().setItemInHand(context.getHand(), stack);
            context.getLevel().playSound(null, targetBlock, SoundEvents.AXOLOTL_SPLASH, SoundSource.PLAYERS, 1.0f, 0.6f);
            return InteractionResult.CONSUME;
        }
        return super.useOn(context);
    }
}

