/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.item.tools;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import rearth.oritech.Oritech;
import rearth.oritech.block.blocks.processing.MachineCoreBlock;
import rearth.oritech.block.entity.interaction.DronePortEntity;
import rearth.oritech.block.entity.interaction.LaserArmBlockEntity;
import rearth.oritech.block.entity.interaction.PowerPoleEntity;
import rearth.oritech.init.BlockContent;
import rearth.oritech.init.ComponentContent;

public class LaserTargetDesignator
extends Item {
    public LaserTargetDesignator(Item.Properties settings) {
        super(settings);
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockEntity blockEntity;
        BlockEntity machineEntity;
        if (context.getLevel().isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        BlockPos targetPos = context.getClickedPos();
        BlockState targetBlockState = context.getLevel().getBlockState(context.getClickedPos());
        if (targetBlockState.getBlock() instanceof MachineCoreBlock && ((Boolean)targetBlockState.getValue((Property)MachineCoreBlock.USED)).booleanValue() && ((machineEntity = MachineCoreBlock.getControllerEntity((LevelAccessor)context.getLevel(), context.getClickedPos())) instanceof LaserArmBlockEntity || machineEntity instanceof PowerPoleEntity)) {
            targetPos = MachineCoreBlock.getControllerPos((LevelAccessor)context.getLevel(), targetPos);
            targetBlockState = context.getLevel().getBlockState(targetPos);
        }
        if (targetBlockState.getBlock().equals(BlockContent.LASER_ARM_BLOCK) && (blockEntity = context.getLevel().getBlockEntity(targetPos)) instanceof LaserArmBlockEntity) {
            LaserArmBlockEntity laserEntity = (LaserArmBlockEntity)blockEntity;
            if (laserEntity.hunterAddons > 0) {
                laserEntity.cycleHunterTargetMode();
                context.getPlayer().sendSystemMessage((Component)Component.translatable((String)"message.oritech.target_designator.hunter_target", (Object[])new Object[]{Component.translatable((String)laserEntity.hunterTargetMode.message)}));
                return InteractionResult.SUCCESS;
            }
            if (context.getItemInHand().has((DataComponentType)ComponentContent.TARGET_POSITION.get())) {
                target = (BlockPos)context.getItemInHand().get((DataComponentType)ComponentContent.TARGET_POSITION.get());
                boolean success = laserEntity.setTargetFromDesignator((BlockPos)target);
                if (success) {
                    context.getPlayer().sendSystemMessage((Component)Component.translatable((String)"message.oritech.target_designator.position_saved"));
                }
                return success ? InteractionResult.SUCCESS : InteractionResult.FAIL;
            }
        } else {
            if (targetBlockState.getBlock().equals(BlockContent.DRONE_PORT_BLOCK) && (target = context.getLevel().getBlockEntity(context.getClickedPos())) instanceof DronePortEntity) {
                DronePortEntity dronePortEntity = (DronePortEntity)target;
                if (context.getItemInHand().has((DataComponentType)ComponentContent.TARGET_POSITION.get())) {
                    target = (BlockPos)context.getItemInHand().get((DataComponentType)ComponentContent.TARGET_POSITION.get());
                    boolean success = dronePortEntity.setTargetFromDesignator((BlockPos)target);
                    if (success) {
                        context.getPlayer().sendSystemMessage((Component)Component.translatable((String)"message.oritech.target_designator.position_saved"));
                    } else {
                        context.getPlayer().sendSystemMessage((Component)Component.translatable((String)"message.oritech.target_designator.position_invalid"));
                    }
                    return success ? InteractionResult.SUCCESS : InteractionResult.FAIL;
                }
            }
            if ((target = context.getLevel().getBlockEntity(targetPos)) instanceof PowerPoleEntity) {
                PowerPoleEntity powerPole = (PowerPoleEntity)target;
                if (context.getItemInHand().has((DataComponentType)ComponentContent.TARGET_POSITION.get())) {
                    target = (BlockPos)context.getItemInHand().get((DataComponentType)ComponentContent.TARGET_POSITION.get());
                    powerPole.assignNewTarget((BlockPos)target, context.getPlayer());
                    context.getItemInHand().remove((DataComponentType)ComponentContent.TARGET_POSITION.get());
                    return InteractionResult.SUCCESS;
                }
            }
        }
        if (!targetBlockState.getBlock().equals(Blocks.AIR)) {
            Oritech.LOGGER.debug(targetBlockState.toString());
            context.getItemInHand().set((DataComponentType)ComponentContent.TARGET_POSITION.get(), (Object)context.getClickedPos());
            context.getPlayer().sendSystemMessage((Component)Component.translatable((String)"message.oritech.target_designator.position_stored"));
            return InteractionResult.SUCCESS;
        }
        return super.useOn(context);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        if (stack.has((DataComponentType)ComponentContent.TARGET_POSITION.get())) {
            BlockPos data = (BlockPos)stack.get((DataComponentType)ComponentContent.TARGET_POSITION.get());
            tooltip.add((Component)Component.translatable((String)"tooltip.oritech.target_designator.set_to", (Object[])new Object[]{data.toShortString()}));
        } else {
            tooltip.add((Component)Component.translatable((String)"tooltip.oritech.target_designator.no_target"));
        }
    }
}

