/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.item.tools.harvesting;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.block.entity.interaction.TreefellerBlockEntity;
import rearth.oritech.client.init.ParticleContent;
import rearth.oritech.client.renderers.PromethiumToolRenderer;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class PromethiumAxeItem
extends AxeItem
implements GeoItem {
    public static final Deque<Tuple<Level, BlockPos>> pendingBlocks = new ArrayDeque<Tuple<Level, BlockPos>>();
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public PromethiumAxeItem(Tier toolMaterial, Item.Properties settings) {
        super(toolMaterial, settings);
        Tool toolComponent = new Tool(List.of(Tool.Rule.deniesDrops((TagKey)toolMaterial.getIncorrectBlocksForDrops()), Tool.Rule.minesAndDrops((TagKey)BlockTags.MINEABLE_WITH_AXE, (float)toolMaterial.getSpeed()), Tool.Rule.overrideSpeed((TagKey)BlockTags.SWORD_EFFICIENT, (float)1.5f), Tool.Rule.minesAndDrops(List.of(Blocks.COBWEB), (float)15.0f)), 1.0f, 1);
        this.components = settings.component(DataComponents.TOOL, (Object)toolComponent).buildAndValidateComponents();
    }

    public boolean mineBlock(ItemStack stack, Level world, BlockState state, BlockPos pos, LivingEntity miner) {
        BlockPos startPos;
        BlockState startState;
        if (!world.isClientSide && miner.isShiftKeyDown() && (startState = world.getBlockState(startPos = pos.above())).is(BlockTags.LOGS)) {
            Deque<BlockPos> treeBlocks = TreefellerBlockEntity.getTreeBlocks(startPos, world);
            pendingBlocks.addAll(treeBlocks.stream().map(elem -> new Tuple((Object)world, elem)).toList());
        }
        return true;
    }

    public static void processPendingBlocks(Level world) {
        if (pendingBlocks.isEmpty()) {
            return;
        }
        Level topWorld = (Level)pendingBlocks.getFirst().getA();
        if (topWorld != world) {
            return;
        }
        for (int i = 0; i < 8 && !pendingBlocks.isEmpty(); ++i) {
            BlockPos candidate = (BlockPos)pendingBlocks.pollFirst().getB();
            BlockState candidateState = world.getBlockState(candidate);
            if (!candidateState.is(BlockTags.LOGS) && !candidateState.is(BlockTags.LEAVES)) {
                return;
            }
            List dropped = Block.getDrops((BlockState)candidateState, (ServerLevel)((ServerLevel)world), (BlockPos)candidate, null);
            world.setBlockAndUpdate(candidate, Blocks.AIR.defaultBlockState());
            dropped.forEach(elem -> world.addFreshEntity((Entity)new ItemEntity(world, (double)candidate.getX(), (double)candidate.getY(), (double)candidate.getZ(), elem)));
            world.playSound(null, candidate, candidateState.getSoundType().getBreakSound(), SoundSource.BLOCKS, 0.5f, 1.0f);
            world.addDestroyBlockEffect(candidate, candidateState);
            ParticleContent.BLOCK_DESTROY_EFFECT.spawn(world, Vec3.atLowerCornerOf((Vec3i)candidate), (Object)4);
            if (candidateState.is(BlockTags.LOGS)) break;
        }
    }

    public boolean isValidRepairItem(ItemStack stack, ItemStack ingredient) {
        return false;
    }

    public boolean isEnchantable(ItemStack stack) {
        return true;
    }

    public void createGeoRenderer(Consumer<GeoRenderProvider> consumer) {
        consumer.accept(new GeoRenderProvider(this){
            private PromethiumToolRenderer renderer;

            @Nullable
            public BlockEntityWithoutLevelRenderer getGeoItemRenderer() {
                if (this.renderer == null) {
                    this.renderer = new PromethiumToolRenderer("promethium_axe");
                }
                return this.renderer;
            }
        });
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public static void onTick(ServerLevel serverWorld) {
        PromethiumAxeItem.processPendingBlocks((Level)serverWorld);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        tooltip.add((Component)Component.translatable((String)"tooltip.oritech.promethium_axe").withStyle(ChatFormatting.DARK_GRAY));
    }
}

