/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.stateobserver.mixin;

import net.favouriteless.stateobserver.StateObserverManagerImpl;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LevelChunk.class})
public class LevelChunkMixin {
    @Inject(method={"setBlockState"}, at={@At(value="HEAD")})
    public void onStateChange(BlockPos pos, BlockState state, boolean isMoving, CallbackInfoReturnable<BlockState> cir) {
        LevelChunk chunk = (LevelChunk)this;
        Level level = chunk.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            StateObserverManagerImpl.INSTANCE.notifyChange(serverLevel, pos, chunk.getBlockState(pos), state);
        }
    }
}

