/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.soaryn.xycraft.api.content.capabilities.IColorable;
import tv.soaryn.xycraft.core.content.attachments.accessors.FavoredColor;
import tv.soaryn.xycraft.core.content.blocks.CoreStateProperties;
import tv.soaryn.xycraft.core.content.blocks.IColoredBlock;
import tv.soaryn.xycraft.core.content.blocks.ITooltipProvider;
import tv.soaryn.xycraft.core.content.blocks.XyBlock;
import tv.soaryn.xycraft.core.content.blocks.XyBlockEntity;
import tv.soaryn.xycraft.core.content.capabilities.ColorableCapability;
import tv.soaryn.xycraft.core.content.capabilities.CoreCapabilities;
import tv.soaryn.xycraft.core.content.registries.CoreAttachments;
import tv.soaryn.xycraft.core.utils.ColorUtils;
import tv.soaryn.xycraft.core.utils.Utils;
import tv.soaryn.xycraft.machines.content.attachments.ChargerAttachment;
import tv.soaryn.xycraft.machines.content.registries.MachinesAttachments;
import tv.soaryn.xycraft.machines.content.registries.MachinesContent;
import tv.soaryn.xycraft.machines.content.registries.MachinesSystems;
import tv.soaryn.xycraft.machines.gui.ChargerMenu;

@EventBusSubscriber(modid="xycraft_machines", bus=EventBusSubscriber.Bus.MOD)
public class ChargerBlock
extends XyBlock.WithEntity
implements IColoredBlock,
ITooltipProvider.BlockDefault {
    private static final VoxelShape Shape = Shapes.join((VoxelShape)ChargerBlock.box((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0), (VoxelShape)ChargerBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (BooleanOp)BooleanOp.NOT_SAME);

    public ChargerBlock(BlockBehaviour.Properties properties) {
        super(properties.noOcclusion().randomTicks(), Entity::new);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)CoreStateProperties.ActiveSideDown, (Comparable)Boolean.valueOf(true))).setValue((Property)CoreStateProperties.ActiveSideUp, (Comparable)Boolean.valueOf(true))).setValue((Property)CoreStateProperties.ActiveSideNorth, (Comparable)Boolean.valueOf(true))).setValue((Property)CoreStateProperties.ActiveSideSouth, (Comparable)Boolean.valueOf(true))).setValue((Property)CoreStateProperties.ActiveSideWest, (Comparable)Boolean.valueOf(true))).setValue((Property)CoreStateProperties.ActiveSideEast, (Comparable)Boolean.valueOf(true)));
        this.registerSystem(MachinesSystems.Charger);
        this.registerHasCapability();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{CoreStateProperties.ActiveSideDown});
        builder.add(new Property[]{CoreStateProperties.ActiveSideUp});
        builder.add(new Property[]{CoreStateProperties.ActiveSideNorth});
        builder.add(new Property[]{CoreStateProperties.ActiveSideSouth});
        builder.add(new Property[]{CoreStateProperties.ActiveSideWest});
        builder.add(new Property[]{CoreStateProperties.ActiveSideEast});
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return Shape;
    }

    public boolean useShapeForLightOcclusion(@NotNull BlockState state) {
        return true;
    }

    @NotNull
    public InteractionResult useWithoutItem(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult hitResult) {
        BlockEntity be = level.getBlockEntity(pos);
        if (!(be instanceof Entity)) {
            return super.useWithoutItem(state, level, pos, player, hitResult);
        }
        Entity entity = (Entity)be;
        level.playSound(null, pos, SoundEvents.SHULKER_BOX_OPEN, SoundSource.BLOCKS, 0.05f, level.random.nextFloat() * 0.1f + 0.9f);
        if (!level.isClientSide() && !player.isFakePlayer()) {
            player.openMenu((MenuProvider)entity, be.getBlockPos());
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide());
    }

    public void setPlacedBy(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable LivingEntity entity, @NotNull ItemStack stack) {
        BlockEntity blockEntity;
        Player player;
        block5: {
            block4: {
                super.setPlacedBy(level, pos, state, entity, stack);
                if (!(entity instanceof Player)) break block4;
                player = (Player)entity;
                blockEntity = level.getBlockEntity(pos);
                if (blockEntity instanceof Entity) break block5;
            }
            return;
        }
        Entity box = (Entity)blockEntity;
        DyeColor dye = DyeColor.getColor((ItemStack)player.getOffhandItem());
        IColorable cap = ColorableCapability.of((Level)level, (BlockPos)pos);
        if (cap == null) {
            return;
        }
        cap.setColor(0, dye == null ? FavoredColor.of((IAttachmentHolder)player) : ColorUtils.getColorFromDye((DyeColor)dye));
        box.setChanged();
    }

    public void onRemove(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState newState, boolean moving) {
        BlockEntity blockEntity;
        if (!state.is(newState.getBlock()) && (blockEntity = level.getBlockEntity(pos)) instanceof Entity) {
            Entity entity = (Entity)blockEntity;
            ChargerAttachment data = (ChargerAttachment)entity.getData(MachinesAttachments.Block.ChargerData);
            Containers.dropContents((Level)level, (BlockPos)pos, (Container)data.Inventory.asVanillaContainer());
        }
        super.onRemove(state, level, pos, newState, moving);
    }

    @SubscribeEvent
    private static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlock(Capabilities.ItemHandler.BLOCK, (level, pos, state, blockEntity, context) -> {
            if (ChargerBlock.isMissingCapability(state, blockEntity, context)) {
                return null;
            }
            return ((ChargerAttachment)blockEntity.getData(MachinesAttachments.Block.ChargerData)).Handler;
        }, new Block[]{MachinesContent.Block.Charger.block()});
        event.registerBlock(Capabilities.EnergyStorage.BLOCK, (level, pos, state, blockEntity, context) -> {
            if (ChargerBlock.isMissingCapability(state, blockEntity, context)) {
                return null;
            }
            return new IEnergyStorage(){

                public int receiveEnergy(int toReceive, boolean simulate) {
                    ChargerAttachment data = (ChargerAttachment)blockEntity.getData(MachinesAttachments.Block.ChargerData);
                    int amount = toReceive;
                    for (ItemStack stack : data.Input) {
                        if (amount == 0) break;
                        IEnergyStorage cap = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
                        if (cap == null) continue;
                        amount -= cap.receiveEnergy(amount, simulate);
                    }
                    return toReceive - amount;
                }

                public int extractEnergy(int toExtract, boolean simulate) {
                    return 0;
                }

                public int getEnergyStored() {
                    return 0;
                }

                public int getMaxEnergyStored() {
                    return 0;
                }

                public boolean canExtract() {
                    return false;
                }

                public boolean canReceive() {
                    ChargerAttachment data = (ChargerAttachment)blockEntity.getData(MachinesAttachments.Block.ChargerData);
                    return !data.Input.isEmpty();
                }
            };
        }, new Block[]{MachinesContent.Block.Charger.block()});
        event.registerBlock(CoreCapabilities.Colorable.BLOCK, ColorableCapability::registerBlock, new Block[]{MachinesContent.Block.Charger.block()});
        event.registerBlock(CoreCapabilities.WrenchBlock.BLOCK, (level, pos, state, blockEntity, context) -> (player, interactionHand, hitResult) -> {
            BlockState state2 = level.getBlockState(pos);
            level.setBlockAndUpdate(pos, (BlockState)state2.cycle((Property)CoreStateProperties.ActiveSideMap.get(hitResult.getDirection())));
            level.invalidateCapabilities(pos);
            return InteractionResult.sidedSuccess((boolean)level.isClientSide());
        }, new Block[]{MachinesContent.Block.Charger.block()});
    }

    private static boolean isMissingCapability(BlockState state, BlockEntity blockEntity, Direction context) {
        return blockEntity == null || context != null && (Boolean)state.getValue((Property)CoreStateProperties.ActiveSideMap.get(context)) == false;
    }

    public int getColorOfBlock(BlockState state, BlockAndTintGetter level, BlockPos pos, int index) {
        if (level == null) {
            return super.getColorOfBlock(state, level, pos, index);
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity == null) {
            return super.getColorOfBlock(state, level, pos, index);
        }
        return FavoredColor.of((IAttachmentHolder)blockEntity);
    }

    public int getColorOfItem(ItemStack stack, int index) {
        return FavoredColor.of((IAttachmentHolder)Utils.getClientPlayer());
    }

    public static class Entity
    extends XyBlockEntity.WithMenu {
        public Entity(BlockPos pos, BlockState state) {
            super(MachinesContent.Block.Charger.entity(), "block.xycraft_machines.charger", pos, state, new AttachmentType[]{(AttachmentType)CoreAttachments.Color.get(), MachinesAttachments.Block.ChargerData.get()});
        }

        @Nullable
        public AbstractContainerMenu createMenu(int windowId, @NotNull Inventory playerInventory, @NotNull Player playerEntity) {
            return new ChargerMenu(windowId, playerInventory, (BlockEntity)this, ((ChargerAttachment)this.getData(MachinesAttachments.Block.ChargerData)).Inventory);
        }
    }
}

