/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.blocks.multiblock;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.attachment.AttachmentType;
import tv.soaryn.xycraft.core.content.blocks.CoreStateProperties;
import tv.soaryn.xycraft.core.content.blocks.XyBlockEntity;
import tv.soaryn.xycraft.machines.XyMachines;
import tv.soaryn.xycraft.machines.content.attachments.TankMemberAttachment;
import tv.soaryn.xycraft.machines.content.blocks.properties.MachineStateProperties;
import tv.soaryn.xycraft.machines.content.multiblock.tank.IMultiTankMember;
import tv.soaryn.xycraft.machines.content.multiblock.tank.TankMultiBlock;
import tv.soaryn.xycraft.machines.content.registries.MachinesAttachments;

public abstract class TankMemberBlockEntity
extends XyBlockEntity
implements IMultiTankMember {
    protected TankMultiBlock tank = null;

    public TankMemberBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state, new AttachmentType[0]);
    }

    public boolean isFormed() {
        Level level = this.level;
        if (!(level instanceof ServerLevel)) {
            return false;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        TankMultiBlock[] multiBlocks = this.getMultiBlockArray(serverLevel);
        return multiBlocks[0] != null && multiBlocks[0].isValid() || multiBlocks[1] != null && multiBlocks[1].isValid();
    }

    @Override
    public Iterable<TankMultiBlock> getMultiBlocks() {
        Level level = this.level;
        if (!(level instanceof ServerLevel)) {
            return List.of();
        }
        ServerLevel serverLevel = (ServerLevel)level;
        TankMultiBlock[] multiBlocks = this.getMultiBlockArray(serverLevel);
        if (multiBlocks[0] != null) {
            return multiBlocks[1] == null ? List.of(multiBlocks[0]) : List.of();
        }
        if (multiBlocks[1] != null) {
            return List.of(multiBlocks[1]);
        }
        return List.of();
    }

    @Override
    public void onJoin(TankMultiBlock multiBlock) {
        Level level = this.level;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        TankMultiBlock[] multiBlocks = this.getMultiBlockArray(serverLevel);
        if (multiBlocks[0] == null || !multiBlocks[0].isValid()) {
            multiBlocks[0] = multiBlock;
        } else if (multiBlocks[1] == null || !multiBlocks[1].isValid()) {
            multiBlocks[1] = multiBlock;
        } else {
            XyMachines.Logger.error("Somehow a tank tried to join a group, but somehow didn't fit in... weird");
            return;
        }
        this.setChanged();
        this.updateStateAndCaps();
        this.invalidateCapabilities();
    }

    boolean canPreserveFluid() {
        return false;
    }

    @Override
    public void onLeave(TankMultiBlock multiBlock) {
        Level level = this.level;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        TankMultiBlock[] multiBlocks = this.getMultiBlockArray(serverLevel);
        if (multiBlock == multiBlocks[0]) {
            if (this.canPreserveFluid()) {
                if (multiBlocks[1] != null) {
                    int tankToMutate = multiBlocks[1].isValid() ? 0 : 1;
                    multiBlocks[tankToMutate] = null;
                }
            } else {
                multiBlocks[0] = null;
            }
        } else if (multiBlock == multiBlocks[1]) {
            if (this.canPreserveFluid()) {
                if (multiBlocks[0] != null) {
                    int tankToMutate = multiBlocks[0].isValid() ? 1 : 0;
                    multiBlocks[tankToMutate] = null;
                }
            } else {
                multiBlocks[1] = null;
            }
        } else {
            XyMachines.Logger.error("Somehow a tank tried to leave a group, but it didn't exist... Unsure how");
            XyMachines.Logger.error("Leaving Tank: %s".formatted(multiBlock != null ? multiBlock.getDescriptor() : "null"));
            XyMachines.Logger.error("Tank1: %s".formatted(multiBlocks[0] != null ? multiBlocks[0].getDescriptor() : "null"));
            XyMachines.Logger.error("Tank2: %s".formatted(multiBlocks[1] != null ? multiBlocks[1].getDescriptor() : "null"));
            return;
        }
        this.setChanged();
        this.updateStateAndCaps();
    }

    private void updateStateAndCaps() {
        boolean formed;
        if (this.isRemoved()) {
            return;
        }
        Direction.Axis axis = Direction.Axis.Y;
        Level level = this.getLevel();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        TankMultiBlock[] multiBlocks = this.getMultiBlockArray(serverLevel);
        if (multiBlocks[0] != null && multiBlocks[0].isValid()) {
            if (multiBlocks[1] == null) {
                this.setMultiBlock(multiBlocks[0]);
                axis = multiBlocks[0].determineAxis(this.getBlockPos());
            }
        } else if (multiBlocks[1] != null && multiBlocks[1].isValid()) {
            this.setMultiBlock(multiBlocks[1]);
            axis = multiBlocks[1].determineAxis(this.getBlockPos());
        }
        if (!(formed = this.isFormed())) {
            this.setMultiBlock(null);
        }
        level.setBlockAndUpdate(this.getBlockPos(), (BlockState)((BlockState)this.getBlockState().setValue((Property)CoreStateProperties.Axis, (Comparable)axis)).setValue((Property)MachineStateProperties.Initialized, (Comparable)Boolean.valueOf(formed)));
        level.invalidateCapabilities(this.getBlockPos());
        this.setChanged();
    }

    protected TankMultiBlock[] getMultiBlockArray(ServerLevel serverLevel) {
        TankMemberAttachment memberCache = (TankMemberAttachment)this.getData(MachinesAttachments.Block.TankMemberData);
        return memberCache.getMultiBlocks(serverLevel, this);
    }

    public void setMultiBlock(TankMultiBlock tank) {
        this.tank = tank;
        this.invalidateCapabilities();
    }

    public void onLoad() {
        Level level = this.level;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        this.getMultiBlockArray(serverLevel);
    }
}

