/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.temp;

import net.minecraft.Util;
import net.minecraft.core.Direction;

public enum RelativeSide {
    FRONT(Direction.NORTH),
    BACK(Direction.SOUTH),
    TOP(Direction.UP),
    BOTTOM(Direction.DOWN),
    LEFT(Direction.WEST),
    RIGHT(Direction.EAST);

    private static final RelativeSide[] _originalSides;
    private final Direction _original;

    private RelativeSide(Direction nonRotatedSide) {
        this._original = nonRotatedSide;
    }

    public static RelativeSide fromOriginal(Direction side) {
        return _originalSides[side.ordinal()];
    }

    public Direction toOriginal() {
        return this._original;
    }

    static {
        _originalSides = (RelativeSide[])Util.make(() -> {
            RelativeSide[] array = new RelativeSide[Direction.values().length];
            RelativeSide[] relativeSideArray = RelativeSide.values();
            int n = relativeSideArray.length;
            for (int i = 0; i < n; ++i) {
                RelativeSide side;
                array[side._original.ordinal()] = side = relativeSideArray[i];
            }
            return array;
        });
    }
}

