/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.dndesires.compat.jei;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.Create;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.content.processing.basin.BasinRecipe;
import com.tterrag.registrate.util.entry.BlockEntry;
import dev.lopyluna.dndesires.DnDesires;
import dev.lopyluna.dndesires.compat.jei.category.DragonBreathingCategory;
import dev.lopyluna.dndesires.compat.jei.category.FreezingCategory;
import dev.lopyluna.dndesires.compat.jei.category.HydraulicCategory;
import dev.lopyluna.dndesires.compat.jei.category.SandingCategory;
import dev.lopyluna.dndesires.compat.jei.category.SeethingCategory;
import dev.lopyluna.dndesires.content.recipes.DragonBreathingRecipe;
import dev.lopyluna.dndesires.content.recipes.FreezingRecipe;
import dev.lopyluna.dndesires.content.recipes.SandingRecipe;
import dev.lopyluna.dndesires.content.recipes.SeethingRecipe;
import dev.lopyluna.dndesires.register.DesiresBlocks;
import dev.lopyluna.dndesires.register.DesiresRecipeTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
@JeiPlugin
public class DesiresJEI
implements IModPlugin {
    private static final ResourceLocation ID = DnDesires.loc("jei_plugin");
    private final List<CreateRecipeCategory<?>> allCategories = new ArrayList();
    public static IJeiRuntime runtime;

    private void loadCategories() {
        this.allCategories.clear();
        CreateRecipeCategory dragonBreathing = this.builder(DragonBreathingRecipe.class).addTypedRecipes(DesiresRecipeTypes.DRAGON_BREATHING).catalystStack(DesiresJEI.getInFan("fan_dragon_breathing", "Fan behind Dragon bound blocks")).doubleItemIcon((ItemLike)AllItems.PROPELLER.get(), (ItemLike)Items.DRAGON_HEAD).emptyBackground(178, 72).build("fan_dragon_breathing", DragonBreathingCategory::new);
        CreateRecipeCategory freezing = this.builder(FreezingRecipe.class).addTypedRecipes(DesiresRecipeTypes.FREEZING).catalystStack(DesiresJEI.getFan("fan_freezing", "Fan behind Freezing Snow")).catalystStack(() -> DesiresBlocks.INDUSTRIAL_FAN.asStack()).doubleItemIcon((ItemLike)AllItems.PROPELLER.get(), (ItemLike)Items.POWDER_SNOW_BUCKET).emptyBackground(178, 72).build("fan_freezing", FreezingCategory::new);
        CreateRecipeCategory sanding = this.builder(SandingRecipe.class).addTypedRecipes(DesiresRecipeTypes.SANDING).catalystStack(DesiresJEI.getFan("fan_sanding", "Fan behind Sand")).catalystStack(() -> DesiresBlocks.INDUSTRIAL_FAN.asStack()).doubleItemIcon((ItemLike)AllItems.PROPELLER.get(), (ItemLike)Items.SAND).emptyBackground(178, 72).build("fan_sanding", SandingCategory::new);
        CreateRecipeCategory seething = this.builder(SeethingRecipe.class).addTypedRecipes(DesiresRecipeTypes.SEETHING).catalystStack(DesiresJEI.getFan("fan_seething", "Fan behind Seething Heat")).catalystStack(() -> DesiresBlocks.INDUSTRIAL_FAN.asStack()).doubleItemIcon((ItemLike)AllItems.PROPELLER.get(), (ItemLike)AllItems.BLAZE_CAKE).emptyBackground(178, 72).build("fan_seething", SeethingCategory::new);
        CreateRecipeCategory hydraulic_compacting = this.builder(BasinRecipe.class).addTypedRecipes(DesiresRecipeTypes.HYDRAULIC_COMPACTING).catalyst(() -> DesiresBlocks.HYDRAULIC_PRESS.get()).catalyst(() -> ((BlockEntry)AllBlocks.BASIN).get()).doubleItemIcon((ItemLike)DesiresBlocks.HYDRAULIC_PRESS.get(), (ItemLike)AllBlocks.BASIN.get()).emptyBackground(177, 103).build(DnDesires.loc("hydraulic_compacting"), HydraulicCategory::new);
    }

    public static Supplier<ItemStack> getInFan(String name, String fullName) {
        ItemStack stack = DesiresBlocks.INDUSTRIAL_FAN.asStack();
        stack.set(DataComponents.CUSTOM_NAME, (Object)Component.translatableWithFallback((String)("dndesires.recipe." + name + ".fan"), (String)fullName).withStyle(style -> style.withItalic(Boolean.valueOf(false))));
        return () -> stack;
    }

    public static Supplier<ItemStack> getFan(String name, String fullName) {
        ItemStack stack = AllBlocks.ENCASED_FAN.asStack();
        stack.set(DataComponents.CUSTOM_NAME, (Object)Component.translatableWithFallback((String)("dndesires.recipe." + name + ".fan"), (String)fullName).withStyle(style -> style.withItalic(Boolean.valueOf(false))));
        return () -> stack;
    }

    private <T extends Recipe<? extends RecipeInput>> CategoryBuilder<T> builder(Class<T> recipeClass) {
        return new CategoryBuilder<T>(recipeClass);
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        this.loadCategories();
        registration.addRecipeCategories((IRecipeCategory[])this.allCategories.toArray(IRecipeCategory[]::new));
    }

    public void registerRecipes(IRecipeRegistration registration) {
        this.allCategories.forEach(c -> c.registerRecipes(registration));
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        this.allCategories.forEach(c -> c.registerCatalysts(registration));
        registration.addRecipeCatalyst(DesiresBlocks.HYDRAULIC_PRESS, new RecipeType[]{RecipeType.createRecipeHolderType((ResourceLocation)Create.asResource((String)"pressing"))});
    }

    @NotNull
    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void onRuntimeAvailable(IJeiRuntime runtime) {
        DesiresJEI.runtime = runtime;
    }

    private class CategoryBuilder<T extends Recipe<?>>
    extends CreateRecipeCategory.Builder<T> {
        public CategoryBuilder(Class<? extends T> recipeClass) {
            super(recipeClass);
        }

        @NotNull
        public CreateRecipeCategory<T> build(ResourceLocation id, CreateRecipeCategory.Factory<T> factory) {
            CreateRecipeCategory category = super.build(id, factory);
            DesiresJEI.this.allCategories.add(category);
            return category;
        }
    }
}

