/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.dndesires.content.blocks.logistics.smart_hopper;

import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.block.IBE;
import dev.lopyluna.dndesires.content.blocks.logistics.smart_hopper.SmartHopperBE;
import dev.lopyluna.dndesires.register.DesiresBETypes;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class SmartHopperBlock
extends Block
implements IWrenchable,
IBE<SmartHopperBE> {
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final DirectionProperty FACING = BlockStateProperties.FACING_HOPPER;
    public static AABB SUCK_AABB = (AABB)Block.box((double)0.0, (double)11.0, (double)0.0, (double)16.0, (double)32.0, (double)16.0).toAabbs().getFirst();
    private static final VoxelShape TOP = Block.box((double)0.0, (double)10.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape FUNNEL = Block.box((double)2.0, (double)4.0, (double)2.0, (double)14.0, (double)10.0, (double)14.0);
    private static final VoxelShape CONVEX_BASE = Shapes.or((VoxelShape)FUNNEL, (VoxelShape)TOP);
    private static final VoxelShape INSIDE = SmartHopperBlock.box((double)3.0, (double)12.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    private static final VoxelShape BASE = Shapes.join((VoxelShape)CONVEX_BASE, (VoxelShape)INSIDE, (BooleanOp)BooleanOp.ONLY_FIRST);
    private static final VoxelShape DOWN_SHAPE = Shapes.or((VoxelShape)BASE, (VoxelShape)Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)4.0, (double)11.0));
    private static final VoxelShape EAST_SHAPE = Shapes.or((VoxelShape)BASE, (VoxelShape)Block.box((double)13.0, (double)4.0, (double)5.0, (double)18.0, (double)10.0, (double)11.0));
    private static final VoxelShape NORTH_SHAPE = Shapes.or((VoxelShape)BASE, (VoxelShape)Block.box((double)5.0, (double)4.0, (double)-2.0, (double)11.0, (double)10.0, (double)2.0));
    private static final VoxelShape SOUTH_SHAPE = Shapes.or((VoxelShape)BASE, (VoxelShape)Block.box((double)5.0, (double)4.0, (double)14.0, (double)11.0, (double)10.0, (double)18.0));
    private static final VoxelShape WEST_SHAPE = Shapes.or((VoxelShape)BASE, (VoxelShape)Block.box((double)-2.0, (double)4.0, (double)5.0, (double)2.0, (double)10.0, (double)11.0));
    private static final VoxelShape DOWN_INTERACTION_SHAPE = INSIDE;
    private static final VoxelShape EAST_INTERACTION_SHAPE = Shapes.or((VoxelShape)INSIDE, (VoxelShape)Block.box((double)12.0, (double)8.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0));
    private static final VoxelShape NORTH_INTERACTION_SHAPE = Shapes.or((VoxelShape)INSIDE, (VoxelShape)Block.box((double)6.0, (double)8.0, (double)0.0, (double)10.0, (double)10.0, (double)4.0));
    private static final VoxelShape SOUTH_INTERACTION_SHAPE = Shapes.or((VoxelShape)INSIDE, (VoxelShape)Block.box((double)6.0, (double)8.0, (double)12.0, (double)10.0, (double)10.0, (double)16.0));
    private static final VoxelShape WEST_INTERACTION_SHAPE = Shapes.or((VoxelShape)INSIDE, (VoxelShape)Block.box((double)0.0, (double)8.0, (double)6.0, (double)4.0, (double)10.0, (double)10.0));

    public SmartHopperBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.DOWN)).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        Direction face = context.getClickedFace();
        if (face.getAxis() != Direction.Axis.Y) {
            return InteractionResult.PASS;
        }
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockState rotated = this.getRotatedBlockState(state, face);
        if (!rotated.canSurvive((LevelReader)level, pos)) {
            return InteractionResult.PASS;
        }
        KineticBlockEntity.switchToBlockState((Level)level, (BlockPos)pos, (BlockState)this.updateAfterWrenched(rotated, context));
        if (level.getBlockState(pos) != state) {
            AllSoundEvents.WRENCH_ROTATE.playOnServer(level, (Vec3i)pos, 1.0f, level.random.nextFloat() + 0.5f);
        }
        return InteractionResult.SUCCESS;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction direction = context.getClickedFace().getOpposite();
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)(direction.getAxis() == Direction.Axis.Y ? Direction.DOWN : direction));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{POWERED, FACING});
    }

    protected void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!oldState.is(state.getBlock())) {
            this.checkPoweredState(level, pos, state);
        }
    }

    @NotNull
    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (!level.isClientSide) {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof SmartHopperBE) {
                SmartHopperBE be = (SmartHopperBE)blockEntity;
                player.openMenu((MenuProvider)be);
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        this.checkPoweredState(level, pos, state);
    }

    private void checkPoweredState(Level level, BlockPos pos, BlockState state) {
        boolean flag = level.hasNeighborSignal(pos);
        if (flag != (Boolean)state.getValue((Property)POWERED)) {
            level.setBlock(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(flag)), 2);
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof SmartHopperBE) {
                SmartHopperBE be = (SmartHopperBE)blockEntity;
                be.invVersionTracker.reset();
                be.notifyUpdate();
            }
        }
    }

    protected void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (entity instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)entity;
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof SmartHopperBE) {
                SmartHopperBE be = (SmartHopperBE)blockEntity;
                if (be.inv == null) {
                    return;
                }
                ItemStack stack = itemEntity.getItem();
                if (!stack.isEmpty() && entity.getBoundingBox().move((double)(-pos.getX()), (double)(-pos.getY()), (double)(-pos.getZ())).intersects(SUCK_AABB)) {
                    if (be.cantAcceptItem(stack, state)) {
                        return;
                    }
                    itemEntity.setItem(be.handleExtracting(stack, state));
                }
            }
        }
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        IBE.onRemove((BlockState)state, (Level)level, (BlockPos)pos, (BlockState)newState);
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    public Class<SmartHopperBE> getBlockEntityClass() {
        return SmartHopperBE.class;
    }

    public BlockEntityType<? extends SmartHopperBE> getBlockEntityType() {
        return (BlockEntityType)DesiresBETypes.SMART_HOPPER.get();
    }

    protected boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    protected int getAnalogOutputSignal(BlockState blockState, Level level, BlockPos pos) {
        int n;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof SmartHopperBE) {
            SmartHopperBE be = (SmartHopperBE)blockEntity;
            n = AbstractContainerMenu.getRedstoneSignalFromContainer((Container)be.inv);
        } else {
            n = 0;
        }
        return n;
    }

    @NotNull
    protected BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    @NotNull
    protected BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    @NotNull
    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.DOWN -> DOWN_SHAPE;
            case Direction.NORTH -> NORTH_SHAPE;
            case Direction.SOUTH -> SOUTH_SHAPE;
            case Direction.WEST -> WEST_SHAPE;
            case Direction.EAST -> EAST_SHAPE;
            default -> BASE;
        };
    }

    @NotNull
    protected VoxelShape getInteractionShape(BlockState state, BlockGetter level, BlockPos pos) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.DOWN -> DOWN_INTERACTION_SHAPE;
            case Direction.NORTH -> NORTH_INTERACTION_SHAPE;
            case Direction.SOUTH -> SOUTH_INTERACTION_SHAPE;
            case Direction.WEST -> WEST_INTERACTION_SHAPE;
            case Direction.EAST -> EAST_INTERACTION_SHAPE;
            default -> INSIDE;
        };
    }
}

