/*
 * Decompiled with CFR 0.152.
 */
package net.micaxs.smokeleaf;

import java.awt.Color;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.micaxs.smokeleaf.block.ModBlocks;
import net.micaxs.smokeleaf.block.entity.ModBlockEntities;
import net.micaxs.smokeleaf.block.entity.client.DryingRackRenderer;
import net.micaxs.smokeleaf.block.entity.render.GrowPotRenderer;
import net.micaxs.smokeleaf.client.brainmelt.BrainMeltInputHandler;
import net.micaxs.smokeleaf.component.ModDataComponentTypes;
import net.micaxs.smokeleaf.effect.ModEffects;
import net.micaxs.smokeleaf.fluid.BaseFluidType;
import net.micaxs.smokeleaf.fluid.ModFluidTypes;
import net.micaxs.smokeleaf.fluid.ModFluids;
import net.micaxs.smokeleaf.item.ModItems;
import net.micaxs.smokeleaf.item.custom.BaseBudItem;
import net.micaxs.smokeleaf.item.custom.DNAStrandItem;
import net.micaxs.smokeleaf.screen.ModMenuTypes;
import net.micaxs.smokeleaf.screen.custom.DryerScreen;
import net.micaxs.smokeleaf.screen.custom.ExtractorScreen;
import net.micaxs.smokeleaf.screen.custom.GeneratorScreen;
import net.micaxs.smokeleaf.screen.custom.GrinderScreen;
import net.micaxs.smokeleaf.screen.custom.LiquifierScreen;
import net.micaxs.smokeleaf.screen.custom.MutatorScreen;
import net.micaxs.smokeleaf.screen.custom.SequencerScreen;
import net.micaxs.smokeleaf.screen.custom.SynthesizerScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.event.RenderGuiEvent;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.client.event.ViewportEvent;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.fluids.FluidType;

@Mod(value="smokeleafindustries", dist={Dist.CLIENT})
@EventBusSubscriber(modid="smokeleafindustries", value={Dist.CLIENT})
public class SmokeleafIndustriesClient {
    private static final Set<ResourceLocation> WIGGLED = new HashSet<ResourceLocation>();
    private static final Map<ResourceLocation, WiggleSpec> WIGGLE_SPECS = new HashMap<ResourceLocation, WiggleSpec>();

    public SmokeleafIndustriesClient(ModContainer container) {
        container.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
    }

    private static boolean hasMelted(Player p) {
        return p != null && p.getEffect(ModEffects.MELTED) != null;
    }

    private static float partial(RenderGuiLayerEvent event) {
        return event.getPartialTick().getGameTimeDeltaPartialTick(false);
    }

    private static double partial(ViewportEvent.ComputeFov event) {
        return event.getPartialTick();
    }

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        NeoForge.EVENT_BUS.addListener(EventPriority.LOWEST, BrainMeltInputHandler::onInputUpdate);
        event.enqueueWork(() -> {
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)ModFluids.SOURCE_HASH_OIL_FLUID.get()), (RenderType)RenderType.translucent());
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)ModFluids.FLOWING_HASH_OIL_FLUID.get()), (RenderType)RenderType.translucent());
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)ModFluids.SOURCE_HEMP_OIL_FLUID.get()), (RenderType)RenderType.translucent());
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)ModFluids.FLOWING_HEMP_OIL_FLUID.get()), (RenderType)RenderType.translucent());
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)ModFluids.SOURCE_HASH_OIL_SLUDGE_FLUID.get()), (RenderType)RenderType.translucent());
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)ModFluids.FLOWING_HASH_OIL_SLUDGE_FLUID.get()), (RenderType)RenderType.translucent());
            ItemProperties.register((Item)((Item)ModItems.DNA_STRAND.get()), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"smokeleafindustries", (String)"full"), (stack, level, entity, seed) -> DNAStrandItem.isFull(stack) ? 1.0f : 0.0f);
            ItemProperties.register((Item)((Item)ModItems.MANUAL_GRINDER.get()), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"smokeleafindustries", (String)"filled"), (stack, level, entity, seed) -> stack.has((DataComponentType)ModDataComponentTypes.MANUAL_GRINDER_CONTENTS.get()) ? 1.0f : 0.0f);
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.REFLECTOR.get()), (RenderType)RenderType.translucent());
        });
    }

    @SubscribeEvent
    public static void registerBER(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer(ModBlockEntities.DRYING_RACK_BE.get(), DryingRackRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)ModBlockEntities.GROW_POT.get(), GrowPotRenderer::new);
    }

    @SubscribeEvent
    public static void onClientExtensions(RegisterClientExtensionsEvent event) {
        event.registerFluidType(((BaseFluidType)ModFluidTypes.HEMP_OIL_FLUID_TYPE.get()).getClientFluidTypeExtensions(), new FluidType[]{ModFluidTypes.HEMP_OIL_FLUID_TYPE.get()});
        event.registerFluidType(((BaseFluidType)ModFluidTypes.HASH_OIL_FLUID_TYPE.get()).getClientFluidTypeExtensions(), new FluidType[]{ModFluidTypes.HASH_OIL_FLUID_TYPE.get()});
        event.registerFluidType(((BaseFluidType)ModFluidTypes.HASH_OIL_SLUDGE_FLUID_TYPE.get()).getClientFluidTypeExtensions(), new FluidType[]{ModFluidTypes.HASH_OIL_SLUDGE_FLUID_TYPE.get()});
    }

    @SubscribeEvent
    public static void registerScreens(RegisterMenuScreensEvent event) {
        event.register((MenuType)ModMenuTypes.GENERATOR_MENU.get(), GeneratorScreen::new);
        event.register((MenuType)ModMenuTypes.GRINDER_MENU.get(), GrinderScreen::new);
        event.register((MenuType)ModMenuTypes.EXTRACTOR_MENU.get(), ExtractorScreen::new);
        event.register((MenuType)ModMenuTypes.LIQUIFIER_MENU.get(), LiquifierScreen::new);
        event.register((MenuType)ModMenuTypes.MUTATOR_MENU.get(), MutatorScreen::new);
        event.register((MenuType)ModMenuTypes.SYNTHESIZER_MENU.get(), SynthesizerScreen::new);
        event.register((MenuType)ModMenuTypes.SEQUENCER_MENU.get(), SequencerScreen::new);
        event.register((MenuType)ModMenuTypes.DRYER_MENU.get(), DryerScreen::new);
    }

    @SubscribeEvent
    public static void onRenderGuiLayerPre(RenderGuiLayerEvent.Pre event) {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null || !SmokeleafIndustriesClient.hasMelted((Player)player)) {
            return;
        }
        ResourceLocation id = event.getName();
        WiggleSpec spec = WIGGLE_SPECS.get(id);
        if (spec == null) {
            return;
        }
        MobEffectInstance melted = player.getEffect(ModEffects.MELTED);
        int ampLvl = melted != null ? melted.getAmplifier() : 0;
        double t = (float)player.tickCount + SmokeleafIndustriesClient.partial((RenderGuiLayerEvent)event);
        double phaseX = Math.sin(t * spec.sx());
        double phaseY = Math.sin(t * spec.sy() + 1.5707963267948966);
        double xAmp = spec.ax() + (double)ampLvl * spec.axLvl();
        double yAmp = spec.ay() + (double)ampLvl * spec.ayLvl();
        double xOffset = phaseX * xAmp * (double)(spec.ix() ? -1 : 1);
        double yOffset = phaseY * yAmp * (double)(spec.iy() ? -1 : 1);
        GuiGraphics g = event.getGuiGraphics();
        g.pose().pushPose();
        g.pose().translate(xOffset, yOffset, 0.0);
        WIGGLED.add(id);
    }

    @SubscribeEvent
    public static void onRenderGuiLayerPost(RenderGuiLayerEvent.Post event) {
        if (!WIGGLED.remove(event.getName())) {
            return;
        }
        event.getGuiGraphics().pose().popPose();
    }

    @SubscribeEvent
    public static void onRenderGui(RenderGuiEvent.Post event) {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return;
        }
        if (!player.hasEffect(ModEffects.RAINBOW)) {
            return;
        }
        GuiGraphics gg = event.getGuiGraphics();
        float t = (float)(System.currentTimeMillis() % 5000L) / 5000.0f;
        int rgb = Color.HSBtoRGB(t, 1.0f, 1.0f);
        int color = 0x50000000 | rgb & 0xFFFFFF;
        gg.fill(0, 0, mc.getWindow().getGuiScaledWidth(), mc.getWindow().getGuiScaledHeight(), color);
    }

    @SubscribeEvent
    public static void onComputeFov(ViewportEvent.ComputeFov event) {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return;
        }
        double p = SmokeleafIndustriesClient.partial(event);
        MobEffectInstance breathing = player.getEffect(ModEffects.BREATHING);
        MobEffectInstance bubbled = player.getEffect(ModEffects.BUBBLED);
        if (breathing != null) {
            float time = (float)((double)player.tickCount + p);
            int amp = breathing.getAmplifier();
            float amplitude = 0.015f + (float)amp * 0.01f;
            float speed = 0.15f + (float)amp * 0.05f;
            float wave = (float)Math.sin(time * speed) * amplitude;
            event.setFOV(event.getFOV() * (1.0 + (double)wave));
        }
        if (bubbled != null) {
            int amp = bubbled.getAmplifier();
            double boost = -0.5 + (double)amp * 0.12;
            double modified = event.getFOV() * (1.0 + boost);
            event.setFOV(Math.min(170.0, modified));
        }
    }

    @SubscribeEvent
    public static void onItemColor(RegisterColorHandlersEvent.Item event) {
        ItemColor itemColor = (stack, tintIndex) -> {
            Boolean isDry;
            if (stack.getItem() instanceof BaseBudItem && Boolean.TRUE.equals(isDry = (Boolean)stack.get(ModDataComponentTypes.DRY))) {
                return -2699581;
            }
            return -1;
        };
        event.register(itemColor, new ItemLike[]{(ItemLike)ModItems.WHITE_WIDOW_BUD.get(), (ItemLike)ModItems.BUBBLE_KUSH_BUD.get(), (ItemLike)ModItems.LEMON_HAZE_BUD.get(), (ItemLike)ModItems.SOUR_DIESEL_BUD.get(), (ItemLike)ModItems.BLUE_ICE_BUD.get(), (ItemLike)ModItems.BUBBLEGUM_BUD.get(), (ItemLike)ModItems.PURPLE_HAZE_BUD.get(), (ItemLike)ModItems.OG_KUSH_BUD.get(), (ItemLike)ModItems.JACK_HERER_BUD.get(), (ItemLike)ModItems.GARY_PEYTON_BUD.get(), (ItemLike)ModItems.AMNESIA_HAZE_BUD.get(), (ItemLike)ModItems.AK47_BUD.get(), (ItemLike)ModItems.GHOST_TRAIN_BUD.get(), (ItemLike)ModItems.GRAPE_APE_BUD.get(), (ItemLike)ModItems.COTTON_CANDY_BUD.get(), (ItemLike)ModItems.BANANA_KUSH_BUD.get(), (ItemLike)ModItems.CARBON_FIBER_BUD.get(), (ItemLike)ModItems.BIRTHDAY_CAKE_BUD.get(), (ItemLike)ModItems.BLUE_COOKIES_BUD.get(), (ItemLike)ModItems.AFGHANI_BUD.get(), (ItemLike)ModItems.MOONBOW_BUD.get(), (ItemLike)ModItems.LAVA_CAKE_BUD.get(), (ItemLike)ModItems.JELLY_RANCHER_BUD.get(), (ItemLike)ModItems.STRAWBERRY_SHORTCAKE_BUD.get(), (ItemLike)ModItems.PINK_KUSH_BUD.get()});
    }

    static {
        WIGGLE_SPECS.put(VanillaGuiLayers.HOTBAR, new WiggleSpec(0.1, 3.0, 1.5, false, 0.18, 1.4, 0.6, false));
        WIGGLE_SPECS.put(VanillaGuiLayers.PLAYER_HEALTH, new WiggleSpec(0.13, 3.0, 1.5, true, 0.22, 1.8, 0.7, false));
        WIGGLE_SPECS.put(VanillaGuiLayers.FOOD_LEVEL, new WiggleSpec(0.17, 2.5, 1.2, false, 0.25, 1.2, 0.5, true));
        WIGGLE_SPECS.put(VanillaGuiLayers.CHAT, new WiggleSpec(0.21, 4.0, 1.0, false, 0.07, 6.0, 1.5, false));
        WIGGLE_SPECS.put(VanillaGuiLayers.TAB_LIST, new WiggleSpec(0.15, 5.0, 2.0, true, 0.11, 3.5, 1.2, true));
        WIGGLE_SPECS.put(VanillaGuiLayers.CROSSHAIR, new WiggleSpec(0.11, 2.0, 1.0, false, 0.19, 2.2, 0.8, false));
        WIGGLE_SPECS.put(VanillaGuiLayers.EFFECTS, new WiggleSpec(0.19, 2.0, 1.0, false, 0.16, 1.6, 0.6, false));
        WIGGLE_SPECS.put(VanillaGuiLayers.EXPERIENCE_BAR, new WiggleSpec(0.19, 2.0, 1.0, false, 0.27, 1.0, 0.4, true));
        WIGGLE_SPECS.put(VanillaGuiLayers.EXPERIENCE_LEVEL, new WiggleSpec(0.11, 2.0, 1.0, false, 0.31, 0.8, 0.3, false));
        WIGGLE_SPECS.put(VanillaGuiLayers.SELECTED_ITEM_NAME, new WiggleSpec(0.08, 2.0, 1.0, false, 0.24, 1.3, 0.5, true));
    }

    private record WiggleSpec(double sx, double ax, double axLvl, boolean ix, double sy, double ay, double ayLvl, boolean iy) {
    }
}

