/*
 * Decompiled with CFR 0.152.
 */
package net.micaxs.smokeleaf.block.custom;

import com.mojang.serialization.MapCodec;
import net.micaxs.smokeleaf.block.entity.ModBlockEntities;
import net.micaxs.smokeleaf.block.entity.ReflectorBlockEntity;
import net.micaxs.smokeleaf.item.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ReflectorBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty HAS_LAMP = BooleanProperty.create((String)"has_lamp");

    public ReflectorBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)HAS_LAMP, (Comparable)Boolean.valueOf(false)));
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        return (Boolean)state.getValue((Property)HAS_LAMP) != false ? 15 : 0;
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return null;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Block.box((double)0.0, (double)11.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return !level.getBlockState(pos.above()).isAir();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, HAS_LAMP});
    }

    protected BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection().getOpposite())).setValue((Property)HAS_LAMP, (Comparable)Boolean.valueOf(false));
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity be;
        if (level.isClientSide) {
            return ItemInteractionResult.SUCCESS;
        }
        if (!((Boolean)state.getValue((Property)HAS_LAMP)).booleanValue() && (stack.is((Item)ModItems.HPS_LAMP.get()) || stack.is((Item)ModItems.DUAL_ARC_LAMP.get())) && (be = level.getBlockEntity(pos)) instanceof ReflectorBlockEntity) {
            ReflectorBlockEntity reflector = (ReflectorBlockEntity)be;
            reflector.setLamp(stack.copyWithCount(1));
            level.setBlock(pos, (BlockState)state.setValue((Property)HAS_LAMP, (Comparable)Boolean.valueOf(true)), 3);
            if (!player.isCreative()) {
                stack.shrink(1);
            }
            reflector.setChanged();
            return ItemInteractionResult.CONSUME;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        boolean added;
        if (level.isClientSide) {
            return (Boolean)state.getValue((Property)HAS_LAMP) != false && player.getMainHandItem().isEmpty() ? InteractionResult.SUCCESS : InteractionResult.PASS;
        }
        if (!player.getMainHandItem().isEmpty()) {
            return InteractionResult.PASS;
        }
        BlockEntity be = level.getBlockEntity(pos);
        if (!(be instanceof ReflectorBlockEntity)) {
            return InteractionResult.PASS;
        }
        ReflectorBlockEntity reflector = (ReflectorBlockEntity)be;
        if (reflector.getLamp().isEmpty()) {
            return InteractionResult.PASS;
        }
        ItemStack stack = reflector.extractLamp();
        if (!stack.isEmpty() && !(added = player.addItem(stack))) {
            player.drop(stack, false);
        }
        return InteractionResult.CONSUME;
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity be;
        if (state.getBlock() != newState.getBlock() && (be = level.getBlockEntity(pos)) instanceof ReflectorBlockEntity) {
            ReflectorBlockEntity reflector = (ReflectorBlockEntity)be;
            reflector.dropContents();
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new ReflectorBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return level.isClientSide ? null : ReflectorBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)ModBlockEntities.REFLECTOR.get()), ReflectorBlockEntity::serverTick);
    }
}

