/*
 * Decompiled with CFR 0.152.
 */
package net.micaxs.smokeleaf.block.entity;

import java.util.Optional;
import net.micaxs.smokeleaf.Config;
import net.micaxs.smokeleaf.block.entity.ModBlockEntities;
import net.micaxs.smokeleaf.component.ModDataComponentTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaseWeedCropBlockEntity
extends BlockEntity {
    private static final int MAX_PERCENT = 100;
    private static final int MAX_PH = 14;
    private static final int NPK_TOLERANCE = 3;
    private int thc;
    private int cbd;
    private int ph;
    private int nitrogen;
    private int phosphorus;
    private int potassium;

    public BaseWeedCropBlockEntity(BlockPos pos, BlockState blockState) {
        super(ModBlockEntities.BASE_WEED_CROP_BE.get(), pos, blockState);
    }

    public int getPh() {
        return this.ph;
    }

    public int getNitrogen() {
        return this.nitrogen;
    }

    public int getPhosphorus() {
        return this.phosphorus;
    }

    public int getPotassium() {
        return this.potassium;
    }

    public void setThc(int v) {
        this.thc = Mth.clamp((int)v, (int)0, (int)100);
    }

    public void setCbd(int v) {
        this.cbd = Mth.clamp((int)v, (int)0, (int)100);
    }

    public void setPh(int v) {
        this.ph = Mth.clamp((int)v, (int)0, (int)14);
    }

    public void setNitrogen(int v) {
        this.nitrogen = Mth.clamp((int)v, (int)0, (int)100);
    }

    public void setPhosphorus(int v) {
        this.phosphorus = Mth.clamp((int)v, (int)0, (int)100);
    }

    public void setPotassium(int v) {
        this.potassium = Mth.clamp((int)v, (int)0, (int)100);
    }

    public void addThc(int d) {
        this.setThc(this.thc + d);
    }

    public void addCbd(int d) {
        this.setCbd(this.cbd + d);
    }

    public void addPh(int d) {
        this.setPh(this.ph + d);
    }

    public void addNitrogen(int d) {
        this.setNitrogen(this.nitrogen + d);
    }

    public void addPhosphorus(int d) {
        this.setPhosphorus(this.phosphorus + d);
    }

    public void addPotassium(int d) {
        this.setPotassium(this.potassium + d);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putInt("thc", this.thc);
        tag.putInt("cbd", this.cbd);
        tag.putInt("ph", this.ph);
        tag.putInt("nitrogen", this.nitrogen);
        tag.putInt("phosphorus", this.phosphorus);
        tag.putInt("potassium", this.potassium);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.thc = tag.getInt("thc");
        this.cbd = tag.getInt("cbd");
        this.ph = tag.getInt("ph");
        this.nitrogen = tag.getInt("nitrogen");
        this.phosphorus = tag.getInt("phosphorus");
        this.potassium = tag.getInt("potassium");
    }

    private ResourceLocation getCropId() {
        if (this.level == null) {
            return null;
        }
        return BuiltInRegistries.BLOCK.getKey((Object)this.getBlockState().getBlock());
    }

    public boolean isValidNutrientsLevels() {
        ResourceLocation cropId = this.getCropId();
        Optional<Config.NutrientTarget> targetOpt = Config.getNutrientTargetFor(cropId);
        if (targetOpt.isEmpty()) {
            return true;
        }
        Config.NutrientTarget t = targetOpt.get();
        boolean nOk = Math.abs(this.nitrogen - t.n) <= 3;
        boolean pOk = Math.abs(this.phosphorus - t.p) <= 3;
        boolean kOk = Math.abs(this.potassium - t.k) <= 3;
        return nOk && pOk && kOk;
    }

    public Config.NutrientTarget getOptimalNutrientsLevels() {
        ResourceLocation cropId = this.getCropId();
        Optional<Config.NutrientTarget> targetOpt = Config.getNutrientTargetFor(cropId);
        return targetOpt.orElseGet(() -> new Config.NutrientTarget(0, 0, 0));
    }

    public int getThc() {
        return this.computeWithNutrients(this.thc);
    }

    public int getCbd() {
        return this.computeWithNutrients(this.cbd);
    }

    public int getBudCount() {
        ResourceLocation cropId = this.getCropId();
        Optional<Config.NutrientTarget> targetOpt = Config.getNutrientTargetFor(cropId);
        if (targetOpt.isEmpty()) {
            return 1;
        }
        Config.NutrientTarget t = targetOpt.get();
        int dn = Math.abs(this.nitrogen - t.n);
        int dp = Math.abs(this.phosphorus - t.p);
        int dk = Math.abs(this.potassium - t.k);
        if (dn == 0 && dp == 0 && dk == 0) {
            return 3;
        }
        int offCount = 0;
        if (dn > 3) {
            ++offCount;
        }
        if (dp > 3) {
            ++offCount;
        }
        if (dk > 3) {
            ++offCount;
        }
        if (offCount == 0) {
            return 2;
        }
        return 1;
    }

    private int computeWithNutrients(int base) {
        ResourceLocation cropId = this.getCropId();
        Optional<Config.NutrientTarget> targetOpt = Config.getNutrientTargetFor(cropId);
        if (targetOpt.isEmpty()) {
            return base;
        }
        Config.NutrientTarget t = targetOpt.get();
        int dn = Math.abs(this.nitrogen - t.n);
        int dp = Math.abs(this.phosphorus - t.p);
        int dk = Math.abs(this.potassium - t.k);
        if (dn == 0 && dp == 0 && dk == 0) {
            return Mth.clamp((int)(base * 2), (int)0, (int)100);
        }
        int totalDiff = dn + dp + dk;
        int reduction = (int)Math.round((double)base * 0.1 * (double)totalDiff);
        int value = base - reduction;
        return Mth.clamp((int)value, (int)0, (int)100);
    }

    public void writeToItem(ItemStack stack) {
        stack.set((DataComponentType)ModDataComponentTypes.THC.get(), (Object)this.thc);
        stack.set((DataComponentType)ModDataComponentTypes.CBD.get(), (Object)this.cbd);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @NotNull
    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider lookupProvider) {
        super.onDataPacket(net, pkt, lookupProvider);
    }

    public void sync() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            this.setChanged();
            server.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }
}

