/*
 * Decompiled with CFR 0.152.
 */
package net.micaxs.smokeleaf.compat;

import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.micaxs.smokeleaf.block.ModBlocks;
import net.micaxs.smokeleaf.compat.jei.BluntRecipeCategory;
import net.micaxs.smokeleaf.compat.jei.DryingRecipeCategory;
import net.micaxs.smokeleaf.compat.jei.ExtractorRecipeCategory;
import net.micaxs.smokeleaf.compat.jei.GeneratorRecipeCategory;
import net.micaxs.smokeleaf.compat.jei.GrinderRecipeCategory;
import net.micaxs.smokeleaf.compat.jei.JointRecipeCategory;
import net.micaxs.smokeleaf.compat.jei.LiquifierRecipeCategory;
import net.micaxs.smokeleaf.compat.jei.ManualGrinderRecipeCategory;
import net.micaxs.smokeleaf.compat.jei.MutatorRecipeCategory;
import net.micaxs.smokeleaf.compat.jei.SequencerRecipeCategory;
import net.micaxs.smokeleaf.compat.jei.SynthesizerRecipeCategory;
import net.micaxs.smokeleaf.item.ModItems;
import net.micaxs.smokeleaf.recipe.BluntRecipe;
import net.micaxs.smokeleaf.recipe.DryingRecipe;
import net.micaxs.smokeleaf.recipe.ExtractorRecipe;
import net.micaxs.smokeleaf.recipe.GeneratorRecipe;
import net.micaxs.smokeleaf.recipe.GrinderRecipe;
import net.micaxs.smokeleaf.recipe.JointRecipe;
import net.micaxs.smokeleaf.recipe.LiquifierRecipe;
import net.micaxs.smokeleaf.recipe.ManualGrinderRecipe;
import net.micaxs.smokeleaf.recipe.ModRecipes;
import net.micaxs.smokeleaf.recipe.MutatorRecipe;
import net.micaxs.smokeleaf.recipe.SequencerRecipe;
import net.micaxs.smokeleaf.recipe.SynthesizerRecipe;
import net.micaxs.smokeleaf.screen.custom.ExtractorScreen;
import net.micaxs.smokeleaf.screen.custom.GeneratorScreen;
import net.micaxs.smokeleaf.screen.custom.GrinderScreen;
import net.micaxs.smokeleaf.screen.custom.LiquifierScreen;
import net.micaxs.smokeleaf.screen.custom.MutatorScreen;
import net.micaxs.smokeleaf.screen.custom.SequencerScreen;
import net.micaxs.smokeleaf.screen.custom.SynthesizerScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;

@JeiPlugin
public class JEISmokeleafInudstriesPlugin
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return ResourceLocation.fromNamespaceAndPath((String)"smokeleafindustries", (String)"jei_plugin");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper guiHelper = registration.getJeiHelpers().getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new ExtractorRecipeCategory(guiHelper), new GeneratorRecipeCategory(guiHelper), new LiquifierRecipeCategory(guiHelper), new GrinderRecipeCategory(guiHelper), new DryingRecipeCategory(guiHelper), new MutatorRecipeCategory(guiHelper), new SequencerRecipeCategory(guiHelper), new SynthesizerRecipeCategory(guiHelper), new ManualGrinderRecipeCategory(guiHelper), new JointRecipeCategory(guiHelper), new BluntRecipeCategory(guiHelper)});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null) {
            return;
        }
        RecipeManager recipeManager = mc.level.getRecipeManager();
        List<ExtractorRecipe> extractorRecipes = recipeManager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)ModRecipes.EXTRACTOR_TYPE.get()).stream().map(RecipeHolder::value).toList();
        registration.addRecipes(ExtractorRecipeCategory.EXTRACTOR_RECIPE_RECIPE_TYPE, extractorRecipes);
        List<GeneratorRecipe> generatorRecipes = recipeManager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)ModRecipes.GENERATOR_TYPE.get()).stream().map(RecipeHolder::value).toList();
        registration.addRecipes(GeneratorRecipeCategory.GENERATOR_RECIPE_TYPE, generatorRecipes);
        List<LiquifierRecipe> liquifierRecipes = recipeManager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)ModRecipes.LIQUIFIER_TYPE.get()).stream().map(RecipeHolder::value).toList();
        registration.addRecipes(LiquifierRecipeCategory.LIQUIFIER_RECIPE_TYPE, liquifierRecipes);
        List<GrinderRecipe> grinderRecipes = recipeManager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)ModRecipes.GRINDER_TYPE.get()).stream().map(RecipeHolder::value).toList();
        registration.addRecipes(GrinderRecipeCategory.GRINDER_RECIPE_TYPE, grinderRecipes);
        List<DryingRecipe> dryingRecipes = recipeManager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)ModRecipes.DRYING_TYPE.get()).stream().map(RecipeHolder::value).toList();
        registration.addRecipes(DryingRecipeCategory.DRYING_RECIPE_TYPE, dryingRecipes);
        List<MutatorRecipe> mutatorRecipes = recipeManager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)ModRecipes.MUTATOR_TYPE.get()).stream().map(RecipeHolder::value).toList();
        registration.addRecipes(MutatorRecipeCategory.MUTATOR_RECIPE_TYPE, mutatorRecipes);
        List<SequencerRecipe> sequencerRecipes = recipeManager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)ModRecipes.SEQUENCER_TYPE.get()).stream().map(RecipeHolder::value).toList();
        registration.addRecipes(SequencerRecipeCategory.SEQUENCER_RECIPE_TYPE, sequencerRecipes);
        List<SynthesizerRecipe> synthesizer = recipeManager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)ModRecipes.SYNTHESIZER_TYPE.get()).stream().map(RecipeHolder::value).toList();
        List synthDisplays = synthesizer.stream().flatMap(r -> SynthesizerRecipeCategory.buildValidStrainDisplays(r, sequencerRecipes).stream()).toList();
        registration.addRecipes(SynthesizerRecipeCategory.SYNTHESIZER_RECIPE_TYPE, synthDisplays);
        List<ManualGrinderRecipe> manualGrinderRecipes = recipeManager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)ModRecipes.MANUAL_GRINDER_TYPE.get()).stream().map(RecipeHolder::value).toList();
        registration.addRecipes(ManualGrinderRecipeCategory.RECIPE_TYPE, manualGrinderRecipes);
        List<JointRecipe> jointRecipes = recipeManager.getAllRecipesFor(net.minecraft.world.item.crafting.RecipeType.CRAFTING).stream().map(RecipeHolder::value).filter(r -> r.getSerializer() == ModRecipes.JOINT_SERIALIZER.get()).map(r -> (JointRecipe)((Object)r)).toList();
        registration.addRecipes(JointRecipeCategory.JOINT_RECIPE_TYPE, jointRecipes);
        List<BluntRecipe> bluntRecipes = recipeManager.getAllRecipesFor(net.minecraft.world.item.crafting.RecipeType.CRAFTING).stream().map(RecipeHolder::value).filter(BluntRecipe.class::isInstance).map(BluntRecipe.class::cast).toList();
        registration.addRecipes(BluntRecipeCategory.BLUNT_RECIPE_TYPE, bluntRecipes);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModItems.MANUAL_GRINDER.get()), new RecipeType[]{ManualGrinderRecipeCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.DRYING_RACK.get()), new RecipeType[]{DryingRecipeCategory.DRYING_RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.EXTRACTOR.get()), new RecipeType[]{ExtractorRecipeCategory.EXTRACTOR_RECIPE_RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.GENERATOR.get()), new RecipeType[]{GeneratorRecipeCategory.GENERATOR_RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.LIQUIFIER.get()), new RecipeType[]{LiquifierRecipeCategory.LIQUIFIER_RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.GRINDER.get()), new RecipeType[]{GrinderRecipeCategory.GRINDER_RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.MUTATOR.get()), new RecipeType[]{MutatorRecipeCategory.MUTATOR_RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.SEQUENCER.get()), new RecipeType[]{SequencerRecipeCategory.SEQUENCER_RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.SYNTHESIZER.get()), new RecipeType[]{SynthesizerRecipeCategory.SYNTHESIZER_RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)Items.CRAFTING_TABLE), new RecipeType[]{JointRecipeCategory.JOINT_RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)Items.CRAFTING_TABLE), new RecipeType[]{BluntRecipeCategory.BLUNT_RECIPE_TYPE});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(ExtractorScreen.class, 80, 30, 20, 30, new RecipeType[]{ExtractorRecipeCategory.EXTRACTOR_RECIPE_RECIPE_TYPE});
        registration.addRecipeClickArea(GeneratorScreen.class, 80, 25, 20, 30, new RecipeType[]{GeneratorRecipeCategory.GENERATOR_RECIPE_TYPE});
        registration.addRecipeClickArea(LiquifierScreen.class, 59, 35, 54, 16, new RecipeType[]{LiquifierRecipeCategory.LIQUIFIER_RECIPE_TYPE});
        registration.addRecipeClickArea(GrinderScreen.class, 84, 30, 8, 26, new RecipeType[]{GrinderRecipeCategory.GRINDER_RECIPE_TYPE});
        registration.addRecipeClickArea(MutatorScreen.class, 102, 37, 8, 18, new RecipeType[]{MutatorRecipeCategory.MUTATOR_RECIPE_TYPE});
        registration.addRecipeClickArea(SequencerScreen.class, 62, 33, 37, 16, new RecipeType[]{SequencerRecipeCategory.SEQUENCER_RECIPE_TYPE});
        registration.addRecipeClickArea(SynthesizerScreen.class, 130, 30, 8, 26, new RecipeType[]{SynthesizerRecipeCategory.SYNTHESIZER_RECIPE_TYPE});
    }
}

