/*
 * Decompiled with CFR 0.152.
 */
package net.micaxs.smokeleaf.compat.jade;

import net.micaxs.smokeleaf.block.entity.ReflectorBlockEntity;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

public enum ReflectorProvider implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor>
{
    INSTANCE;

    private static final ResourceLocation UID;

    public ResourceLocation getUid() {
        return UID;
    }

    public void appendServerData(CompoundTag tag, BlockAccessor accessor) {
        BlockEntity blockEntity = accessor.getBlockEntity();
        if (!(blockEntity instanceof ReflectorBlockEntity)) {
            return;
        }
        ReflectorBlockEntity be = (ReflectorBlockEntity)blockEntity;
        ItemStack lamp = be.getLampStack();
        boolean hasLamp = lamp != null && !lamp.isEmpty();
        tag.putBoolean("hasLamp", hasLamp);
        if (hasLamp) {
            ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)lamp.getItem());
            if (id != null) {
                tag.putString("lampId", id.toString());
            }
            int remTicks = be.getLampRemainingTicks();
            int remSec = (remTicks + 19) / 20;
            tag.putInt("remSec", Math.max(0, remSec));
        }
    }

    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        ResourceLocation id;
        CompoundTag data = accessor.getServerData();
        boolean hasLamp = data.getBoolean("hasLamp");
        if (!hasLamp) {
            tooltip.add((Component)Component.literal((String)"Lamp: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)"None").withStyle(ChatFormatting.DARK_GRAY)));
            return;
        }
        Item item = null;
        if (data.contains("lampId") && (id = ResourceLocation.tryParse((String)data.getString("lampId"))) != null) {
            item = (Item)BuiltInRegistries.ITEM.get(id);
        }
        MutableComponent lampName = item != null ? Component.translatable((String)item.getDescriptionId()).withStyle(ChatFormatting.WHITE) : Component.literal((String)"Unknown").withStyle(ChatFormatting.DARK_GRAY);
        tooltip.add((Component)Component.literal((String)"Lamp: ").withStyle(ChatFormatting.GRAY).append((Component)lampName));
        int sec = data.getInt("remSec");
        tooltip.add((Component)Component.literal((String)"Time Left: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)ReflectorProvider.formatMMSS(sec)).withStyle(ChatFormatting.WHITE)));
    }

    private static String formatMMSS(int totalSeconds) {
        int m = Math.max(0, totalSeconds) / 60;
        int s = Math.max(0, totalSeconds) % 60;
        return String.format("%02d:%02d", m, s);
    }

    static {
        UID = ResourceLocation.fromNamespaceAndPath((String)"smokeleafindustries", (String)"reflector");
    }
}

