/*
 * Decompiled with CFR 0.152.
 */
package net.micaxs.smokeleaf.compat.jei;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.micaxs.smokeleaf.block.ModBlocks;
import net.micaxs.smokeleaf.component.ModDataComponentTypes;
import net.micaxs.smokeleaf.item.custom.BaseBudItem;
import net.micaxs.smokeleaf.recipe.DryingRecipe;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class DryingRecipeCategory
implements IRecipeCategory<DryingRecipe> {
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"smokeleafindustries", (String)"drying");
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"smokeleafindustries", (String)"textures/gui/jei_bg.png");
    public static final RecipeType<DryingRecipe> DRYING_RECIPE_TYPE = new RecipeType(UID, DryingRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;

    public DryingRecipeCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 0, 0, 110, 50);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.DRYING_RACK.get()));
    }

    public RecipeType<DryingRecipe> getRecipeType() {
        return DRYING_RECIPE_TYPE;
    }

    public Component getTitle() {
        return Component.translatable((String)"block.smokeleafindustries.drying_rack");
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, DryingRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 10, 16).addIngredients((Ingredient)recipe.getIngredients().getFirst());
        ItemStack result = recipe.result();
        if (!result.isEmpty()) {
            builder.addSlot(RecipeIngredientRole.OUTPUT, 80, 16).addItemStack(result.copy());
            return;
        }
        ItemStack focusedInput = focuses.getFocuses((IIngredientType)VanillaTypes.ITEM_STACK).filter(f -> f.getRole() == RecipeIngredientRole.INPUT).map(f -> {
            try {
                Method m = f.getClass().getMethod("getIngredient", new Class[0]);
                Object v = m.invoke(f, new Object[0]);
                if (v instanceof ItemStack) {
                    ItemStack s = (ItemStack)v;
                    return s;
                }
            }
            catch (Exception m) {
                // empty catch block
            }
            try {
                Method m2;
                Object v2;
                Object tv = f.getClass().getMethod("getTypedValue", new Class[0]).invoke(f, new Object[0]);
                if (tv != null && (v2 = (m2 = tv.getClass().getMethod("getIngredient", new Class[0])).invoke(tv, new Object[0])) instanceof ItemStack) {
                    ItemStack s2 = (ItemStack)v2;
                    return s2;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return ItemStack.EMPTY;
        }).filter(s -> !s.isEmpty()).findFirst().orElse(ItemStack.EMPTY);
        if (!focusedInput.isEmpty() && focusedInput.getItem() instanceof BaseBudItem) {
            ItemStack dried = focusedInput.copy();
            dried.set((DataComponentType)ModDataComponentTypes.DRY.get(), (Object)Boolean.TRUE);
            builder.addSlot(RecipeIngredientRole.OUTPUT, 80, 16).addItemStack(dried);
        } else {
            List driedVariants = Arrays.stream(recipe.ingredient().getItems()).filter(s -> s.getItem() instanceof BaseBudItem).map(s -> {
                ItemStack dried = s.copy();
                dried.set((DataComponentType)ModDataComponentTypes.DRY.get(), (Object)Boolean.TRUE);
                return dried;
            }).collect(Collectors.toList());
            builder.addSlot(RecipeIngredientRole.OUTPUT, 80, 16).addItemStacks(driedVariants);
        }
    }

    public void draw(DryingRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.background.draw(guiGraphics);
        int ticks = recipe.time();
        String timeStr = ticks + " ticks";
        Minecraft mc = Minecraft.getInstance();
        guiGraphics.drawString(mc.font, (Component)Component.translatable((String)"jei.smokeleafindustries.drying.time", (Object[])new Object[]{timeStr}), 30, 20, 0xB8B8B8, false);
    }

    public int getWidth() {
        return 110;
    }

    public int getHeight() {
        return 50;
    }
}

