/*
 * Decompiled with CFR 0.152.
 */
package net.micaxs.smokeleaf.compat.jei;

import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.neoforge.NeoForgeTypes;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.micaxs.smokeleaf.block.ModBlocks;
import net.micaxs.smokeleaf.recipe.LiquifierRecipe;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import org.jetbrains.annotations.Nullable;

public class LiquifierRecipeCategory
implements IRecipeCategory<LiquifierRecipe> {
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"smokeleafindustries", (String)"liquifier");
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"smokeleafindustries", (String)"textures/gui/liquifier/liquifier_gui.png");
    public static final RecipeType<LiquifierRecipe> LIQUIFIER_RECIPE_TYPE = new RecipeType(UID, LiquifierRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;
    private static final int TANK_X = 129;
    private static final int TANK_Y = 6;
    private static final int TANK_WIDTH = 16;
    private static final int TANK_HEIGHT = 64;
    private static final int TANK_CAPACITY = 8000;
    private static final int BUCKET_X = 109;
    private static final int BUCKET_Y = 54;

    public LiquifierRecipeCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 5, 5, 168, 75);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.LIQUIFIER.get()));
    }

    public RecipeType<LiquifierRecipe> getRecipeType() {
        return LIQUIFIER_RECIPE_TYPE;
    }

    public Component getTitle() {
        return Component.translatable((String)"block.smokeleafindustries.liquifier");
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, LiquifierRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 25, 30).addIngredients((Ingredient)recipe.getIngredients().getFirst());
        int capacityForRender = 8000;
        builder.addSlot(RecipeIngredientRole.OUTPUT, 129, 6).setFluidRenderer((long)capacityForRender, false, 16, 64).addIngredient((IIngredientType)NeoForgeTypes.FLUID_STACK, (Object)recipe.outputCopy());
        ItemStack filledBucket = FluidUtil.getFilledBucket((FluidStack)recipe.outputCopy());
        if (!filledBucket.isEmpty()) {
            IRecipeSlotBuilder bucket = (IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 109, 54).addItemStack(filledBucket);
            bucket.addRichTooltipCallback((slotView, tooltip) -> tooltip.add((FormattedText)Component.translatable((String)"jei.smokeleafindustries.bucket_use")));
        }
    }

    public void draw(LiquifierRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.background.draw(guiGraphics);
    }

    public int getWidth() {
        return 168;
    }

    public int getHeight() {
        return 75;
    }
}

