/*
 * Decompiled with CFR 0.152.
 */
package net.micaxs.smokeleaf.effect.beneficial;

import java.util.List;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class StickyIckyEffect
extends MobEffect {
    private static final int SELF_DROP_DELAY_TICKS = 12;
    private static final double SELF_DROP_DISTANCE_SQR = 9.0;

    public StickyIckyEffect(MobEffectCategory category, int color) {
        super(category, color);
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }

    public boolean applyEffectTick(LivingEntity entity, int amplifier) {
        if (!(entity instanceof Player)) {
            return true;
        }
        Player player = (Player)entity;
        Level level = player.level();
        if (level.isClientSide) {
            return true;
        }
        double radius = 4.0 + (double)(amplifier + 1) * 1.5;
        AABB range = player.getBoundingBox().inflate(radius);
        List items = level.getEntitiesOfClass(ItemEntity.class, range, it -> it.isAlive() && !it.getItem().isEmpty());
        for (ItemEntity item : items) {
            int age = item.getAge();
            if (age < 12 && item.distanceToSqr((Entity)player) < 9.0) {
                int remaining = 12 - age;
                if (remaining <= 0 || item.hasPickUpDelay()) continue;
                item.setPickUpDelay(remaining);
                continue;
            }
            if (item.hasPickUpDelay()) continue;
            Vec3 target = player.position().add(0.0, (double)player.getBbHeight() * 0.5, 0.0);
            Vec3 delta = target.subtract(item.position());
            double strength = 0.1 + 0.05 * (double)(amplifier + 1);
            Vec3 pull = delta.normalize().scale(Math.min(delta.length(), 1.0) * strength);
            item.setDeltaMovement(item.getDeltaMovement().add(pull));
            item.hasImpulse = true;
        }
        return true;
    }
}

