/*
 * Decompiled with CFR 0.152.
 */
package net.micaxs.smokeleaf.event;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import net.micaxs.smokeleaf.component.ManualGrinderContents;
import net.micaxs.smokeleaf.component.ModDataComponentTypes;
import net.micaxs.smokeleaf.effect.ModEffects;
import net.micaxs.smokeleaf.fluid.ModFluids;
import net.micaxs.smokeleaf.item.ModItems;
import net.micaxs.smokeleaf.item.custom.ManualGrinderItem;
import net.micaxs.smokeleaf.utils.ModTags;
import net.micaxs.smokeleaf.utils.WeedDataUtil;
import net.micaxs.smokeleaf.villager.ModVillagers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.event.village.VillagerTradesEvent;

@EventBusSubscriber(modid="smokeleafindustries")
public class CommonEvents {
    private static final String TAG_LAST_TIME = "SmokeleafIndustriesLastUrineCollect";
    private static final long COOLDOWN_TICKS = 6000L;
    private static final int CHILL_RADIUS = 16;
    private static final int VACUUM_RADIUS = 12;
    private static final int MAX_VEIN = 128;
    private static final int MAX_TREE = 1024;
    private static final int SELF_DROP_GRACE_TICKS = 50;
    private static final double SELF_DROP_NEAR_SQR = 9.0;

    @SubscribeEvent
    public static void onCatInteract(PlayerInteractEvent.EntityInteract event) {
        ItemStack result;
        long last;
        Entity entity = event.getTarget();
        if (!(entity instanceof Cat)) {
            return;
        }
        Cat cat = (Cat)entity;
        Player player = event.getEntity();
        Level level = player.level();
        ItemStack held = player.getItemInHand(event.getHand());
        if (!held.is(Items.GLASS_BOTTLE)) {
            return;
        }
        if (level.isClientSide()) {
            return;
        }
        long now = level.getGameTime();
        if (now - (last = cat.getPersistentData().getLong(TAG_LAST_TIME)) < 6000L) {
            long remaining = 6000L - (now - last);
            long seconds = remaining / 20L;
            player.displayClientMessage((Component)Component.translatable((String)"message.smokeleafindustries.cat_urine_cooldown", (Object[])new Object[]{seconds}), true);
            return;
        }
        cat.getPersistentData().putLong(TAG_LAST_TIME, now);
        if (!player.isCreative()) {
            held.shrink(1);
        }
        if (!player.addItem(result = new ItemStack((ItemLike)ModItems.CAT_URINE_BOTTLE.get()))) {
            player.drop(result, false);
        }
        level.playSound(null, cat.blockPosition(), SoundEvents.BOTTLE_FILL, SoundSource.PLAYERS, 1.0f, 1.0f);
        event.setCancellationResult(InteractionResult.SUCCESS);
        event.setCanceled(true);
    }

    @SubscribeEvent
    public static void onHighFlyerAdded(MobEffectEvent.Added event) {
        MobEffectInstance inst = event.getEffectInstance();
        if (inst == null || inst.getEffect() != ModEffects.HIGH_FLYER) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)livingEntity;
            sp.getAbilities().mayfly = true;
            sp.onUpdateAbilities();
        }
    }

    @SubscribeEvent
    public static void onHighFlyerExpired(MobEffectEvent.Expired event) {
        CommonEvents.handleHighFlyerEnd(event.getEntity(), event.getEffectInstance());
    }

    @SubscribeEvent
    public static void onHighFlyerRemoved(MobEffectEvent.Remove event) {
        CommonEvents.handleHighFlyerEnd(event.getEntity(), event.getEffectInstance());
    }

    private static void handleHighFlyerEnd(LivingEntity entity, MobEffectInstance inst) {
        double value;
        if (inst == null || inst.getEffect() != ModEffects.HIGH_FLYER) {
            return;
        }
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sp = (ServerPlayer)entity;
        AttributeInstance flightAttr = sp.getAttribute(NeoForgeMod.CREATIVE_FLIGHT);
        double d = value = flightAttr != null ? flightAttr.getValue() : 0.0;
        if (value <= 0.0 && !sp.getAbilities().instabuild) {
            sp.getAbilities().mayfly = false;
            sp.getAbilities().flying = false;
            sp.onUpdateAbilities();
        }
    }

    @SubscribeEvent
    public static void onManualGrinderCraft(PlayerEvent.ItemCraftedEvent event) {
        ItemStack result = event.getCrafting();
        if (!(result.getItem() instanceof ManualGrinderItem)) {
            return;
        }
        if (result.has((DataComponentType)ModDataComponentTypes.MANUAL_GRINDER_CONTENTS.get())) {
            return;
        }
        Container inv = event.getInventory();
        ItemStack candidate = ItemStack.EMPTY;
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            ItemStack slot = inv.getItem(i);
            if (slot.isEmpty() || slot.getItem() instanceof ManualGrinderItem) continue;
            candidate = slot.copyWithCount(1);
            break;
        }
        if (!candidate.isEmpty()) {
            result.set((DataComponentType)ModDataComponentTypes.MANUAL_GRINDER_CONTENTS.get(), (Object)ManualGrinderContents.fromStack(candidate));
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        AABB box;
        Player player = event.getEntity();
        Level lvl = player.level();
        if (lvl.isClientSide) {
            return;
        }
        ServerLevel level = (ServerLevel)lvl;
        if (player.hasEffect(ModEffects.CHILLOUT)) {
            box = player.getBoundingBox().inflate(16.0);
            for (LivingEntity le : level.getEntitiesOfClass(LivingEntity.class, box)) {
                if (!(le instanceof Zombie)) continue;
                Zombie zombie = (Zombie)le;
                if (zombie.getTarget() != null) {
                    zombie.setTarget(null);
                }
                if (zombie.getLastHurtByMob() != null) {
                    zombie.setLastHurtByMob(null);
                }
                level.sendParticles((ParticleOptions)ParticleTypes.SMOKE, zombie.getX(), zombie.getY() + 1.0, zombie.getZ(), 2, 0.2, 0.2, 0.2, 0.01);
            }
        }
        if (player.hasEffect(ModEffects.ZOMBIFIED)) {
            box = player.getBoundingBox().inflate(24.0);
            for (Monster mob : level.getEntitiesOfClass(Monster.class, box)) {
                if (!(mob.getTarget() instanceof Player)) continue;
                mob.setTarget(null);
                mob.setLastHurtByMob(null);
            }
        }
        if (player.hasEffect(ModEffects.STICKY_ICKY)) {
            box = player.getBoundingBox().inflate(12.0);
            for (ItemEntity item : level.getEntitiesOfClass(ItemEntity.class, box)) {
                boolean freshNear;
                if (item.isRemoved()) continue;
                int age = item.getAge();
                boolean bl = freshNear = age < 50 && item.distanceToSqr((Entity)player) < 9.0;
                if (freshNear) {
                    int remaining = 50 - age;
                    if (remaining <= 0) continue;
                    item.setPickUpDelay(remaining);
                    continue;
                }
                if (item.hasPickUpDelay()) continue;
                CommonEvents.pullToward((Entity)item, player, 0.35f);
            }
            for (ExperienceOrb xp : level.getEntitiesOfClass(ExperienceOrb.class, box)) {
                if (xp.isRemoved()) continue;
                CommonEvents.pullToward((Entity)xp, player, 0.35f);
            }
        }
    }

    private static void pullToward(Entity e, Player player, float strength) {
        double dx = player.getX() - e.getX();
        double dy = player.getY() + (double)player.getEyeHeight() * 0.4 - e.getY();
        double dz = player.getZ() - e.getZ();
        double d = Math.max(0.25, Math.sqrt(dx * dx + dy * dy + dz * dz));
        double s = (double)strength / d;
        e.setDeltaMovement(e.getDeltaMovement().add(dx * s, dy * s, dz * s));
        e.hurtMarked = true;
    }

    @SubscribeEvent
    public static void onVillagerInteract(PlayerInteractEvent.EntityInteract event) {
        Player player = event.getEntity();
        if (player.level().isClientSide) {
            return;
        }
        Entity entity = event.getTarget();
        if (entity instanceof Villager) {
            Villager villager = (Villager)entity;
            if (player.hasEffect(ModEffects.CHILLOUT)) {
                villager.playSound(SoundEvents.VILLAGER_NO, 1.0f, 1.0f);
            }
            if (player.hasEffect(ModEffects.LINGUISTS_HIGH)) {
                villager.addEffect(new MobEffectInstance(MobEffects.HERO_OF_THE_VILLAGE, 200, 0, false, false));
            }
        }
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)levelAccessor;
        Player player = event.getPlayer();
        if (player == null) {
            return;
        }
        BlockPos pos = event.getPos();
        BlockState state = level.getBlockState(pos);
        if (player.hasEffect(ModEffects.R_TREES) && state.is(BlockTags.LOGS)) {
            CommonEvents.breakConnectedLogs(level, pos, player);
        }
        if (player.hasEffect(ModEffects.VEIN_HIGH) && state.is(Tags.Blocks.ORES)) {
            CommonEvents.veinMine(level, pos, state, player);
        }
    }

    private static void breakConnectedLogs(ServerLevel level, BlockPos start, Player player) {
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        ArrayDeque<BlockPos> q = new ArrayDeque<BlockPos>();
        q.add(start);
        int broken = 0;
        while (!q.isEmpty() && broken < 1024) {
            BlockState s;
            BlockPos p = (BlockPos)q.poll();
            if (!visited.add(p) || !(s = level.getBlockState(p)).is(BlockTags.LOGS)) continue;
            level.destroyBlock(p, true, (Entity)player);
            ++broken;
            for (BlockPos n : BlockPos.betweenClosedStream((BlockPos)p.offset(-1, -1, -1), (BlockPos)p.offset(1, 1, 1)).map(BlockPos::immutable).toList()) {
                if (visited.contains(n)) continue;
                q.add(n);
            }
        }
    }

    private static void veinMine(ServerLevel level, BlockPos start, BlockState target, Player player) {
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        ArrayDeque<BlockPos> q = new ArrayDeque<BlockPos>();
        q.add(start);
        int broken = 0;
        while (!q.isEmpty() && broken < 128) {
            BlockState s;
            BlockPos p = (BlockPos)q.poll();
            if (!visited.add(p) || !(s = level.getBlockState(p)).is(target.getBlock())) continue;
            level.destroyBlock(p, true, (Entity)player);
            ++broken;
            for (BlockPos n : new BlockPos[]{p.north(), p.south(), p.east(), p.west(), p.above(), p.below()}) {
                if (visited.contains(n)) continue;
                q.add(n);
            }
        }
    }

    @SubscribeEvent
    public static void onFuelBurnTime(FurnaceFuelBurnTimeEvent event) {
        if (event.getItemStack().is((Item)ModItems.HEMP_COAL.get())) {
            event.setBurnTime(3200);
        }
    }

    @SubscribeEvent
    public static void onCraftingPreview(PlayerEvent.ItemCraftedEvent event) {
        ItemStack result = event.getCrafting();
        if (result.isEmpty()) {
            return;
        }
        Container inv = event.getInventory();
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            boolean hasWeedData;
            ItemStack src = inv.getItem(i);
            if (src.isEmpty()) continue;
            boolean bl = hasWeedData = src.has((DataComponentType)ModDataComponentTypes.ACTIVE_INGREDIENT.get()) || src.has((DataComponentType)ModDataComponentTypes.THC.get()) || src.has((DataComponentType)ModDataComponentTypes.CBD.get());
            if (!hasWeedData) continue;
            WeedDataUtil.copyWeedComponents(src, result);
            break;
        }
    }

    private static ItemStack findWeedComponentSource(CraftingContainer grid) {
        for (int i = 0; i < grid.getContainerSize(); ++i) {
            boolean hasAny;
            ItemStack s = grid.getItem(i);
            if (s.isEmpty()) continue;
            boolean bl = hasAny = s.get((DataComponentType)ModDataComponentTypes.ACTIVE_INGREDIENT.get()) != null || s.get((DataComponentType)ModDataComponentTypes.EFFECT_DURATION.get()) != null || s.get((DataComponentType)ModDataComponentTypes.THC.get()) != null || s.get((DataComponentType)ModDataComponentTypes.CBD.get()) != null;
            if (!hasAny) continue;
            return s;
        }
        return ItemStack.EMPTY;
    }

    private static boolean contains(CraftingContainer grid, ItemStack needle) {
        for (int i = 0; i < grid.getContainerSize(); ++i) {
            ItemStack s = grid.getItem(i);
            if (s.isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)s, (ItemStack)needle)) continue;
            return true;
        }
        return false;
    }

    private static ItemStack firstMatching(CraftingContainer grid, boolean weedsOnly) {
        for (int i = 0; i < grid.getContainerSize(); ++i) {
            ItemStack s = grid.getItem(i);
            if (s.isEmpty() || weedsOnly && !s.is(ModTags.WEEDS)) continue;
            return s;
        }
        return ItemStack.EMPTY;
    }

    private static boolean anySlotMatches(CraftingContainer grid, Predicate<ItemStack> pred) {
        for (int i = 0; i < grid.getContainerSize(); ++i) {
            ItemStack s = grid.getItem(i);
            if (s.isEmpty() || !pred.test(s)) continue;
            return true;
        }
        return false;
    }

    private static ItemStack firstBag(CraftingContainer grid) {
        for (int i = 0; i < grid.getContainerSize(); ++i) {
            ItemStack s = grid.getItem(i);
            if (s.isEmpty() || !CommonEvents.looksLikeBag(s)) continue;
            return s;
        }
        return ItemStack.EMPTY;
    }

    private static boolean looksLikeBag(ItemStack stack) {
        ResourceLocation key = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
        return key != null && key.getPath().endsWith("_bag");
    }

    @SubscribeEvent
    public static void addCustomTrades(VillagerTradesEvent event) {
        Int2ObjectMap trades;
        if (event.getType() == ModVillagers.STONER.value()) {
            trades = event.getTrades();
            CommonEvents.addRandomTrades((Int2ObjectMap<List<VillagerTrades.ItemListing>>)trades, 1, 2, (pTrader, pRandom) -> new MerchantOffer(new ItemCost(ModItems.HEMP_FIBERS, 18), new ItemStack((ItemLike)Items.EMERALD, 1), 16, 2, 0.01f), (pTrader, pRandom) -> new MerchantOffer(new ItemCost(ModItems.HEMP_COAL, 5), new ItemStack((ItemLike)Items.EMERALD, 1), 16, 2, 0.01f), (pTrader, pRandom) -> new MerchantOffer(new ItemCost(ModItems.DRIED_TOBACCO_LEAF, 8), new ItemStack((ItemLike)Items.EMERALD, 1), 12, 2, 0.01f), (pTrader, pRandom) -> new MerchantOffer(new ItemCost(ModItems.HEMP_LEAF, 5), new ItemStack((ItemLike)Items.EMERALD, 1), 10, 2, 0.01f));
            CommonEvents.addRandomTrades((Int2ObjectMap<List<VillagerTrades.ItemListing>>)trades, 2, 1, (pTrader, pRandom) -> new MerchantOffer(new ItemCost(ModItems.WHITE_WIDOW_BAG, 1), new ItemStack((ItemLike)Items.EMERALD, 1), 10, 5, 0.01f), (pTrader, pRandom) -> new MerchantOffer(new ItemCost(ModItems.BUBBLE_KUSH_BAG, 1), new ItemStack((ItemLike)Items.EMERALD, 1), 10, 5, 0.01f), (pTrader, pRandom) -> new MerchantOffer(new ItemCost(ModItems.LEMON_HAZE_BAG, 1), new ItemStack((ItemLike)Items.EMERALD, 1), 10, 5, 0.01f), (pTrader, pRandom) -> new MerchantOffer(new ItemCost(ModItems.SOUR_DIESEL_BAG, 1), new ItemStack((ItemLike)Items.EMERALD, 1), 10, 5, 0.01f), (pTrader, pRandom) -> new MerchantOffer(new ItemCost(ModItems.BLUE_ICE_BAG, 1), new ItemStack((ItemLike)Items.EMERALD, 1), 10, 5, 0.01f), (pTrader, pRandom) -> new MerchantOffer(new ItemCost(ModItems.BUBBLEGUM_BAG, 1), new ItemStack((ItemLike)Items.EMERALD, 1), 10, 5, 0.01f), (pTrader, pRandom) -> new MerchantOffer(new ItemCost(ModItems.PURPLE_HAZE_BAG, 1), new ItemStack((ItemLike)Items.EMERALD, 1), 10, 5, 0.01f), (pTrader, pRandom) -> new MerchantOffer(new ItemCost(ModItems.OG_KUSH_BAG, 1), new ItemStack((ItemLike)Items.EMERALD, 1), 10, 5, 0.01f), (pTrader, pRandom) -> new MerchantOffer(new ItemCost(ModItems.JACK_HERER_BAG, 1), new ItemStack((ItemLike)Items.EMERALD, 1), 10, 5, 0.01f), (pTrader, pRandom) -> new MerchantOffer(new ItemCost(ModItems.GARY_PEYTON_BAG, 1), new ItemStack((ItemLike)Items.EMERALD, 1), 10, 5, 0.01f), (pTrader, pRandom) -> new MerchantOffer(new ItemCost(ModItems.AMNESIA_HAZE_BAG, 1), new ItemStack((ItemLike)Items.EMERALD, 1), 10, 5, 0.01f), (pTrader, pRandom) -> new MerchantOffer(new ItemCost(ModItems.AK47_BAG, 1), new ItemStack((ItemLike)Items.EMERALD, 1), 10, 5, 0.01f), (pTrader, pRandom) -> new MerchantOffer(new ItemCost(ModItems.GHOST_TRAIN_BAG, 1), new ItemStack((ItemLike)Items.EMERALD, 1), 10, 5, 0.01f), (pTrader, pRandom) -> new MerchantOffer(new ItemCost(ModItems.GRAPE_APE_BAG, 1), new ItemStack((ItemLike)Items.EMERALD, 1), 10, 5, 0.01f), (pTrader, pRandom) -> new MerchantOffer(new ItemCost(ModItems.COTTON_CANDY_BAG, 1), new ItemStack((ItemLike)Items.EMERALD, 1), 10, 5, 0.01f), (pTrader, pRandom) -> new MerchantOffer(new ItemCost(ModItems.BANANA_KUSH_BAG, 1), new ItemStack((ItemLike)Items.EMERALD, 1), 10, 5, 0.01f), (pTrader, pRandom) -> new MerchantOffer(new ItemCost(ModItems.CARBON_FIBER_BAG, 1), new ItemStack((ItemLike)Items.EMERALD, 1), 10, 5, 0.01f), (pTrader, pRandom) -> new MerchantOffer(new ItemCost(ModItems.BIRTHDAY_CAKE_BAG, 1), new ItemStack((ItemLike)Items.EMERALD, 1), 10, 5, 0.01f), (pTrader, pRandom) -> new MerchantOffer(new ItemCost(ModItems.BLUE_COOKIES_BAG, 1), new ItemStack((ItemLike)Items.EMERALD, 1), 10, 5, 0.01f), (pTrader, pRandom) -> new MerchantOffer(new ItemCost(ModItems.AFGHANI_BAG, 1), new ItemStack((ItemLike)Items.EMERALD, 1), 10, 5, 0.01f), (pTrader, pRandom) -> new MerchantOffer(new ItemCost(ModItems.MOONBOW_BAG, 1), new ItemStack((ItemLike)Items.EMERALD, 1), 10, 5, 0.01f), (pTrader, pRandom) -> new MerchantOffer(new ItemCost(ModItems.LAVA_CAKE_BAG, 1), new ItemStack((ItemLike)Items.EMERALD, 1), 10, 5, 0.01f), (pTrader, pRandom) -> new MerchantOffer(new ItemCost(ModItems.JELLY_RANCHER_BAG, 1), new ItemStack((ItemLike)Items.EMERALD, 1), 10, 5, 0.01f), (pTrader, pRandom) -> new MerchantOffer(new ItemCost(ModItems.STRAWBERRY_SHORTCAKE_BAG, 1), new ItemStack((ItemLike)Items.EMERALD, 1), 10, 5, 0.01f), (pTrader, pRandom) -> new MerchantOffer(new ItemCost(ModItems.PINK_KUSH_BAG, 1), new ItemStack((ItemLike)Items.EMERALD, 1), 10, 5, 0.01f));
            CommonEvents.addRandomTrades((Int2ObjectMap<List<VillagerTrades.ItemListing>>)trades, 2, 1, (pTrader, pRandom) -> new MerchantOffer(new ItemCost(ModItems.TOBACCO, 10), new ItemStack((ItemLike)Items.EMERALD, 1), 6, 5, 0.01f), (pTrader, pRandom) -> new MerchantOffer(new ItemCost(ModItems.BIO_COMPOSITE, 1), new ItemStack((ItemLike)Items.EMERALD, 3), 8, 5, 0.01f));
            CommonEvents.addRandomTrades((Int2ObjectMap<List<VillagerTrades.ItemListing>>)trades, 3, 2, (pTrader, pRandom) -> new MerchantOffer(new ItemCost(ModFluids.HASH_OIL_BUCKET, 1), new ItemStack((ItemLike)Items.EMERALD, 3), 4, 10, 0.01f), (pTrader, pRandom) -> new MerchantOffer(new ItemCost(ModFluids.HEMP_OIL_BUCKET, 1), new ItemStack((ItemLike)Items.EMERALD, 3), 4, 10, 0.01f), (pTrader, pRandom) -> new MerchantOffer(new ItemCost(ModItems.EMPTY_TINCTURE, 4), new ItemStack((ItemLike)Items.EMERALD, 1), 4, 10, 0.01f), (pTrader, pRandom) -> new MerchantOffer(new ItemCost(ModItems.INFUSED_BUTTER, 3), new ItemStack((ItemLike)Items.EMERALD, 1), 7, 10, 0.01f));
            CommonEvents.addRandomTrades((Int2ObjectMap<List<VillagerTrades.ItemListing>>)trades, 4, 2, (pTrader, pRandom) -> new MerchantOffer(new ItemCost(ModItems.WEED_COOKIE, 1), new ItemStack((ItemLike)Items.EMERALD, 2), 8, 15, 0.01f), (pTrader, pRandom) -> new MerchantOffer(new ItemCost(ModItems.HASH_BROWNIE, 1), new ItemStack((ItemLike)Items.EMERALD, 3), 6, 15, 0.01f), (pTrader, pRandom) -> new MerchantOffer(new ItemCost(ModItems.DAB_RIG, 1), new ItemStack((ItemLike)Items.EMERALD, 3), 1, 15, 0.01f), (pTrader, pRandom) -> new MerchantOffer(new ItemCost(ModItems.BONG, 1), new ItemStack((ItemLike)Items.EMERALD, 4), 1, 15, 0.01f));
            CommonEvents.addRandomTrades((Int2ObjectMap<List<VillagerTrades.ItemListing>>)trades, 5, 2, (pTrader, pRandom) -> new MerchantOffer(new ItemCost(ModItems.HERB_CAKE, 1), new ItemStack((ItemLike)Items.EMERALD, 6), 4, 20, 0.01f), (pTrader, pRandom) -> new MerchantOffer(new ItemCost(ModItems.HASH_OIL_TINCTURE, 1), new ItemStack((ItemLike)Items.EMERALD, 5), 4, 20, 0.01f), (pTrader, pRandom) -> new MerchantOffer(new ItemCost(ModItems.BLUNT, 2), new ItemStack((ItemLike)Items.EMERALD, 3), 6, 20, 0.01f), (pTrader, pRandom) -> new MerchantOffer(new ItemCost(ModItems.JOINT, 3), new ItemStack((ItemLike)Items.EMERALD, 2), 8, 20, 0.01f));
        }
        if (event.getType() == ModVillagers.DEALER.value()) {
            trades = event.getTrades();
            ((List)trades.get(1)).add((pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)ModItems.HEMP_SEEDS.get(), 1), 16, 2, 0.01f));
            ((List)trades.get(1)).add((pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)ModItems.TOBACCO_SEEDS.get(), 1), 16, 2, 0.01f));
            CommonEvents.addRandomTrades((Int2ObjectMap<List<VillagerTrades.ItemListing>>)trades, 2, 1, (pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 4), new ItemStack((ItemLike)ModItems.WHITE_WIDOW_WEED.get(), 1), 6, 5, 0.01f), (pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 4), new ItemStack((ItemLike)ModItems.BUBBLE_KUSH_WEED.get(), 1), 6, 5, 0.01f), (pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 5), new ItemStack((ItemLike)ModItems.LEMON_HAZE_WEED.get(), 1), 6, 5, 0.01f), (pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 4), new ItemStack((ItemLike)ModItems.SOUR_DIESEL_WEED.get(), 1), 6, 5, 0.01f), (pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 4), new ItemStack((ItemLike)ModItems.BLUE_ICE_WEED.get(), 1), 6, 5, 0.01f), (pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 5), new ItemStack((ItemLike)ModItems.BUBBLEGUM_WEED.get(), 1), 6, 5, 0.01f), (pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 6), new ItemStack((ItemLike)ModItems.PURPLE_HAZE_WEED.get(), 1), 6, 5, 0.01f), (pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 3), new ItemStack((ItemLike)ModItems.OG_KUSH_WEED.get(), 1), 6, 5, 0.01f), (pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 4), new ItemStack((ItemLike)ModItems.JACK_HERER_WEED.get(), 1), 6, 5, 0.01f), (pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 5), new ItemStack((ItemLike)ModItems.GARY_PEYTON_WEED.get(), 1), 6, 5, 0.01f), (pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 6), new ItemStack((ItemLike)ModItems.AMNESIA_HAZE_WEED.get(), 1), 6, 5, 0.01f), (pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 5), new ItemStack((ItemLike)ModItems.AK47_WEED.get(), 1), 6, 5, 0.01f), (pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 4), new ItemStack((ItemLike)ModItems.GHOST_TRAIN_WEED.get(), 1), 6, 5, 0.01f), (pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 6), new ItemStack((ItemLike)ModItems.GRAPE_APE_WEED.get(), 1), 6, 5, 0.01f), (pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 6), new ItemStack((ItemLike)ModItems.COTTON_CANDY_WEED.get(), 1), 6, 5, 0.01f), (pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 5), new ItemStack((ItemLike)ModItems.BANANA_KUSH_WEED.get(), 1), 6, 5, 0.01f), (pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 4), new ItemStack((ItemLike)ModItems.CARBON_FIBER_WEED.get(), 1), 6, 5, 0.01f), (pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 6), new ItemStack((ItemLike)ModItems.BIRTHDAY_CAKE_WEED.get(), 1), 6, 5, 0.01f), (pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 5), new ItemStack((ItemLike)ModItems.BLUE_COOKIES_WEED.get(), 1), 6, 5, 0.01f), (pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 6), new ItemStack((ItemLike)ModItems.AFGHANI_WEED.get(), 1), 6, 5, 0.01f), (pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 4), new ItemStack((ItemLike)ModItems.MOONBOW_WEED.get(), 1), 6, 5, 0.01f), (pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 6), new ItemStack((ItemLike)ModItems.LAVA_CAKE_WEED.get(), 1), 6, 5, 0.01f), (pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 5), new ItemStack((ItemLike)ModItems.JELLY_RANCHER_WEED.get(), 1), 6, 5, 0.01f), (pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 6), new ItemStack((ItemLike)ModItems.STRAWBERRY_SHORTCAKE_WEED.get(), 1), 6, 5, 0.01f), (pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 5), new ItemStack((ItemLike)ModItems.PINK_KUSH_WEED.get(), 1), 6, 5, 0.01f));
            CommonEvents.addRandomTrades((Int2ObjectMap<List<VillagerTrades.ItemListing>>)trades, 2, 1, (pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 4), new ItemStack((ItemLike)ModItems.WHITE_WIDOW_GUMMY.get(), 1), 4, 5, 0.01f), (pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 4), new ItemStack((ItemLike)ModItems.BUBBLE_KUSH_GUMMY.get(), 1), 4, 5, 0.01f), (pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 5), new ItemStack((ItemLike)ModItems.LEMON_HAZE_GUMMY.get(), 1), 4, 5, 0.01f), (pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 4), new ItemStack((ItemLike)ModItems.SOUR_DIESEL_GUMMY.get(), 1), 4, 5, 0.01f), (pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 4), new ItemStack((ItemLike)ModItems.BLUE_ICE_GUMMY.get(), 1), 4, 5, 0.01f), (pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 5), new ItemStack((ItemLike)ModItems.BUBBLEGUM_GUMMY.get(), 1), 4, 5, 0.01f), (pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 6), new ItemStack((ItemLike)ModItems.PURPLE_HAZE_GUMMY.get(), 1), 4, 5, 0.01f), (pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 3), new ItemStack((ItemLike)ModItems.OG_KUSH_GUMMY.get(), 1), 4, 5, 0.01f), (pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 4), new ItemStack((ItemLike)ModItems.JACK_HERER_GUMMY.get(), 1), 4, 5, 0.01f), (pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 5), new ItemStack((ItemLike)ModItems.GARY_PEYTON_GUMMY.get(), 1), 4, 5, 0.01f), (pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 6), new ItemStack((ItemLike)ModItems.AMNESIA_HAZE_GUMMY.get(), 1), 4, 5, 0.01f), (pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 5), new ItemStack((ItemLike)ModItems.AK47_GUMMY.get(), 1), 4, 5, 0.01f), (pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 4), new ItemStack((ItemLike)ModItems.GHOST_TRAIN_GUMMY.get(), 1), 4, 5, 0.01f), (pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 6), new ItemStack((ItemLike)ModItems.GRAPE_APE_GUMMY.get(), 1), 4, 5, 0.01f), (pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 6), new ItemStack((ItemLike)ModItems.COTTON_CANDY_GUMMY.get(), 1), 4, 5, 0.01f), (pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 5), new ItemStack((ItemLike)ModItems.BANANA_KUSH_GUMMY.get(), 1), 4, 5, 0.01f), (pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 4), new ItemStack((ItemLike)ModItems.CARBON_FIBER_GUMMY.get(), 1), 4, 5, 0.01f), (pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 6), new ItemStack((ItemLike)ModItems.BIRTHDAY_CAKE_GUMMY.get(), 1), 4, 5, 0.01f), (pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 5), new ItemStack((ItemLike)ModItems.BLUE_COOKIES_GUMMY.get(), 1), 4, 5, 0.01f), (pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 6), new ItemStack((ItemLike)ModItems.AFGHANI_GUMMY.get(), 1), 4, 5, 0.01f), (pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 4), new ItemStack((ItemLike)ModItems.MOONBOW_GUMMY.get(), 1), 4, 5, 0.01f), (pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 6), new ItemStack((ItemLike)ModItems.LAVA_CAKE_GUMMY.get(), 1), 4, 5, 0.01f), (pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 5), new ItemStack((ItemLike)ModItems.JELLY_RANCHER_GUMMY.get(), 1), 4, 5, 0.01f), (pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 6), new ItemStack((ItemLike)ModItems.STRAWBERRY_SHORTCAKE_GUMMY.get(), 1), 4, 5, 0.01f), (pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 5), new ItemStack((ItemLike)ModItems.PINK_KUSH_GUMMY.get(), 1), 4, 5, 0.01f));
            CommonEvents.addRandomTrades((Int2ObjectMap<List<VillagerTrades.ItemListing>>)trades, 3, 2, (pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 5), new ItemStack((ItemLike)ModItems.BASE_EXTRACT.get(), 1), 8, 10, 0.01f), (pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 8), new ItemStack((ItemLike)ModFluids.HASH_OIL_BUCKET.get(), 1), 4, 10, 0.01f), (pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 7), new ItemStack((ItemLike)ModFluids.HEMP_OIL_BUCKET.get(), 1), 4, 10, 0.01f), (pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 4), new ItemStack((ItemLike)ModItems.BUTTER.get(), 1), 6, 10, 0.01f), (pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 14), new ItemStack((ItemLike)ModItems.DNA_STRAND.get(), 1), 6, 10, 0.01f));
            CommonEvents.addRandomTrades((Int2ObjectMap<List<VillagerTrades.ItemListing>>)trades, 4, 2, (pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 5), new ItemStack((ItemLike)ModItems.BIO_COMPOSITE.get(), 1), 10, 10, 0.01f), (pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 10), new ItemStack((ItemLike)ModItems.DUAL_ARC_LAMP.get(), 1), 2, 10, 0.01f), (pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 8), new ItemStack((ItemLike)ModItems.HEMP_PLASTIC.get(), 1), 6, 10, 0.01f), (pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 7), new ItemStack((ItemLike)ModItems.UNFINISHED_HEMP_CORE.get(), 1), 2, 10, 0.01f), (pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 4), new ItemStack((ItemLike)ModItems.INFUSED_BUTTER.get(), 1), 4, 10, 0.01f), (pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 14), new ItemStack((ItemLike)ModItems.CAT_URINE_BOTTLE.get(), 1), 2, 10, 0.01f));
            CommonEvents.addRandomTrades((Int2ObjectMap<List<VillagerTrades.ItemListing>>)trades, 5, 2, (pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 10), new ItemStack((ItemLike)ModItems.DNA_STRAND.get(), 1), 4, 20, 0.01f), (pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 14), new ItemStack((ItemLike)ModItems.HEMP_CORE.get(), 1), 2, 20, 0.01f), (pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 8), new ItemStack((ItemLike)ModItems.HASH_OIL_TINCTURE.get(), 1), 2, 20, 0.01f), (pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 13), new ItemStack((ItemLike)ModItems.MANUAL_GRINDER.get(), 1), 1, 20, 0.01f), (pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 16), new ItemStack((ItemLike)ModItems.HEMP_HAMMER.get(), 1), 1, 20, 0.01f));
        }
    }

    private static void addRandomTrades(Int2ObjectMap<List<VillagerTrades.ItemListing>> trades, int level, int pick, VillagerTrades.ItemListing ... candidates) {
        ArrayList<VillagerTrades.ItemListing> pool = new ArrayList<VillagerTrades.ItemListing>(List.of(candidates));
        Collections.shuffle(pool);
        List levelList = (List)trades.get(level);
        levelList.addAll(pool.subList(0, Math.min(pick, pool.size())));
    }
}

