/*
 * Decompiled with CFR 0.152.
 */
package net.micaxs.smokeleaf.item.custom;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.LinkedHashMap;
import java.util.List;
import net.micaxs.smokeleaf.component.ModDataComponentTypes;
import net.micaxs.smokeleaf.item.custom.BaseWeedItem;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;

public class BluntItem
extends Item {
    public static final int BASE_USE_TICKS = 40;

    public BluntItem(Item.Properties props) {
        super(props);
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 40;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        player.startUsingItem(hand);
        return InteractionResultHolder.consume((Object)stack);
    }

    public void onUseTick(Level level, LivingEntity entity, ItemStack stack, int remainingUseDuration) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        int elapsed = 40 - remainingUseDuration;
        if (!level.isClientSide) {
            if (elapsed == 1) {
                // empty if block
            }
            return;
        }
        if (remainingUseDuration % 4 == 0) {
            RandomSource r = level.getRandom();
            double dx = entity.getRandomX(0.3);
            double dy = entity.getY() + (double)entity.getBbHeight() * 0.7;
            double dz = entity.getRandomZ(0.3);
            level.addParticle((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, dx, dy, dz, (r.nextDouble() - 0.5) * 0.01, 0.02, (r.nextDouble() - 0.5) * 0.01);
        }
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity entity) {
        if (!level.isClientSide && entity instanceof Player) {
            Player player = (Player)entity;
            this.applyStoredEffects(stack, player);
            if (!player.getAbilities().instabuild) {
                stack.shrink(1);
            }
        }
        return stack;
    }

    private void applyStoredEffects(ItemStack stack, Player player) {
        JsonArray arr = (JsonArray)stack.get((DataComponentType)ModDataComponentTypes.ACTIVE_INGREDIENTS.get());
        if (arr == null) {
            return;
        }
        HolderLookup.RegistryLookup effectLookup = player.level().registryAccess().lookupOrThrow(Registries.MOB_EFFECT);
        for (int i = 0; i < arr.size(); ++i) {
            JsonObject obj = arr.get(i).getAsJsonObject();
            ResourceLocation rl = ResourceLocation.tryParse((String)obj.get("id").getAsString());
            if (rl == null) continue;
            int addDuration = obj.get("duration").getAsInt();
            int addAmplifier = obj.get("amp").getAsInt();
            ResourceKey key = ResourceKey.create((ResourceKey)Registries.MOB_EFFECT, (ResourceLocation)rl);
            effectLookup.get(key).ifPresent(effectHolder -> {
                MobEffectInstance existing = player.getEffect((Holder)effectHolder);
                if (existing != null) {
                    int newDuration = existing.getDuration() + addDuration;
                    int newAmplifier = Math.max(existing.getAmplifier(), addAmplifier);
                    player.removeEffect((Holder)effectHolder);
                    player.addEffect(new MobEffectInstance((Holder)effectHolder, newDuration, newAmplifier));
                } else {
                    player.addEffect(new MobEffectInstance((Holder)effectHolder, addDuration, addAmplifier));
                }
            });
        }
    }

    public static void storeWeeds(ItemStack joint, List<ItemStack> weeds) {
        JsonArray effectArray = new JsonArray();
        LinkedHashMap<String, JsonObject> merged = new LinkedHashMap<String, JsonObject>();
        ItemStack firstWeed = null;
        for (ItemStack w : weeds) {
            Item item = w.getItem();
            if (!(item instanceof BaseWeedItem)) continue;
            BaseWeedItem weed = (BaseWeedItem)item;
            if (firstWeed == null) {
                firstWeed = w;
            }
            weed.initializeStack(w);
            MobEffect eff = weed.getEffect(w);
            if (eff == null) continue;
            String id = BuiltInRegistries.MOB_EFFECT.getKey((Object)eff).toString();
            int baseDuration = weed.getDuration(w);
            int doubledDuration = baseDuration * 2;
            int amp = weed.getEffectAmplifier();
            if (merged.containsKey(id)) {
                JsonObject existing = (JsonObject)merged.get(id);
                existing.addProperty("duration", (Number)(existing.get("duration").getAsInt() + doubledDuration));
                continue;
            }
            JsonObject obj = new JsonObject();
            obj.addProperty("id", id);
            obj.addProperty("duration", (Number)doubledDuration);
            obj.addProperty("amp", (Number)amp);
            merged.put(id, obj);
        }
        merged.values().forEach(arg_0 -> ((JsonArray)effectArray).add(arg_0));
        joint.set((DataComponentType)ModDataComponentTypes.ACTIVE_INGREDIENTS.get(), (Object)effectArray);
        int distinctEffects = merged.size();
        if (distinctEffects == 0) {
            joint.remove(DataComponents.CUSTOM_NAME);
        } else if (distinctEffects > 1) {
            joint.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)"item.smokeleafindustries.blunt.mixed"));
        } else if (firstWeed != null) {
            Component weedName = firstWeed.getHoverName();
            joint.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)"item.smokeleafindustries.blunt.format", (Object[])new Object[]{weedName}));
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        JsonArray arr = (JsonArray)stack.get((DataComponentType)ModDataComponentTypes.ACTIVE_INGREDIENTS.get());
        if (arr == null || arr.isEmpty()) {
            tooltip.add((Component)Component.translatable((String)"tooltip.smokeleafindustries.blunt.empty").withStyle(ChatFormatting.GRAY));
            return;
        }
        tooltip.add((Component)Component.literal((String)"Blunt Effects:").withStyle(ChatFormatting.GOLD));
        for (int i = 0; i < arr.size(); ++i) {
            MobEffect eff;
            JsonObject obj = arr.get(i).getAsJsonObject();
            ResourceLocation rl = ResourceLocation.tryParse((String)obj.get("id").getAsString());
            int dur = obj.get("duration").getAsInt();
            int amp = obj.get("amp").getAsInt();
            MutableComponent nameComp = rl != null ? ((eff = (MobEffect)BuiltInRegistries.MOB_EFFECT.get(rl)) != null ? Component.translatable((String)eff.getDescriptionId()) : Component.literal((String)rl.getPath())) : Component.literal((String)"unknown");
            tooltip.add((Component)Component.literal((String)" - ").append((Component)nameComp.copy().withStyle(ChatFormatting.DARK_GREEN)).append((Component)Component.literal((String)(" " + (amp + 1) + " (" + dur / 20 + "s)")).withStyle(ChatFormatting.DARK_GREEN)));
        }
    }
}

