/*
 * Decompiled with CFR 0.152.
 */
package net.micaxs.smokeleaf.item.custom;

import java.util.ArrayList;
import java.util.List;
import net.micaxs.smokeleaf.component.DNAContents;
import net.micaxs.smokeleaf.component.ModDataComponentTypes;
import net.micaxs.smokeleaf.recipe.ModRecipes;
import net.micaxs.smokeleaf.recipe.SequencerRecipe;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class DNAStrandItem
extends Item {
    public DNAStrandItem(Item.Properties properties) {
        super(properties);
    }

    public static DNAContents getContents(ItemStack dnaStrand) {
        return (DNAContents)dnaStrand.getOrDefault((DataComponentType)ModDataComponentTypes.DNA_CONTENTS.get(), (Object)DNAContents.EMPTY);
    }

    public static void setContents(ItemStack dnaStrand, DNAContents contents) {
        dnaStrand.set((DataComponentType)ModDataComponentTypes.DNA_CONTENTS.get(), (Object)contents);
    }

    public static boolean isFull(ItemStack dnaStrand) {
        return DNAStrandItem.getContents(dnaStrand).isFull();
    }

    public static boolean addItem(ItemStack dnaStrand, ItemStack toInsert) {
        if (!(dnaStrand.getItem() instanceof DNAStrandItem) || toInsert.isEmpty()) {
            return false;
        }
        DNAContents contents = DNAStrandItem.getContents(dnaStrand);
        for (int i = 0; i < 3; ++i) {
            if (!contents.get(i).isEmpty()) continue;
            DNAStrandItem.setContents(dnaStrand, contents.with(i, toInsert.copyWithCount(1)));
            toInsert.shrink(1);
            return true;
        }
        return false;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        Level level;
        DNAContents contents = DNAStrandItem.getContents(stack);
        int shown = 0;
        for (int i = 0; i < 3; ++i) {
            ItemStack slot = contents.get(i);
            if (slot.isEmpty()) continue;
            if (shown == 0) {
                tooltipComponents.add((Component)Component.literal((String)"Contents:").withStyle(ChatFormatting.GOLD));
            }
            tooltipComponents.add((Component)slot.getHoverName().copy().withStyle(ChatFormatting.AQUA));
            ++shown;
        }
        if (shown == 0) {
            tooltipComponents.add((Component)Component.literal((String)"Empty").withStyle(ChatFormatting.DARK_GRAY));
        }
        if ((level = context.level()) != null && contents.isFull()) {
            if (DNAStrandItem.isValidCombination(level, contents)) {
                tooltipComponents.add((Component)Component.literal((String)"Valid Strain").withStyle(ChatFormatting.GREEN));
            } else {
                tooltipComponents.add((Component)Component.literal((String)"Invalid Strain").withStyle(ChatFormatting.RED));
            }
        }
    }

    private static boolean isValidCombination(Level level, DNAContents contents) {
        if (!contents.isFull()) {
            return false;
        }
        ArrayList<ItemStack> inside = new ArrayList<ItemStack>(3);
        for (int i = 0; i < 3; ++i) {
            inside.add(contents.get(i));
        }
        List recipes = level.getRecipeManager().getAllRecipesFor((RecipeType)ModRecipes.SEQUENCER_TYPE.get());
        block1: for (RecipeHolder holder : recipes) {
            SequencerRecipe recipe = (SequencerRecipe)holder.value();
            Ingredient[] required = recipe.requiredReagents();
            if (required.length != inside.size()) continue;
            boolean[] used = new boolean[inside.size()];
            for (int r = 0; r < required.length; ++r) {
                boolean matched = false;
                for (int i = 0; i < inside.size(); ++i) {
                    if (used[i] || !required[r].test((ItemStack)inside.get(i))) continue;
                    used[i] = true;
                    matched = true;
                    break;
                }
                if (!matched) continue block1;
            }
            return true;
        }
        return false;
    }
}

