/*
 * Decompiled with CFR 0.152.
 */
package net.micaxs.smokeleaf.item.custom;

import java.util.List;
import net.micaxs.smokeleaf.block.custom.BaseWeedCropBlock;
import net.micaxs.smokeleaf.block.entity.BaseWeedCropBlockEntity;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class FertilizerItem
extends Item {
    private final int nitrogen;
    private final int phosphorus;
    private final int potassium;

    public FertilizerItem(int n, int p, int k, Item.Properties properties) {
        super(properties);
        this.nitrogen = n;
        this.phosphorus = p;
        this.potassium = k;
    }

    public int getN() {
        return this.nitrogen;
    }

    public int getP() {
        return this.phosphorus;
    }

    public int getK() {
        return this.potassium;
    }

    public InteractionResult useOn(UseOnContext context) {
        BaseWeedCropBlockEntity be;
        BaseWeedCropBlock bottomCrop;
        BlockState bottomState;
        Block block;
        BlockPos clickedPos;
        Level level = context.getLevel();
        BlockState clickedState = level.getBlockState(clickedPos = context.getClickedPos());
        Block block2 = clickedState.getBlock();
        if (!(block2 instanceof BaseWeedCropBlock)) {
            return InteractionResult.PASS;
        }
        BaseWeedCropBlock weedBlock = (BaseWeedCropBlock)block2;
        BlockPos bePos = clickedPos;
        if (clickedState.hasProperty((Property)weedBlock.getTop()) && ((Boolean)clickedState.getValue((Property)weedBlock.getTop())).booleanValue()) {
            bePos = clickedPos.below();
        }
        if ((block = (bottomState = level.getBlockState(bePos)).getBlock()) instanceof BaseWeedCropBlock && (bottomCrop = (BaseWeedCropBlock)block).isMaxAge(bottomState)) {
            if (!level.isClientSide() && context.getPlayer() != null) {
                context.getPlayer().displayClientMessage((Component)Component.translatable((String)"tooltip.smokeleafindustries.add_fertilizer"), true);
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        if (!level.isClientSide && (be = FertilizerItem.getCropBE(level, bePos)) != null) {
            be.addNitrogen(this.nitrogen);
            be.addPhosphorus(this.phosphorus);
            be.addPotassium(this.potassium);
            be.sync();
            if (context.getPlayer() != null && !context.getPlayer().getAbilities().instabuild) {
                ItemStack stack = context.getItemInHand();
                stack.shrink(1);
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    private static BaseWeedCropBlockEntity getCropBE(Level level, BlockPos pos) {
        BaseWeedCropBlockEntity crop;
        BlockEntity be = level.getBlockEntity(pos);
        return be instanceof BaseWeedCropBlockEntity ? (crop = (BaseWeedCropBlockEntity)be) : null;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        FertilizerItem.addStat(tooltip, "Nitrogen (N): ", this.getN(), ChatFormatting.DARK_GREEN);
        FertilizerItem.addStat(tooltip, "Phosphorus (P): ", this.getP(), ChatFormatting.DARK_AQUA);
        FertilizerItem.addStat(tooltip, "Potassium (K): ", this.getK(), ChatFormatting.GOLD);
    }

    private static void addStat(List<Component> tooltip, String label, int value, ChatFormatting labelColor) {
        tooltip.add((Component)Component.literal((String)label).withStyle(labelColor).append((Component)Component.literal((String)String.format("%+d", value)).withStyle(ChatFormatting.GRAY)));
    }
}

