/*
 * Decompiled with CFR 0.152.
 */
package net.micaxs.smokeleaf.item.custom;

import java.util.List;
import net.micaxs.smokeleaf.effect.ModEffects;
import net.micaxs.smokeleaf.item.custom.BaseWeedItem;
import net.micaxs.smokeleaf.utils.WeedEffectHelper;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;

public class WeedDerivedItem
extends Item {
    private final float effectDurationMultiplier;
    private final float stonedChance;
    private final UseAnim useAnimation;
    private final int useDuration;

    public WeedDerivedItem(Item.Properties pProperties, float effectDurationMultiplier, float stonedChance, UseAnim useAnimation) {
        this(pProperties, effectDurationMultiplier, stonedChance, useAnimation, 20);
    }

    public WeedDerivedItem(Item.Properties pProperties, float effectDurationMultiplier, float stonedChance, UseAnim useAnimation, int useDuration) {
        super(pProperties);
        this.effectDurationMultiplier = effectDurationMultiplier;
        this.stonedChance = stonedChance;
        this.useAnimation = useAnimation;
        this.useDuration = useDuration;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return this.useAnimation;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return this.useDuration;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        if (usedHand == InteractionHand.MAIN_HAND) {
            ItemStack itemstack = player.getItemInHand(usedHand);
            player.startUsingItem(usedHand);
            return InteractionResultHolder.consume((Object)itemstack);
        }
        return InteractionResultHolder.pass((Object)player.getItemInHand(usedHand));
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity livingEntity) {
        CustomData custom;
        ItemStack mainHandItem = livingEntity.getItemInHand(InteractionHand.MAIN_HAND);
        this.spawnSmokeParticles(level, livingEntity);
        Holder<MobEffect> stonedHolder = WeedDerivedItem.resolveModEffectHolder(level);
        if (level.random.nextDouble() <= (double)this.stonedChance) {
            int previousStonedDuration = 0;
            if (livingEntity.hasEffect(stonedHolder)) {
                previousStonedDuration = livingEntity.getEffect(stonedHolder).getDuration();
            }
            livingEntity.addEffect(new MobEffectInstance(stonedHolder, previousStonedDuration + 200, 1));
        }
        if ((custom = (CustomData)mainHandItem.get(DataComponents.CUSTOM_DATA)) != null && !custom.isEmpty()) {
            CompoundTag tag = custom.copyTag();
            BaseWeedItem activeWeedIngredient = WeedEffectHelper.getActiveWeedIngredient(mainHandItem);
            if (tag.contains("duration") && activeWeedIngredient != null) {
                int duration = tag.getInt("duration");
                MobEffect rawEffect = activeWeedIngredient.getEffect();
                Holder<MobEffect> effectHolder = WeedDerivedItem.mobEffectToHolder(rawEffect, level);
                int previousEffectDuration = 0;
                if (livingEntity.hasEffect(effectHolder)) {
                    previousEffectDuration = livingEntity.getEffect(effectHolder).getDuration();
                }
                livingEntity.addEffect(new MobEffectInstance(effectHolder, previousEffectDuration + duration, activeWeedIngredient.getEffectAmplifier()));
            }
            mainHandItem.shrink(1);
        }
        return super.finishUsingItem(stack, level, livingEntity);
    }

    private static Holder<MobEffect> resolveModEffectHolder(Level level) {
        Holder<MobEffect> h = ModEffects.STONED;
        if (h.value() instanceof MobEffect) {
            Holder<MobEffect> cast = h;
            return cast;
        }
        MobEffect effect = (MobEffect)ModEffects.STONED.value();
        return WeedDerivedItem.mobEffectToHolder(effect, level);
    }

    private static Holder<MobEffect> mobEffectToHolder(MobEffect effect, Level level) {
        return (Holder)BuiltInRegistries.MOB_EFFECT.getResourceKey((Object)effect).flatMap(key -> level.registryAccess().registryOrThrow(Registries.MOB_EFFECT).getHolder(key)).orElseThrow(() -> new IllegalStateException("Unregistered MobEffect: " + String.valueOf(effect)));
    }

    private void spawnSmokeParticles(Level level, LivingEntity entity) {
        for (int i = 0; i < 10; ++i) {
            double xOffset = level.random.nextGaussian() * 0.02;
            double yOffset = level.random.nextGaussian() * 0.02;
            double zOffset = level.random.nextGaussian() * 0.02;
            level.addParticle((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, entity.getX() + (double)entity.getBbWidth() * (level.random.nextDouble() - 0.5), entity.getEyeY(), entity.getZ() + (double)entity.getBbWidth() * (level.random.nextDouble() - 0.5), xOffset, yOffset, zOffset);
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        CustomData custom = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        if (custom != null && !custom.isEmpty()) {
            CompoundTag tag = custom.copyTag();
            if (!tag.contains("duration")) {
                return;
            }
            BaseWeedItem activeIngredient = WeedEffectHelper.getActiveWeedIngredient(stack);
            if (activeIngredient == null) {
                return;
            }
            tooltipComponents.add(WeedEffectHelper.getEffectTooltip(activeIngredient.getEffect(), tag.getInt("duration"), !activeIngredient.isVariableDuration()));
        }
    }

    public float getEffectFactor() {
        return this.effectDurationMultiplier;
    }
}

