/*
 * Decompiled with CFR 0.152.
 */
package net.micaxs.smokeleaf.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.micaxs.smokeleaf.recipe.GeneratorRecipeInput;
import net.micaxs.smokeleaf.recipe.ModRecipes;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public record GeneratorRecipe(Ingredient ingredient, int totalEnergy) implements Recipe<GeneratorRecipeInput>
{
    public static final int ENERGY_PER_TICK = 40;

    public int computedBurnTime() {
        return (int)Math.ceil((double)this.totalEnergy / 40.0);
    }

    public boolean matches(GeneratorRecipeInput input, Level level) {
        if (level.isClientSide()) {
            return false;
        }
        return this.ingredient.test(input.getItem(0));
    }

    public ItemStack assemble(GeneratorRecipeInput input, HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int w, int h) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    public NonNullList<Ingredient> getIngredients() {
        NonNullList list = NonNullList.create();
        list.add((Object)this.ingredient);
        return list;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipes.GENERATOR_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)ModRecipes.GENERATOR_TYPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<GeneratorRecipe> {
        public static final MapCodec<GeneratorRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(GeneratorRecipe::ingredient), (App)Codec.INT.fieldOf("total_energy").forGetter(GeneratorRecipe::totalEnergy)).apply((Applicative)inst, GeneratorRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, GeneratorRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, GeneratorRecipe::ingredient, (StreamCodec)ByteBufCodecs.VAR_INT, GeneratorRecipe::totalEnergy, GeneratorRecipe::new);

        public MapCodec<GeneratorRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, GeneratorRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

