/*
 * Decompiled with CFR 0.152.
 */
package net.micaxs.smokeleaf.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.micaxs.smokeleaf.recipe.LiquifierRecipeInput;
import net.micaxs.smokeleaf.recipe.ModRecipes;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IdMap;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;

public record LiquifierRecipe(Ingredient ingredient, FluidStack output) implements Recipe<LiquifierRecipeInput>
{
    public FluidStack outputCopy() {
        return this.output.copy();
    }

    public boolean matches(LiquifierRecipeInput input, Level level) {
        return this.ingredient.test(input.getItem(0));
    }

    public ItemStack assemble(LiquifierRecipeInput input, HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int w, int h) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    public NonNullList<Ingredient> getIngredients() {
        NonNullList list = NonNullList.create();
        list.add((Object)this.ingredient);
        return list;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipes.LIQUIFIER_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)ModRecipes.LIQUIFIER_TYPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<LiquifierRecipe> {
        private static final MapCodec<FluidStack> FLUID_STACK_OBJECT = RecordCodecBuilder.mapCodec(inst -> inst.group((App)BuiltInRegistries.FLUID.byNameCodec().fieldOf("fluid").forGetter(FluidStack::getFluid), (App)Codec.INT.fieldOf("amount").forGetter(FluidStack::getAmount)).apply((Applicative)inst, (fluid, amt) -> new FluidStack(fluid, amt.intValue())));
        public static final MapCodec<LiquifierRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(LiquifierRecipe::ingredient), (App)FLUID_STACK_OBJECT.fieldOf("output").forGetter(LiquifierRecipe::output)).apply((Applicative)inst, LiquifierRecipe::new));
        private static final StreamCodec<RegistryFriendlyByteBuf, FluidStack> FLUID_STACK_STREAM_CODEC = StreamCodec.of((buf, stack) -> {
            ByteBufCodecs.idMapper((IdMap)BuiltInRegistries.FLUID).encode(buf, (Object)stack.getFluid());
            buf.writeVarInt(stack.getAmount());
        }, buf -> {
            Fluid f = (Fluid)ByteBufCodecs.idMapper((IdMap)BuiltInRegistries.FLUID).decode(buf);
            int amt = buf.readVarInt();
            return new FluidStack(f, amt);
        });
        public static final StreamCodec<RegistryFriendlyByteBuf, LiquifierRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, LiquifierRecipe::ingredient, FLUID_STACK_STREAM_CODEC, LiquifierRecipe::output, LiquifierRecipe::new);

        public MapCodec<LiquifierRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, LiquifierRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

